/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.container.cgroup;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.storm.DaemonConfig;
import org.apache.storm.container.ResourceIsolationInterface;
import org.apache.storm.container.cgroup.CgroupCenter;
import org.apache.storm.container.cgroup.CgroupCommon;
import org.apache.storm.container.cgroup.Hierarchy;
import org.apache.storm.container.cgroup.SubSystemType;
import org.apache.storm.container.cgroup.core.CpuCore;
import org.apache.storm.container.cgroup.core.MemoryCore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CgroupManager
implements ResourceIsolationInterface {
    private static final Logger LOG = LoggerFactory.getLogger(CgroupManager.class);
    private CgroupCenter center;
    private Hierarchy hierarchy;
    private CgroupCommon rootCgroup;
    private String rootDir;
    private Map<String, Object> conf;

    @Override
    public void prepare(Map<String, Object> conf) throws IOException {
        this.conf = conf;
        this.rootDir = DaemonConfig.getCgroupRootDir(this.conf);
        if (this.rootDir == null) {
            throw new RuntimeException("Check configuration file. The storm.supervisor.cgroup.rootdir is missing.");
        }
        File file = new File(DaemonConfig.getCgroupStormHierarchyDir(conf) + "/" + this.rootDir);
        if (!file.exists()) {
            LOG.error("{} is not existing.", (Object)file.getPath());
            throw new RuntimeException("Check if cgconfig service starts or /etc/cgconfig.conf is consistent with configuration file.");
        }
        this.center = CgroupCenter.getInstance();
        if (this.center == null) {
            throw new RuntimeException("Cgroup error, please check /proc/cgroups");
        }
        this.prepareSubSystem(this.conf);
    }

    private void prepareSubSystem(Map<String, Object> conf) throws IOException {
        LinkedList<SubSystemType> subSystemTypes = new LinkedList<SubSystemType>();
        for (String resource : DaemonConfig.getCgroupStormResources(conf)) {
            subSystemTypes.add(SubSystemType.getSubSystem((String)resource));
        }
        this.hierarchy = this.center.getHierarchyWithSubSystems(subSystemTypes);
        if (this.hierarchy == null) {
            HashSet<SubSystemType> types = new HashSet<SubSystemType>();
            types.add(SubSystemType.cpu);
            this.hierarchy = new Hierarchy(DaemonConfig.getCgroupStormHierarchyName(conf), types, DaemonConfig.getCgroupStormHierarchyDir(conf));
        }
        this.rootCgroup = new CgroupCommon(this.rootDir, this.hierarchy, this.hierarchy.getRootCgroups());
        CpuCore supervisorRootCPU = (CpuCore)this.rootCgroup.getCores().get(SubSystemType.cpu);
        this.setCpuUsageUpperLimit(supervisorRootCPU, ((Number)this.conf.get("supervisor.cpu.capacity")).intValue());
    }

    private void setCpuUsageUpperLimit(CpuCore cpuCore, int cpuCoreUpperLimit) throws IOException {
        if (cpuCoreUpperLimit == -1) {
            cpuCore.setCpuCfsQuotaUs((long)cpuCoreUpperLimit);
        } else {
            cpuCore.setCpuCfsPeriodUs(100000L);
            cpuCore.setCpuCfsQuotaUs((long)(cpuCoreUpperLimit * 1000));
        }
    }

    @Override
    public void reserveResourcesForWorker(String workerId, Map<String, Number> resourcesMap) throws SecurityException {
        Number cpuNum = null;
        if (this.conf.get(DaemonConfig.STORM_WORKER_CGROUP_CPU_LIMIT) != null) {
            cpuNum = (Number)this.conf.get(DaemonConfig.STORM_WORKER_CGROUP_CPU_LIMIT);
        } else if (resourcesMap.get("cpu") != null) {
            cpuNum = resourcesMap.get("cpu");
        }
        Number totalMem = null;
        if (this.conf.get(DaemonConfig.STORM_WORKER_CGROUP_MEMORY_MB_LIMIT) != null) {
            totalMem = (Number)this.conf.get(DaemonConfig.STORM_WORKER_CGROUP_MEMORY_MB_LIMIT);
        } else if (resourcesMap.get("memory") != null) {
            totalMem = resourcesMap.get("memory");
        }
        CgroupCommon workerGroup = new CgroupCommon(workerId, this.hierarchy, this.rootCgroup);
        try {
            this.center.createCgroup(workerGroup);
        }
        catch (Exception e) {
            LOG.error("Error when creating Cgroup: {}", (Throwable)e);
        }
        if (cpuNum != null) {
            CpuCore cpuCore = (CpuCore)workerGroup.getCores().get(SubSystemType.cpu);
            try {
                cpuCore.setCpuShares(cpuNum.intValue());
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot set cpu.shares! Exception: ", e);
            }
        }
        if (totalMem != null) {
            MemoryCore memCore = (MemoryCore)workerGroup.getCores().get(SubSystemType.memory);
            try {
                memCore.setPhysicalUsageLimit(Long.valueOf(totalMem.longValue() * 1024L * 1024L).longValue());
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot set memory.limit_in_bytes! Exception: ", e);
            }
        }
    }

    @Override
    public void releaseResourcesForWorker(String workerId) {
        CgroupCommon workerGroup = new CgroupCommon(workerId, this.hierarchy, this.rootCgroup);
        try {
            Set tasks = workerGroup.getTasks();
            if (!tasks.isEmpty()) {
                throw new Exception("Cannot correctly showdown worker CGroup " + workerId + "tasks " + tasks.toString() + " still running!");
            }
            this.center.deleteCgroup(workerGroup);
        }
        catch (Exception e) {
            LOG.error("Exception thrown when shutting worker {} Exception: {}", (Object)workerId, (Object)e);
        }
    }

    @Override
    public List<String> getLaunchCommand(String workerId, List<String> existingCommand) {
        List<String> newCommand = this.getLaunchCommandPrefix(workerId);
        newCommand.addAll(existingCommand);
        return newCommand;
    }

    @Override
    public List<String> getLaunchCommandPrefix(String workerId) {
        CgroupCommon workerGroup = new CgroupCommon(workerId, this.hierarchy, this.rootCgroup);
        if (!this.rootCgroup.getChildren().contains(workerGroup)) {
            throw new RuntimeException("cgroup " + workerGroup + " doesn't exist! Need to reserve resources for worker first!");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.conf.get(DaemonConfig.STORM_CGROUP_CGEXEC_CMD)).append(" -g ");
        Iterator it = this.hierarchy.getSubSystems().iterator();
        while (it.hasNext()) {
            sb.append(((SubSystemType)it.next()).toString());
            if (it.hasNext()) {
                sb.append(",");
                continue;
            }
            sb.append(":");
        }
        sb.append(workerGroup.getName());
        ArrayList<String> newCommand = new ArrayList<String>();
        newCommand.addAll(Arrays.asList(sb.toString().split(" ")));
        return newCommand;
    }

    public void close() throws IOException {
        this.center.deleteCgroup(this.rootCgroup);
    }

    @Override
    public Set<Long> getRunningPIDs(String workerId) throws IOException {
        CgroupCommon workerGroup = new CgroupCommon(workerId, this.hierarchy, this.rootCgroup);
        if (!this.rootCgroup.getChildren().contains(workerGroup)) {
            LOG.warn("cgroup {} doesn't exist!", (Object)workerGroup);
            return Collections.emptySet();
        }
        return workerGroup.getPids();
    }
}

