/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.metrics;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.storm.daemon.metrics.reporters.JmxPreparableReporter;
import org.apache.storm.daemon.metrics.reporters.PreparableReporter;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsUtils.class);

    public static List<PreparableReporter> getPreparableReporters(Map<String, Object> topoConf) {
        List clazzes = (List)topoConf.get("storm.daemon.metrics.reporter.plugins");
        ArrayList<PreparableReporter> reporterList = new ArrayList<PreparableReporter>();
        if (clazzes != null) {
            for (String clazz : clazzes) {
                reporterList.add(MetricsUtils.getPreparableReporter(clazz));
            }
        }
        if (reporterList.isEmpty()) {
            reporterList.add(new JmxPreparableReporter());
        }
        return reporterList;
    }

    private static PreparableReporter getPreparableReporter(String clazz) {
        PreparableReporter reporter = null;
        LOG.info("Using statistics reporter plugin:" + clazz);
        if (clazz != null) {
            reporter = (PreparableReporter)ReflectionUtils.newInstance((String)clazz);
        }
        return reporter;
    }

    public static Locale getMetricsReporterLocale(Map<String, Object> topoConf) {
        String languageTag = ObjectReader.getString((Object)topoConf.get("storm.daemon.metrics.reporter.plugin.locale"), null);
        if (languageTag != null) {
            return Locale.forLanguageTag(languageTag);
        }
        return null;
    }

    public static TimeUnit getMetricsRateUnit(Map<String, Object> topoConf) {
        return MetricsUtils.getTimeUnitForCofig(topoConf, "storm.daemon.metrics.reporter.plugin.rate.unit");
    }

    public static TimeUnit getMetricsDurationUnit(Map<String, Object> topoConf) {
        return MetricsUtils.getTimeUnitForCofig(topoConf, "storm.daemon.metrics.reporter.plugin.duration.unit");
    }

    private static TimeUnit getTimeUnitForCofig(Map<String, Object> topoConf, String configName) {
        String rateUnitString = ObjectReader.getString((Object)topoConf.get(configName), null);
        if (rateUnitString != null) {
            return TimeUnit.valueOf(rateUnitString);
        }
        return null;
    }

    public static File getCsvLogDir(Map<String, Object> topoConf) {
        String csvMetricsLogDirectory = ObjectReader.getString((Object)topoConf.get("storm.daemon.metrics.reporter.csv.log.dir"), null);
        if (csvMetricsLogDirectory == null) {
            csvMetricsLogDirectory = ConfigUtils.absoluteStormLocalDir(topoConf);
            csvMetricsLogDirectory = csvMetricsLogDirectory + ConfigUtils.FILE_SEPARATOR + "csvmetrics";
        }
        File csvMetricsDir = new File(csvMetricsLogDirectory);
        MetricsUtils.validateCreateOutputDir(csvMetricsDir);
        return csvMetricsDir;
    }

    private static void validateCreateOutputDir(File dir) {
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!dir.canWrite()) {
            throw new IllegalStateException(dir.getName() + " does not have write permissions.");
        }
        if (!dir.isDirectory()) {
            throw new IllegalStateException(dir.getName() + " is not a directory.");
        }
    }
}

