/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.metrics.reporters;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.MetricRegistry;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.storm.daemon.metrics.MetricsUtils;
import org.apache.storm.daemon.metrics.reporters.PreparableReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsolePreparableReporter
implements PreparableReporter<ConsoleReporter> {
    private static final Logger LOG = LoggerFactory.getLogger(ConsolePreparableReporter.class);
    ConsoleReporter reporter = null;

    @Override
    public void prepare(MetricRegistry metricsRegistry, Map<String, Object> topoConf) {
        TimeUnit durationUnit;
        TimeUnit rateUnit;
        LOG.debug("Preparing...");
        ConsoleReporter.Builder builder = ConsoleReporter.forRegistry((MetricRegistry)metricsRegistry);
        builder.outputTo(System.out);
        Locale locale = MetricsUtils.getMetricsReporterLocale(topoConf);
        if (locale != null) {
            builder.formattedFor(locale);
        }
        if ((rateUnit = MetricsUtils.getMetricsRateUnit(topoConf)) != null) {
            builder.convertRatesTo(rateUnit);
        }
        if ((durationUnit = MetricsUtils.getMetricsDurationUnit(topoConf)) != null) {
            builder.convertDurationsTo(durationUnit);
        }
        this.reporter = builder.build();
    }

    @Override
    public void start() {
        if (this.reporter == null) {
            throw new IllegalStateException("Attempt to start without preparing " + this.getClass().getSimpleName());
        }
        LOG.debug("Starting...");
        this.reporter.start(10L, TimeUnit.SECONDS);
    }

    @Override
    public void stop() {
        if (this.reporter == null) {
            throw new IllegalStateException("Attempt to stop without preparing " + this.getClass().getSimpleName());
        }
        LOG.debug("Stopping...");
        this.reporter.stop();
    }
}

