/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.supervisor;

import java.io.IOException;
import java.util.Map;
import org.apache.storm.container.ResourceIsolationInterface;
import org.apache.storm.daemon.supervisor.BasicContainer;
import org.apache.storm.daemon.supervisor.Container;
import org.apache.storm.daemon.supervisor.ContainerLauncher;
import org.apache.storm.daemon.supervisor.Killable;
import org.apache.storm.generated.LocalAssignment;
import org.apache.storm.utils.LocalState;

public class BasicContainerLauncher
extends ContainerLauncher {
    private final Map<String, Object> _conf;
    private final String _supervisorId;
    protected final ResourceIsolationInterface _resourceIsolationManager;

    public BasicContainerLauncher(Map<String, Object> conf, String supervisorId, ResourceIsolationInterface resourceIsolationManager) throws IOException {
        this._conf = conf;
        this._supervisorId = supervisorId;
        this._resourceIsolationManager = resourceIsolationManager;
    }

    @Override
    public Container launchContainer(int port, LocalAssignment assignment, LocalState state) throws IOException {
        BasicContainer container = new BasicContainer(Container.ContainerType.LAUNCH, this._conf, this._supervisorId, port, assignment, this._resourceIsolationManager, state, null);
        container.setup();
        ((Container)container).launch();
        return container;
    }

    @Override
    public Container recoverContainer(int port, LocalAssignment assignment, LocalState state) throws IOException {
        return new BasicContainer(Container.ContainerType.RECOVER_FULL, this._conf, this._supervisorId, port, assignment, this._resourceIsolationManager, state, null);
    }

    @Override
    public Killable recoverContainer(String workerId, LocalState localState) throws IOException {
        return new BasicContainer(Container.ContainerType.RECOVER_PARTIAL, this._conf, this._supervisorId, -1, null, this._resourceIsolationManager, localState, workerId);
    }
}

