/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.supervisor;

import java.io.IOException;
import java.util.Map;
import org.apache.storm.ProcessSimulator;
import org.apache.storm.daemon.Shutdownable;
import org.apache.storm.daemon.supervisor.Container;
import org.apache.storm.daemon.worker.Worker;
import org.apache.storm.generated.LocalAssignment;
import org.apache.storm.generated.ProfileRequest;
import org.apache.storm.messaging.IContext;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalContainer
extends Container {
    private static final Logger LOG = LoggerFactory.getLogger(LocalContainer.class);
    private volatile boolean _isAlive = false;
    private final IContext _sharedContext;

    public LocalContainer(Map<String, Object> conf, String supervisorId, int port, LocalAssignment assignment, IContext sharedContext) throws IOException {
        super(Container.ContainerType.LAUNCH, conf, supervisorId, port, assignment, null, null, null, null);
        this._sharedContext = sharedContext;
        this._workerId = Utils.uuid();
    }

    @Override
    protected void createArtifactsLink() {
    }

    @Override
    protected void createBlobstoreLinks() {
    }

    @Override
    public void launch() throws IOException {
        Worker worker = new Worker(this._conf, this._sharedContext, this._topologyId, this._supervisorId, this._port, this._workerId);
        try {
            worker.start();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.saveWorkerUser(System.getProperty("user.name"));
        ProcessSimulator.registerProcess(this._workerId, (Shutdownable)worker);
        this._isAlive = true;
    }

    @Override
    public void kill() throws IOException {
        ProcessSimulator.killProcess(this._workerId);
        this._isAlive = false;
        super.kill();
    }

    @Override
    public boolean areAllProcessesDead() throws IOException {
        return !this._isAlive && super.areAllProcessesDead();
    }

    @Override
    public void relaunch() throws IOException {
        LOG.warn("NOOP relaunch in local mode...");
    }

    @Override
    public boolean didMainProcessExit() {
        return false;
    }

    @Override
    public boolean runProfiling(ProfileRequest request, boolean stop) throws IOException, InterruptedException {
        throw new RuntimeException("Profiling requests are not supported in local mode");
    }
}

