/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.supervisor;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.storm.container.ResourceIsolationInterface;
import org.apache.storm.daemon.supervisor.AdvancedFSOps;
import org.apache.storm.daemon.supervisor.BasicContainer;
import org.apache.storm.daemon.supervisor.ClientSupervisorUtils;
import org.apache.storm.daemon.supervisor.Container;
import org.apache.storm.daemon.supervisor.ExitCodeCallback;
import org.apache.storm.daemon.supervisor.SupervisorUtils;
import org.apache.storm.generated.LocalAssignment;
import org.apache.storm.utils.LocalState;
import org.apache.storm.utils.ServerUtils;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunAsUserContainer
extends BasicContainer {
    private static final Logger LOG = LoggerFactory.getLogger(RunAsUserContainer.class);

    public RunAsUserContainer(Container.ContainerType type, Map<String, Object> conf, String supervisorId, int port, LocalAssignment assignment, ResourceIsolationInterface resourceIsolationManager, LocalState localState, String workerId) throws IOException {
        this(type, conf, supervisorId, port, assignment, resourceIsolationManager, localState, workerId, null, null, null);
    }

    RunAsUserContainer(Container.ContainerType type, Map<String, Object> conf, String supervisorId, int port, LocalAssignment assignment, ResourceIsolationInterface resourceIsolationManager, LocalState localState, String workerId, Map<String, Object> topoConf, AdvancedFSOps ops, String profileCmd) throws IOException {
        super(type, conf, supervisorId, port, assignment, resourceIsolationManager, localState, workerId, topoConf, ops, profileCmd);
        if (Utils.isOnWindows()) {
            throw new UnsupportedOperationException("ERROR: Windows doesn't support running workers as different users yet");
        }
    }

    private void signal(long pid, int signal) throws IOException {
        List<String> commands = Arrays.asList("signal", String.valueOf(pid), String.valueOf(signal));
        String user = this.getWorkerUser();
        String logPrefix = "kill -" + signal + " " + pid;
        ClientSupervisorUtils.processLauncherAndWait((Map)this._conf, (String)user, commands, null, (String)logPrefix);
    }

    @Override
    protected void kill(long pid) throws IOException {
        this.signal(pid, 15);
    }

    @Override
    protected void forceKill(long pid) throws IOException {
        this.signal(pid, 9);
    }

    @Override
    protected boolean runProfilingCommand(List<String> command, Map<String, String> env, String logPrefix, File targetDir) throws IOException, InterruptedException {
        String scriptFile;
        String user = this.getWorkerUser();
        String td = targetDir.getAbsolutePath();
        LOG.info("Running as user: {} command: {}", (Object)user, command);
        String containerFile = ServerUtils.containerFilePath(td);
        if (Utils.checkFileExists((String)containerFile)) {
            SupervisorUtils.rmrAsUser(this._conf, containerFile, containerFile);
        }
        if (Utils.checkFileExists((String)(scriptFile = ServerUtils.scriptFilePath(td)))) {
            SupervisorUtils.rmrAsUser(this._conf, scriptFile, scriptFile);
        }
        String script = ServerUtils.writeScript(td, command, env);
        List<String> args = Arrays.asList("profiler", td, script);
        int ret = ClientSupervisorUtils.processLauncherAndWait((Map)this._conf, (String)user, args, env, (String)logPrefix);
        return ret == 0;
    }

    @Override
    protected void launchWorkerProcess(List<String> command, Map<String, String> env, String logPrefix, ExitCodeCallback processExitCallback, File targetDir) throws IOException {
        String workerDir = targetDir.getAbsolutePath();
        String user = this.getWorkerUser();
        List<String> args = Arrays.asList("worker", workerDir, ServerUtils.writeScript(workerDir, command, env));
        List<String> commandPrefix = null;
        if (this._resourceIsolationManager != null) {
            commandPrefix = this._resourceIsolationManager.getLaunchCommandPrefix(this._workerId);
        }
        ClientSupervisorUtils.processLauncher((Map)this._conf, (String)user, commandPrefix, args, null, (String)logPrefix, (ExitCodeCallback)processExitCallback, (File)targetDir);
    }
}

