/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.supervisor;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.storm.cluster.IStormClusterState;
import org.apache.storm.daemon.supervisor.Container;
import org.apache.storm.daemon.supervisor.ContainerLauncher;
import org.apache.storm.daemon.supervisor.ContainerRecoveryException;
import org.apache.storm.generated.LSWorkerHeartbeat;
import org.apache.storm.generated.LocalAssignment;
import org.apache.storm.generated.ProfileAction;
import org.apache.storm.generated.ProfileRequest;
import org.apache.storm.localizer.ILocalizer;
import org.apache.storm.scheduler.ISupervisor;
import org.apache.storm.utils.LocalState;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.Time;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slot
extends Thread
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(Slot.class);
    private final AtomicReference<LocalAssignment> newAssignment = new AtomicReference();
    private final AtomicReference<Set<TopoProfileAction>> profiling = new AtomicReference(new HashSet());
    private final StaticState staticState;
    private final IStormClusterState clusterState;
    private volatile boolean done = false;
    private volatile DynamicState dynamicState;
    private final AtomicReference<Map<Long, LocalAssignment>> cachedCurrentAssignments;

    static boolean equivalent(LocalAssignment a, LocalAssignment b) {
        HashSet bexec;
        HashSet aexec;
        if (a == null && b == null) {
            return true;
        }
        if (a != null && b != null && a.get_topology_id().equals(b.get_topology_id()) && (aexec = new HashSet(a.get_executors())).equals(bexec = new HashSet(b.get_executors()))) {
            boolean aHasResources = a.is_set_resources();
            boolean bHasResources = b.is_set_resources();
            if (!aHasResources && !bHasResources) {
                return true;
            }
            if (aHasResources && bHasResources && a.get_resources().equals(b.get_resources())) {
                return true;
            }
        }
        return false;
    }

    static DynamicState stateMachineStep(DynamicState dynamicState, StaticState staticState) throws Exception {
        LOG.debug("STATE {}", (Object)dynamicState.state);
        switch (dynamicState.state) {
            case EMPTY: {
                return Slot.handleEmpty(dynamicState, staticState);
            }
            case RUNNING: {
                return Slot.handleRunning(dynamicState, staticState);
            }
            case WAITING_FOR_WORKER_START: {
                return Slot.handleWaitingForWorkerStart(dynamicState, staticState);
            }
            case KILL_AND_RELAUNCH: {
                return Slot.handleKillAndRelaunch(dynamicState, staticState);
            }
            case KILL: {
                return Slot.handleKill(dynamicState, staticState);
            }
            case WAITING_FOR_BASIC_LOCALIZATION: {
                return Slot.handleWaitingForBasicLocalization(dynamicState, staticState);
            }
            case WAITING_FOR_BLOB_LOCALIZATION: {
                return Slot.handleWaitingForBlobLocalization(dynamicState, staticState);
            }
        }
        throw new IllegalStateException("Code not ready to handle a state of " + (Object)((Object)dynamicState.state));
    }

    static DynamicState prepareForNewAssignmentNoWorkersRunning(DynamicState dynamicState, StaticState staticState) throws IOException {
        assert (dynamicState.container == null);
        if (dynamicState.newAssignment == null) {
            return dynamicState.withState(MachineState.EMPTY);
        }
        Future<Void> pendingDownload = staticState.localizer.requestDownloadBaseTopologyBlobs(dynamicState.newAssignment, staticState.port);
        return dynamicState.withPendingLocalization(dynamicState.newAssignment, pendingDownload).withState(MachineState.WAITING_FOR_BASIC_LOCALIZATION);
    }

    static DynamicState killContainerForChangedAssignment(DynamicState dynamicState, StaticState staticState) throws Exception {
        assert (dynamicState.container != null);
        staticState.iSupervisor.killedWorker(staticState.port);
        dynamicState.container.kill();
        Future<Void> pendingDownload = null;
        if (dynamicState.newAssignment != null) {
            pendingDownload = staticState.localizer.requestDownloadBaseTopologyBlobs(dynamicState.newAssignment, staticState.port);
        }
        Time.sleep((long)staticState.killSleepMs);
        return dynamicState.withPendingLocalization(dynamicState.newAssignment, pendingDownload).withState(MachineState.KILL);
    }

    static DynamicState killAndRelaunchContainer(DynamicState dynamicState, StaticState staticState) throws Exception {
        assert (dynamicState.container != null);
        dynamicState.container.kill();
        Time.sleep((long)staticState.killSleepMs);
        HashSet<TopoProfileAction> mod = new HashSet<TopoProfileAction>(dynamicState.profileActions);
        mod.addAll(dynamicState.pendingStopProfileActions);
        return dynamicState.withState(MachineState.KILL_AND_RELAUNCH).withProfileActions(mod, Collections.emptySet());
    }

    static DynamicState cleanupCurrentContainer(DynamicState dynamicState, StaticState staticState, MachineState nextState) throws Exception {
        assert (dynamicState.container != null);
        assert (dynamicState.currentAssignment != null);
        assert (dynamicState.container.areAllProcessesDead());
        dynamicState.container.cleanUp();
        staticState.localizer.releaseSlotFor(dynamicState.currentAssignment, staticState.port);
        DynamicState ret = dynamicState.withCurrentAssignment(null, null);
        if (nextState != null) {
            ret = ret.withState(nextState);
        }
        return ret;
    }

    static DynamicState handleWaitingForBlobLocalization(DynamicState dynamicState, StaticState staticState) throws Exception {
        assert (dynamicState.pendingLocalization != null);
        assert (dynamicState.pendingDownload != null);
        assert (dynamicState.container == null);
        try {
            dynamicState.pendingDownload.get(1000L, TimeUnit.MILLISECONDS);
            if (!Slot.equivalent(dynamicState.newAssignment, dynamicState.pendingLocalization)) {
                staticState.localizer.releaseSlotFor(dynamicState.pendingLocalization, staticState.port);
                return Slot.prepareForNewAssignmentNoWorkersRunning(dynamicState, staticState);
            }
            Container c = staticState.containerLauncher.launchContainer(staticState.port, dynamicState.pendingLocalization, staticState.localState);
            return dynamicState.withCurrentAssignment(c, dynamicState.pendingLocalization).withState(MachineState.WAITING_FOR_WORKER_START).withPendingLocalization(null, null);
        }
        catch (TimeoutException e) {
            return dynamicState;
        }
    }

    static DynamicState handleWaitingForBasicLocalization(DynamicState dynamicState, StaticState staticState) throws Exception {
        assert (dynamicState.pendingLocalization != null);
        assert (dynamicState.pendingDownload != null);
        assert (dynamicState.container == null);
        try {
            dynamicState.pendingDownload.get(1000L, TimeUnit.MILLISECONDS);
            Future<Void> pendingDownload = staticState.localizer.requestDownloadTopologyBlobs(dynamicState.pendingLocalization, staticState.port);
            return dynamicState.withPendingLocalization(pendingDownload).withState(MachineState.WAITING_FOR_BLOB_LOCALIZATION);
        }
        catch (TimeoutException e) {
            return dynamicState;
        }
    }

    static DynamicState handleKill(DynamicState dynamicState, StaticState staticState) throws Exception {
        assert (dynamicState.container != null);
        assert (dynamicState.currentAssignment != null);
        if (dynamicState.container.areAllProcessesDead()) {
            LOG.warn("SLOT {} all processes are dead...", (Object)staticState.port);
            return Slot.cleanupCurrentContainer(dynamicState, staticState, dynamicState.pendingLocalization == null ? MachineState.EMPTY : MachineState.WAITING_FOR_BASIC_LOCALIZATION);
        }
        LOG.warn("SLOT {} force kill and wait...", (Object)staticState.port);
        dynamicState.container.forceKill();
        Time.sleep((long)staticState.killSleepMs);
        return dynamicState;
    }

    static DynamicState handleKillAndRelaunch(DynamicState dynamicState, StaticState staticState) throws Exception {
        assert (dynamicState.container != null);
        assert (dynamicState.currentAssignment != null);
        if (dynamicState.container.areAllProcessesDead()) {
            if (Slot.equivalent(dynamicState.newAssignment, dynamicState.currentAssignment)) {
                dynamicState.container.cleanUpForRestart();
                dynamicState.container.relaunch();
                return dynamicState.withState(MachineState.WAITING_FOR_WORKER_START);
            }
            return Slot.prepareForNewAssignmentNoWorkersRunning(Slot.cleanupCurrentContainer(dynamicState, staticState, null), staticState);
        }
        if (Time.currentTimeMillis() - dynamicState.startTime > 120000L) {
            throw new RuntimeException("Not all processes in " + dynamicState.container + " exited after 120 seconds");
        }
        dynamicState.container.forceKill();
        Time.sleep((long)staticState.killSleepMs);
        return dynamicState;
    }

    static DynamicState handleWaitingForWorkerStart(DynamicState dynamicState, StaticState staticState) throws Exception {
        long hbAgeMs;
        assert (dynamicState.container != null);
        assert (dynamicState.currentAssignment != null);
        LSWorkerHeartbeat hb = dynamicState.container.readHeartbeat();
        if (hb != null && (hbAgeMs = (long)((Time.currentTimeSecs() - hb.get_time_secs()) * 1000)) <= staticState.hbTimeoutMs) {
            return dynamicState.withState(MachineState.RUNNING);
        }
        if (!Slot.equivalent(dynamicState.newAssignment, dynamicState.currentAssignment)) {
            LOG.warn("SLOT {}: Assignment Changed from {} to {}", new Object[]{staticState.port, dynamicState.currentAssignment, dynamicState.newAssignment});
            return Slot.killContainerForChangedAssignment(dynamicState, staticState);
        }
        long timeDiffms = Time.currentTimeMillis() - dynamicState.startTime;
        if (timeDiffms > staticState.firstHbTimeoutMs) {
            LOG.warn("SLOT {}: Container {} failed to launch in {} ms.", new Object[]{staticState.port, dynamicState.container, staticState.firstHbTimeoutMs});
            return Slot.killAndRelaunchContainer(dynamicState, staticState);
        }
        Time.sleep((long)1000L);
        return dynamicState;
    }

    static DynamicState handleRunning(DynamicState dynamicState, StaticState staticState) throws Exception {
        assert (dynamicState.container != null);
        assert (dynamicState.currentAssignment != null);
        if (!Slot.equivalent(dynamicState.newAssignment, dynamicState.currentAssignment)) {
            LOG.warn("SLOT {}: Assignment Changed from {} to {}", new Object[]{staticState.port, dynamicState.currentAssignment, dynamicState.newAssignment});
            return Slot.killContainerForChangedAssignment(dynamicState, staticState);
        }
        if (dynamicState.container.didMainProcessExit()) {
            LOG.warn("SLOT {}: main process has exited", (Object)staticState.port);
            return Slot.killAndRelaunchContainer(dynamicState, staticState);
        }
        LSWorkerHeartbeat hb = dynamicState.container.readHeartbeat();
        if (hb == null) {
            LOG.warn("SLOT {}: HB returned as null", (Object)staticState.port);
            return Slot.killAndRelaunchContainer(dynamicState, staticState);
        }
        long timeDiffMs = (Time.currentTimeSecs() - hb.get_time_secs()) * 1000;
        if (timeDiffMs > staticState.hbTimeoutMs) {
            LOG.warn("SLOT {}: HB is too old {} > {}", new Object[]{staticState.port, timeDiffMs, staticState.hbTimeoutMs});
            return Slot.killAndRelaunchContainer(dynamicState, staticState);
        }
        if (!dynamicState.profileActions.isEmpty()) {
            HashSet<TopoProfileAction> mod = new HashSet<TopoProfileAction>(dynamicState.profileActions);
            HashSet<TopoProfileAction> modPending = new HashSet<TopoProfileAction>(dynamicState.pendingStopProfileActions);
            Iterator<TopoProfileAction> iter = mod.iterator();
            while (iter.hasNext()) {
                TopoProfileAction action = iter.next();
                if (!action.topoId.equals(dynamicState.currentAssignment.get_topology_id())) {
                    iter.remove();
                    LOG.warn("Dropping {} wrong topology is running", (Object)action);
                    continue;
                }
                if (modPending.contains(action)) {
                    boolean isTimeForStop;
                    boolean bl = isTimeForStop = Time.currentTimeMillis() > action.request.get_time_stamp();
                    if (isTimeForStop) {
                        if (dynamicState.container.runProfiling(action.request, true)) {
                            LOG.debug("Stopped {} action finished", (Object)action);
                            iter.remove();
                            modPending.remove(action);
                            continue;
                        }
                        LOG.warn("Stopping {} failed, will be retried", (Object)action);
                        continue;
                    }
                    LOG.debug("Still pending {} now: {}", (Object)action, (Object)Time.currentTimeMillis());
                    continue;
                }
                if (action.request.get_action() == ProfileAction.JPROFILE_STOP) {
                    if (dynamicState.container.runProfiling(action.request, false)) {
                        modPending.add(action);
                        LOG.debug("Started {} now: {}", (Object)action, (Object)Time.currentTimeMillis());
                        continue;
                    }
                    LOG.warn("Starting {} failed, will be retried", (Object)action);
                    continue;
                }
                if (dynamicState.container.runProfiling(action.request, false)) {
                    LOG.debug("Started {} action finished", (Object)action);
                    iter.remove();
                    continue;
                }
                LOG.warn("Starting {} failed, will be retried", (Object)action);
            }
            dynamicState = dynamicState.withProfileActions(mod, modPending);
        }
        Time.sleep((long)staticState.monitorFreqMs);
        return dynamicState;
    }

    static DynamicState handleEmpty(DynamicState dynamicState, StaticState staticState) throws InterruptedException, IOException {
        if (!Slot.equivalent(dynamicState.newAssignment, dynamicState.currentAssignment)) {
            return Slot.prepareForNewAssignmentNoWorkersRunning(dynamicState, staticState);
        }
        if (dynamicState.profileActions != null && !dynamicState.profileActions.isEmpty()) {
            LOG.warn("Dropping {} no topology is running", dynamicState.profileActions);
            dynamicState = dynamicState.withProfileActions(Collections.emptySet(), Collections.emptySet());
        }
        Time.sleep((long)1000L);
        return dynamicState;
    }

    public Slot(ILocalizer localizer, Map<String, Object> conf, ContainerLauncher containerLauncher, String host, int port, LocalState localState, IStormClusterState clusterState, ISupervisor iSupervisor, AtomicReference<Map<Long, LocalAssignment>> cachedCurrentAssignments) throws Exception {
        super("SLOT_" + port);
        this.cachedCurrentAssignments = cachedCurrentAssignments;
        this.clusterState = clusterState;
        Map assignments = localState.getLocalAssignmentsMap();
        LocalAssignment currentAssignment = null;
        if (assignments != null) {
            currentAssignment = (LocalAssignment)assignments.get(port);
        }
        Container container = null;
        if (currentAssignment != null) {
            try {
                container = containerLauncher.recoverContainer(port, currentAssignment, localState);
            }
            catch (ContainerRecoveryException containerRecoveryException) {
                // empty catch block
            }
        }
        LocalAssignment newAssignment = currentAssignment;
        if (currentAssignment != null && container == null) {
            currentAssignment = null;
        }
        this.dynamicState = new DynamicState(currentAssignment, container, newAssignment);
        this.staticState = new StaticState(localizer, ObjectReader.getInt((Object)conf.get("supervisor.worker.timeout.secs")) * 1000, ObjectReader.getInt((Object)conf.get("supervisor.worker.start.timeout.secs")) * 1000, ObjectReader.getInt((Object)conf.get("supervisor.worker.shutdown.sleep.secs")) * 1000, ObjectReader.getInt((Object)conf.get("supervisor.monitor.frequency.secs")) * 1000, containerLauncher, host, port, iSupervisor, localState);
        this.newAssignment.set(this.dynamicState.newAssignment);
        if (MachineState.RUNNING == this.dynamicState.state) {
            this.staticState.localizer.recoverRunningTopology(currentAssignment, port);
            this.saveNewAssignment(currentAssignment);
        }
        LOG.warn("SLOT {}:{} Starting in state {} - assignment {}", new Object[]{this.staticState.host, this.staticState.port, this.dynamicState.state, this.dynamicState.currentAssignment});
    }

    public MachineState getMachineState() {
        return this.dynamicState.state;
    }

    public void setNewAssignment(LocalAssignment newAssignment) {
        this.newAssignment.set(newAssignment);
    }

    public void addProfilerActions(Set<TopoProfileAction> actions) {
        if (actions != null) {
            HashSet<TopoProfileAction> newActions;
            Set<TopoProfileAction> orig;
            do {
                orig = this.profiling.get();
                newActions = new HashSet<TopoProfileAction>(orig);
                newActions.addAll(actions);
            } while (!this.profiling.compareAndSet(orig, newActions));
            return;
        }
    }

    public String getWorkerId() {
        String workerId = null;
        Container c = this.dynamicState.container;
        if (c != null) {
            workerId = c.getWorkerId();
        }
        return workerId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveNewAssignment(LocalAssignment assignment) {
        LocalState localState = this.staticState.localState;
        synchronized (localState) {
            HashMap<Integer, LocalAssignment> assignments = this.staticState.localState.getLocalAssignmentsMap();
            if (assignments == null) {
                assignments = new HashMap<Integer, LocalAssignment>();
            }
            if (assignment == null) {
                assignments.remove(this.staticState.port);
            } else {
                assignments.put(this.staticState.port, assignment);
            }
            this.staticState.localState.setLocalAssignmentsMap(assignments);
        }
        HashMap<Long, LocalAssignment> update = null;
        Map<Long, LocalAssignment> orig = null;
        do {
            Long lport = new Long(this.staticState.port);
            orig = this.cachedCurrentAssignments.get();
            update = new HashMap<Long, LocalAssignment>(orig);
            if (assignment == null) {
                update.remove(lport);
                continue;
            }
            update.put(lport, assignment);
        } while (!this.cachedCurrentAssignments.compareAndSet(orig, update));
    }

    @Override
    public void run() {
        block9: {
            try {
                while (!this.done) {
                    HashSet<TopoProfileAction> copy;
                    Set<TopoProfileAction> orig;
                    HashSet<TopoProfileAction> origProfileActions = new HashSet<TopoProfileAction>((Collection)this.profiling.get());
                    HashSet removed = new HashSet(origProfileActions);
                    DynamicState nextState = Slot.stateMachineStep(this.dynamicState.withNewAssignment(this.newAssignment.get()).withProfileActions(origProfileActions, this.dynamicState.pendingStopProfileActions), this.staticState);
                    if (LOG.isDebugEnabled() || this.dynamicState.state != nextState.state) {
                        LOG.info("STATE {} -> {}", (Object)this.dynamicState, (Object)nextState);
                    }
                    if (!Slot.equivalent(nextState.currentAssignment, this.dynamicState.currentAssignment)) {
                        LOG.info("SLOT {}: Changing current assignment from {} to {}", new Object[]{this.staticState.port, this.dynamicState.currentAssignment, nextState.currentAssignment});
                        this.saveNewAssignment(nextState.currentAssignment);
                    }
                    removed.removeAll(this.dynamicState.profileActions);
                    removed.removeAll(this.dynamicState.pendingStopProfileActions);
                    for (TopoProfileAction action : removed) {
                        try {
                            this.clusterState.deleteTopologyProfileRequests(action.topoId, action.request);
                        }
                        catch (Exception e) {
                            LOG.error("Error trying to remove profiling request, it will be retried", (Throwable)e);
                        }
                    }
                    do {
                        orig = this.profiling.get();
                        copy = new HashSet<TopoProfileAction>(orig);
                        copy.removeAll(removed);
                    } while (!this.profiling.compareAndSet(orig, copy));
                    this.dynamicState = nextState;
                }
            }
            catch (Throwable e) {
                if (Utils.exceptionCauseIsInstanceOf(InterruptedException.class, (Throwable)e)) break block9;
                LOG.error("Error when processing event", e);
                Utils.exitProcess((int)20, (String)"Error when processing an event");
            }
        }
    }

    @Override
    public void close() throws Exception {
        this.done = true;
        this.interrupt();
        this.join();
    }

    static class TopoProfileAction {
        public final String topoId;
        public final ProfileRequest request;

        public TopoProfileAction(String topoId, ProfileRequest request) {
            this.topoId = topoId;
            this.request = request;
        }

        public int hashCode() {
            return 37 * this.topoId.hashCode() + this.request.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof TopoProfileAction)) {
                return false;
            }
            TopoProfileAction o = (TopoProfileAction)other;
            return this.topoId.equals(o.topoId) && this.request.equals(o.request);
        }

        public String toString() {
            return "{ " + this.topoId + ": " + this.request + " }";
        }
    }

    static class DynamicState {
        public final MachineState state;
        public final LocalAssignment newAssignment;
        public final LocalAssignment currentAssignment;
        public final Container container;
        public final LocalAssignment pendingLocalization;
        public final Future<Void> pendingDownload;
        public final Set<TopoProfileAction> profileActions;
        public final Set<TopoProfileAction> pendingStopProfileActions;
        public final long startTime;

        public DynamicState(LocalAssignment currentAssignment, Container container, LocalAssignment newAssignment) {
            this.currentAssignment = currentAssignment;
            this.container = container;
            if (currentAssignment == null ^ container == null) {
                throw new IllegalArgumentException("Container and current assignment must both be null, or neither can be null");
            }
            this.state = currentAssignment == null ? MachineState.EMPTY : MachineState.RUNNING;
            this.startTime = System.currentTimeMillis();
            this.newAssignment = newAssignment;
            this.pendingLocalization = null;
            this.pendingDownload = null;
            this.profileActions = new HashSet<TopoProfileAction>();
            this.pendingStopProfileActions = new HashSet<TopoProfileAction>();
        }

        public DynamicState(MachineState state, LocalAssignment newAssignment, Container container, LocalAssignment currentAssignment, LocalAssignment pendingLocalization, long startTime, Future<Void> pendingDownload, Set<TopoProfileAction> profileActions, Set<TopoProfileAction> pendingStopProfileActions) {
            this.state = state;
            this.newAssignment = newAssignment;
            this.currentAssignment = currentAssignment;
            this.container = container;
            this.pendingLocalization = pendingLocalization;
            this.startTime = startTime;
            this.pendingDownload = pendingDownload;
            this.profileActions = profileActions;
            this.pendingStopProfileActions = pendingStopProfileActions;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append((Object)this.state);
            sb.append(" msInState: ");
            sb.append(Time.currentTimeMillis() - this.startTime);
            if (this.container != null) {
                sb.append(" ");
                sb.append(this.container);
            }
            return sb.toString();
        }

        public DynamicState withNewAssignment(LocalAssignment newAssignment) {
            return new DynamicState(this.state, newAssignment, this.container, this.currentAssignment, this.pendingLocalization, this.startTime, this.pendingDownload, this.profileActions, this.pendingStopProfileActions);
        }

        public DynamicState withPendingLocalization(LocalAssignment pendingLocalization, Future<Void> pendingDownload) {
            return new DynamicState(this.state, this.newAssignment, this.container, this.currentAssignment, pendingLocalization, this.startTime, pendingDownload, this.profileActions, this.pendingStopProfileActions);
        }

        public DynamicState withPendingLocalization(Future<Void> pendingDownload) {
            return this.withPendingLocalization(this.pendingLocalization, pendingDownload);
        }

        public DynamicState withState(MachineState state) {
            long newStartTime = Time.currentTimeMillis();
            return new DynamicState(state, this.newAssignment, this.container, this.currentAssignment, this.pendingLocalization, newStartTime, this.pendingDownload, this.profileActions, this.pendingStopProfileActions);
        }

        public DynamicState withCurrentAssignment(Container container, LocalAssignment currentAssignment) {
            return new DynamicState(this.state, this.newAssignment, container, currentAssignment, this.pendingLocalization, this.startTime, this.pendingDownload, this.profileActions, this.pendingStopProfileActions);
        }

        public DynamicState withProfileActions(Set<TopoProfileAction> profileActions, Set<TopoProfileAction> pendingStopProfileActions) {
            return new DynamicState(this.state, this.newAssignment, this.container, this.currentAssignment, this.pendingLocalization, this.startTime, this.pendingDownload, profileActions, pendingStopProfileActions);
        }
    }

    static class StaticState {
        public final ILocalizer localizer;
        public final long hbTimeoutMs;
        public final long firstHbTimeoutMs;
        public final long killSleepMs;
        public final long monitorFreqMs;
        public final ContainerLauncher containerLauncher;
        public final int port;
        public final String host;
        public final ISupervisor iSupervisor;
        public final LocalState localState;

        StaticState(ILocalizer localizer, long hbTimeoutMs, long firstHbTimeoutMs, long killSleepMs, long monitorFreqMs, ContainerLauncher containerLauncher, String host, int port, ISupervisor iSupervisor, LocalState localState) {
            this.localizer = localizer;
            this.hbTimeoutMs = hbTimeoutMs;
            this.firstHbTimeoutMs = firstHbTimeoutMs;
            this.containerLauncher = containerLauncher;
            this.killSleepMs = killSleepMs;
            this.monitorFreqMs = monitorFreqMs;
            this.host = host;
            this.port = port;
            this.iSupervisor = iSupervisor;
            this.localState = localState;
        }
    }

    static enum MachineState {
        EMPTY,
        RUNNING,
        WAITING_FOR_WORKER_START,
        KILL_AND_RELAUNCH,
        KILL,
        WAITING_FOR_BASIC_LOCALIZATION,
        WAITING_FOR_BLOB_LOCALIZATION;

    }
}

