/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.localizer;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.storm.generated.LocalAssignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDownloadedResource {
    private static final Logger LOG = LoggerFactory.getLogger(LocalDownloadedResource.class);
    private final Future<Void> _pending;
    private final Set<PortNAssignment> _references;
    private boolean _isDone;

    public LocalDownloadedResource(Future<Void> pending) {
        this._pending = new NoCancelFuture<Void>(pending);
        this._references = new HashSet<PortNAssignment>();
        this._isDone = false;
    }

    public synchronized Future<Void> reserve(int port, LocalAssignment la) {
        PortNAssignment pna = new PortNAssignment(port, la);
        if (!this._references.add(pna)) {
            LOG.warn("Resources {} already reserved {} for this topology", (Object)pna, this._references);
        }
        return this._pending;
    }

    public synchronized boolean release(int port, LocalAssignment la) {
        PortNAssignment pna = new PortNAssignment(port, la);
        boolean ret = this._references.remove(pna);
        if (ret && this._references.isEmpty()) {
            this._isDone = true;
        }
        return ret;
    }

    public synchronized boolean isDone() {
        return this._isDone;
    }

    public String toString() {
        return this._references.toString();
    }

    private static class PortNAssignment {
        private final int _port;
        private final LocalAssignment _assignment;

        public PortNAssignment(int port, LocalAssignment assignment) {
            this._port = port;
            this._assignment = assignment;
        }

        public boolean equals(Object other) {
            if (!(other instanceof PortNAssignment)) {
                return false;
            }
            PortNAssignment pna = (PortNAssignment)other;
            return pna._port == this._port && this._assignment.equals(pna._assignment);
        }

        public int hashCode() {
            return 17 * this._port + this._assignment.hashCode();
        }

        public String toString() {
            return "{" + this._port + " " + this._assignment + "}";
        }
    }

    private static class NoCancelFuture<T>
    implements Future<T> {
        private final Future<T> _wrapped;

        public NoCancelFuture(Future<T> wrapped) {
            this._wrapped = wrapped;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this._wrapped.isDone();
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            return this._wrapped.get();
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this._wrapped.get(timeout, unit);
        }
    }
}

