/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.localizer;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.storm.utils.ServerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalizedResource {
    public static final Logger LOG = LoggerFactory.getLogger(LocalizedResource.class);
    private final String _localPath;
    private final String _versionFilePath;
    private final String _symlinkPath;
    private final String _key;
    private final boolean _uncompressed;
    private long _size = -1L;
    private final Set<String> _ref;
    private final AtomicLong _lastAccessTime = new AtomicLong(this.currentTime());

    public LocalizedResource(String key, String fileLoc, boolean uncompressed) {
        this._ref = new HashSet<String>();
        this._localPath = fileLoc;
        this._versionFilePath = ServerUtils.constructVersionFileName(fileLoc);
        this._symlinkPath = ServerUtils.constructBlobCurrentSymlinkName(fileLoc);
        this._uncompressed = uncompressed;
        this._key = key;
        this._size = ServerUtils.getDU(new File(this.getFilePathWithVersion()));
        LOG.debug("size of {} is: {}", (Object)fileLoc, (Object)this._size);
    }

    public LocalizedResource(String key, String fileLoc, boolean uncompressed, String topo) {
        this(key, fileLoc, uncompressed);
        this._ref.add(topo);
    }

    public boolean isUncompressed() {
        return this._uncompressed;
    }

    public String getKey() {
        return this._key;
    }

    public String getCurrentSymlinkPath() {
        return this._symlinkPath;
    }

    public String getVersionFilePath() {
        return this._versionFilePath;
    }

    public String getFilePathWithVersion() {
        long version = ServerUtils.localVersionOfBlob(this._localPath);
        return ServerUtils.constructBlobWithVersionFileName(this._localPath, version);
    }

    public String getFilePath() {
        return this._localPath;
    }

    public void addReference(String topo) {
        this._ref.add(topo);
    }

    public void removeReference(String topo) {
        if (!this._ref.remove(topo)) {
            LOG.warn("Tried to remove a reference to a topology that doesn't use this resource");
        }
        this.setTimestamp();
    }

    public long getLastAccessTime() {
        return this._lastAccessTime.get();
    }

    protected void setSize(long size) {
        this._size = size;
    }

    public long getSize() {
        return this._size;
    }

    private void setTimestamp() {
        this._lastAccessTime.set(this.currentTime());
    }

    public int getRefCount() {
        return this._ref.size();
    }

    private long currentTime() {
        return System.nanoTime();
    }
}

