/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.localizer;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.storm.blobstore.ClientBlobStore;
import org.apache.storm.blobstore.InputStreamWithMeta;
import org.apache.storm.generated.AuthorizationException;
import org.apache.storm.generated.KeyNotFoundException;
import org.apache.storm.localizer.LocalResource;
import org.apache.storm.localizer.LocalizedResource;
import org.apache.storm.localizer.LocalizedResourceRetentionSet;
import org.apache.storm.localizer.LocalizedResourceSet;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.ServerUtils;
import org.apache.storm.utils.ShellUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Localizer {
    public static final Logger LOG = LoggerFactory.getLogger(Localizer.class);
    public static final String USERCACHE = "usercache";
    public static final String FILECACHE = "filecache";
    public static final String FILESDIR = "files";
    public static final String ARCHIVESDIR = "archives";
    private static final String TO_UNCOMPRESS = "_tmp_";
    private final Map<String, Object> _conf;
    private final int _threadPoolSize;
    private final ExecutorService _execService;
    private final ExecutorService _updateExecService;
    private final int _blobDownloadRetries;
    private final ConcurrentMap<String, LocalizedResourceSet> _userRsrc = new ConcurrentHashMap<String, LocalizedResourceSet>();
    private final String _localBaseDir;
    private long _cacheTargetSize;
    private long _cacheCleanupPeriod;
    private ScheduledExecutorService _cacheCleanupService;

    public Localizer(Map<String, Object> conf, String baseDir) {
        this._conf = conf;
        this._localBaseDir = baseDir;
        this._cacheTargetSize = ObjectReader.getInt((Object)this._conf.get("supervisor.localizer.cache.target.size.mb"), (Integer)10240).longValue() << 20;
        this._cacheCleanupPeriod = ObjectReader.getInt((Object)this._conf.get("supervisor.localizer.cleanup.interval.ms"), (Integer)600000).longValue();
        this._threadPoolSize = ObjectReader.getInt((Object)this._conf.get("supervisor.blobstore.download.thread.count"), (Integer)5);
        this._blobDownloadRetries = ObjectReader.getInt((Object)this._conf.get("supervisor.blobstore.download.max_retries"), (Integer)3);
        this._execService = Executors.newFixedThreadPool(this._threadPoolSize);
        this._updateExecService = Executors.newFixedThreadPool(this._threadPoolSize);
        this.reconstructLocalizedResources();
    }

    protected void setTargetCacheSize(long size) {
        this._cacheTargetSize = size;
    }

    ConcurrentMap<String, LocalizedResourceSet> getUserResources() {
        return this._userRsrc;
    }

    public void startCleaner() {
        this._cacheCleanupService = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setNameFormat("Localizer Cache Cleanup").build());
        this._cacheCleanupService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                Localizer.this.handleCacheCleanup();
            }
        }, this._cacheCleanupPeriod, this._cacheCleanupPeriod, TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        if (this._cacheCleanupService != null) {
            this._cacheCleanupService.shutdown();
        }
        if (this._execService != null) {
            this._execService.shutdown();
        }
        if (this._updateExecService != null) {
            this._updateExecService.shutdown();
        }
    }

    protected File getUserCacheDir() {
        return new File(this._localBaseDir, USERCACHE);
    }

    protected File getLocalUserDir(String userName) {
        return new File(this.getUserCacheDir(), userName);
    }

    public File getLocalUserFileCacheDir(String userName) {
        return new File(this.getLocalUserDir(userName), FILECACHE);
    }

    protected File getCacheDirForFiles(File dir) {
        return new File(dir, FILESDIR);
    }

    protected File getCacheDirForArchives(File dir) {
        return new File(dir, ARCHIVESDIR);
    }

    protected void addLocalizedResourceInDir(String dir, LocalizedResourceSet lrsrcSet, boolean uncompress) {
        File[] lrsrcs = this.readCurrentBlobs(dir);
        if (lrsrcs != null) {
            for (File rsrc : lrsrcs) {
                LOG.info("add localized in dir found: " + rsrc);
                String path = rsrc.getPath();
                int p = path.lastIndexOf(46);
                if (p > 0) {
                    path = path.substring(0, p);
                }
                LOG.debug("local file is: {} path is: {}", (Object)rsrc.getPath(), (Object)path);
                LocalizedResource lrsrc = new LocalizedResource(new File(path).getName(), path, uncompress);
                lrsrcSet.add(lrsrc.getKey(), lrsrc, uncompress);
            }
        }
    }

    protected File[] readDirContents(String location) {
        File dir = new File(location);
        File[] files = null;
        if (dir.exists()) {
            files = dir.listFiles();
        }
        return files;
    }

    protected File[] readCurrentBlobs(String location) {
        File dir = new File(location);
        File[] files = null;
        if (dir.exists()) {
            files = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(".current");
                }
            });
        }
        return files;
    }

    protected void reconstructLocalizedResources() {
        try {
            LOG.info("Reconstruct localized resource: " + this.getUserCacheDir().getPath());
            File[] users = this.readDirContents(this.getUserCacheDir().getPath());
            if (users != null) {
                for (File userDir : users) {
                    String user = userDir.getName();
                    LOG.debug("looking in: {} for user: {}", (Object)userDir.getPath(), (Object)user);
                    LocalizedResourceSet newSet = new LocalizedResourceSet(user);
                    LocalizedResourceSet lrsrcSet = this._userRsrc.putIfAbsent(user, newSet);
                    if (lrsrcSet == null) {
                        lrsrcSet = newSet;
                    }
                    this.addLocalizedResourceInDir(this.getCacheDirForFiles(this.getLocalUserFileCacheDir(user)).getPath(), lrsrcSet, false);
                    this.addLocalizedResourceInDir(this.getCacheDirForArchives(this.getLocalUserFileCacheDir(user)).getPath(), lrsrcSet, true);
                }
            } else {
                LOG.warn("No left over resources found for any user during reconstructing of local resources at: {}", (Object)this.getUserCacheDir().getPath());
            }
        }
        catch (Exception e) {
            LOG.error("ERROR reconstructing localized resources", (Throwable)e);
        }
    }

    public synchronized void removeBlobReference(String key, String user, String topo, boolean uncompress) throws AuthorizationException, KeyNotFoundException {
        LocalizedResourceSet lrsrcSet = (LocalizedResourceSet)this._userRsrc.get(user);
        if (lrsrcSet != null) {
            LocalizedResource lrsrc = lrsrcSet.get(key, uncompress);
            if (lrsrc != null) {
                LOG.debug("removing blob reference to: {} for topo: {}", (Object)key, (Object)topo);
                lrsrc.removeReference(topo);
            } else {
                LOG.warn("trying to remove non-existent blob, key: " + key + " for user: " + user + " topo: " + topo);
            }
        } else {
            LOG.warn("trying to remove blob for non-existent resource set for user: " + user + " key: " + key + " topo: " + topo);
        }
    }

    public synchronized void addReferences(List<LocalResource> localresource, String user, String topo) {
        LocalizedResourceSet lrsrcSet = (LocalizedResourceSet)this._userRsrc.get(user);
        if (lrsrcSet != null) {
            for (LocalResource blob : localresource) {
                LocalizedResource lrsrc = lrsrcSet.get(blob.getBlobName(), blob.shouldUncompress());
                if (lrsrc != null) {
                    lrsrc.addReference(topo);
                    LOG.debug("added reference for topo: {} key: {}", (Object)topo, (Object)blob);
                    continue;
                }
                LOG.warn("trying to add reference to non-existent blob, key: " + blob + " topo: " + topo);
            }
        } else {
            LOG.warn("trying to add reference to non-existent local resource set, user: " + user + " topo: " + topo);
        }
    }

    public LocalizedResource getBlob(LocalResource localResource, String user, String topo, File userFileDir) throws AuthorizationException, KeyNotFoundException, IOException {
        ArrayList<LocalResource> arr = new ArrayList<LocalResource>();
        arr.add(localResource);
        List<LocalizedResource> results = this.getBlobs(arr, user, topo, userFileDir);
        if (results.isEmpty() || results.size() != 1) {
            throw new IOException("Unknown error getting blob: " + localResource + ", for user: " + user + ", topo: " + topo);
        }
        return results.get(0);
    }

    protected boolean isLocalizedResourceDownloaded(LocalizedResource lrsrc) {
        File rsrcFileCurrent = new File(lrsrc.getCurrentSymlinkPath());
        File rsrcFileWithVersion = new File(lrsrc.getFilePathWithVersion());
        File versionFile = new File(lrsrc.getVersionFilePath());
        return rsrcFileWithVersion.exists() && rsrcFileCurrent.exists() && versionFile.exists();
    }

    protected boolean isLocalizedResourceUpToDate(LocalizedResource lrsrc, ClientBlobStore blobstore) throws AuthorizationException, KeyNotFoundException {
        long currentBlobVersion;
        String localFile = lrsrc.getFilePath();
        long nimbusBlobVersion = ServerUtils.nimbusVersionOfBlob(lrsrc.getKey(), blobstore);
        return nimbusBlobVersion == (currentBlobVersion = ServerUtils.localVersionOfBlob(localFile));
    }

    protected ClientBlobStore getClientBlobStore() {
        return ServerUtils.getClientBlobStoreForSupervisor(this._conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<LocalizedResource> updateBlobs(List<LocalResource> localResources, String user) throws AuthorizationException, KeyNotFoundException, IOException {
        LocalizedResource lrsrc;
        LocalizedResourceSet lrsrcSet = (LocalizedResourceSet)this._userRsrc.get(user);
        ArrayList<LocalizedResource> results = new ArrayList<LocalizedResource>();
        ArrayList<DownloadBlob> updates = new ArrayList<DownloadBlob>();
        if (lrsrcSet == null) {
            return results;
        }
        ClientBlobStore blobstore = null;
        try {
            blobstore = this.getClientBlobStore();
            for (LocalResource localResource : localResources) {
                String key = localResource.getBlobName();
                lrsrc = lrsrcSet.get(key, localResource.shouldUncompress());
                if (lrsrc == null) {
                    LOG.warn("blob requested for update doesn't exist: {}", (Object)key);
                    continue;
                }
                if (((Boolean)this._conf.getOrDefault("storm.disable.symlinks", false)).booleanValue()) {
                    LOG.warn("symlinks are disabled so blobs cannot be downloaded.");
                    continue;
                }
                if (this.isLocalizedResourceUpToDate(lrsrc, blobstore) && this.isLocalizedResourceDownloaded(lrsrc)) continue;
                LOG.debug("updating blob: {}", (Object)key);
                updates.add(new DownloadBlob(this, this._conf, key, new File(lrsrc.getFilePath()), user, lrsrc.isUncompressed(), true));
            }
        }
        finally {
            if (blobstore != null) {
                blobstore.shutdown();
            }
        }
        try {
            List futures = this._updateExecService.invokeAll(updates);
            for (Future futureRsrc : futures) {
                try {
                    lrsrc = (LocalizedResource)futureRsrc.get();
                    LocalizedResourceSet newSet = new LocalizedResourceSet(user);
                    LocalizedResourceSet newlrsrcSet = this._userRsrc.putIfAbsent(user, newSet);
                    if (newlrsrcSet == null) {
                        newlrsrcSet = newSet;
                    }
                    newlrsrcSet.putIfAbsent(lrsrc.getKey(), lrsrc, lrsrc.isUncompressed());
                    results.add(lrsrc);
                }
                catch (ExecutionException e) {
                    LOG.error("Error updating blob: ", (Throwable)e);
                    if (e.getCause() instanceof AuthorizationException) {
                        throw (AuthorizationException)e.getCause();
                    }
                    if (!(e.getCause() instanceof KeyNotFoundException)) continue;
                    throw (KeyNotFoundException)e.getCause();
                    return results;
                }
            }
        }
        catch (RejectedExecutionException re) {
            LOG.error("Error updating blobs : ", (Throwable)re);
            return results;
        }
        catch (InterruptedException ie) {
            throw new IOException("Interrupted Exception", ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<LocalizedResource> getBlobs(List<LocalResource> localResources, String user, String topo, File userFileDir) throws AuthorizationException, KeyNotFoundException, IOException {
        if (((Boolean)this._conf.getOrDefault("storm.disable.symlinks", false)).booleanValue()) {
            throw new KeyNotFoundException("symlinks are disabled so blobs cannot be downloaded.");
        }
        LocalizedResourceSet newSet = new LocalizedResourceSet(user);
        LocalizedResourceSet lrsrcSet = this._userRsrc.putIfAbsent(user, newSet);
        if (lrsrcSet == null) {
            lrsrcSet = newSet;
        }
        ArrayList<LocalizedResource> results = new ArrayList<LocalizedResource>();
        ArrayList<DownloadBlob> downloads = new ArrayList<DownloadBlob>();
        ClientBlobStore blobstore = null;
        try {
            blobstore = this.getClientBlobStore();
            for (LocalResource localResource : localResources) {
                String key = localResource.getBlobName();
                boolean uncompress = localResource.shouldUncompress();
                LocalizedResource lrsrc = lrsrcSet.get(key, localResource.shouldUncompress());
                boolean isUpdate = false;
                if (lrsrc != null && lrsrc.isUncompressed() == localResource.shouldUncompress() && this.isLocalizedResourceDownloaded(lrsrc)) {
                    if (this.isLocalizedResourceUpToDate(lrsrc, blobstore)) {
                        LOG.debug("blob already exists: {}", (Object)key);
                        lrsrc.addReference(topo);
                        results.add(lrsrc);
                        continue;
                    }
                    LOG.debug("blob exists but isn't up to date: {}", (Object)key);
                    isUpdate = true;
                }
                LOG.debug("fetching blob: {}", (Object)key);
                File downloadDir = this.getCacheDirForFiles(userFileDir);
                File localFile = new File(downloadDir, key);
                if (uncompress) {
                    downloadDir = this.getCacheDirForArchives(userFileDir);
                    localFile = new File(downloadDir, key);
                }
                downloadDir.mkdir();
                downloads.add(new DownloadBlob(this, this._conf, key, localFile, user, uncompress, isUpdate));
            }
        }
        finally {
            if (blobstore != null) {
                blobstore.shutdown();
            }
        }
        try {
            List futures = this._execService.invokeAll(downloads);
            for (Future futureRsrc : futures) {
                LocalizedResource lrsrc = (LocalizedResource)futureRsrc.get();
                lrsrc.addReference(topo);
                lrsrcSet.add(lrsrc.getKey(), lrsrc, lrsrc.isUncompressed());
                results.add(lrsrc);
            }
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof AuthorizationException) {
                throw (AuthorizationException)e.getCause();
            }
            if (e.getCause() instanceof KeyNotFoundException) {
                throw (KeyNotFoundException)e.getCause();
            }
            throw new IOException("Error getting blobs", e);
        }
        catch (RejectedExecutionException re) {
            throw new IOException("RejectedExecutionException: ", re);
        }
        catch (InterruptedException ie) {
            throw new IOException("Interrupted Exception", ie);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalizedResource downloadBlob(Map<String, Object> conf, String key, File localFile, String user, boolean uncompress, boolean isUpdate) throws AuthorizationException, KeyNotFoundException, IOException {
        ClientBlobStore blobstore = null;
        try {
            blobstore = this.getClientBlobStore();
            long nimbusBlobVersion = ServerUtils.nimbusVersionOfBlob(key, blobstore);
            long oldVersion = ServerUtils.localVersionOfBlob(localFile.toString());
            FileOutputStream out = null;
            PrintWriter writer = null;
            int numTries = 0;
            String localizedPath = localFile.toString();
            String localFileWithVersion = ServerUtils.constructBlobWithVersionFileName(localFile.toString(), nimbusBlobVersion);
            String localVersionFile = ServerUtils.constructVersionFileName(localFile.toString());
            String downloadFile = localFileWithVersion;
            if (uncompress) {
                downloadFile = new File(localFile.getParent(), TO_UNCOMPRESS + localFile.getName()).toString();
            }
            while (numTries < this._blobDownloadRetries) {
                out = new FileOutputStream(downloadFile);
                ++numTries;
                try {
                    int len;
                    if (!ServerUtils.canUserReadBlob(blobstore.getBlobMeta(key), user)) {
                        throw new AuthorizationException(user + " does not have READ access to " + key);
                    }
                    InputStreamWithMeta in = blobstore.getBlob(key);
                    byte[] buffer = new byte[1024];
                    while ((len = in.read(buffer)) >= 0) {
                        out.write(buffer, 0, len);
                    }
                    out.close();
                    in.close();
                    if (uncompress) {
                        ServerUtils.unpack(new File(downloadFile), new File(localFileWithVersion));
                        LOG.debug("uncompressed " + downloadFile + " to: " + localFileWithVersion);
                    }
                    LOG.info("Blob: " + key + " updated with new Nimbus-provided version: " + nimbusBlobVersion + " local version was: " + oldVersion);
                    writer = new PrintWriter(new BufferedWriter(new FileWriter(localVersionFile, false)));
                    writer.println(nimbusBlobVersion);
                    writer.close();
                    try {
                        this.setBlobPermissions(conf, user, localFileWithVersion);
                        this.setBlobPermissions(conf, user, localVersionFile);
                        String tmp_uuid_local = UUID.randomUUID().toString();
                        LOG.debug("Creating a symlink @" + localFile + "." + tmp_uuid_local + " , linking to: " + localFile + "." + nimbusBlobVersion);
                        File uuid_symlink = new File(localFile + "." + tmp_uuid_local);
                        Files.createSymbolicLink(uuid_symlink.toPath(), Paths.get(ServerUtils.constructBlobWithVersionFileName(localFile.toString(), nimbusBlobVersion), new String[0]), new FileAttribute[0]);
                        File current_symlink = new File(ServerUtils.constructBlobCurrentSymlinkName(localFile.toString()));
                        Files.move(uuid_symlink.toPath(), current_symlink.toPath(), StandardCopyOption.ATOMIC_MOVE);
                    }
                    catch (IOException e) {
                        try {
                            PrintWriter restoreWriter = new PrintWriter(new BufferedWriter(new FileWriter(localVersionFile, false)));
                            restoreWriter.println(oldVersion);
                            restoreWriter.close();
                        }
                        catch (IOException restoreWriter) {
                            // empty catch block
                        }
                        throw e;
                    }
                    String oldBlobFile = localFile + "." + oldVersion;
                    try {
                        if (oldVersion == -1L || oldVersion == nimbusBlobVersion) break;
                        LOG.info("Removing an old blob file:" + oldBlobFile);
                        Files.delete(Paths.get(oldBlobFile, new String[0]));
                    }
                    catch (IOException e) {
                        LOG.error("Exception removing old blob version: " + oldBlobFile);
                    }
                    break;
                }
                catch (AuthorizationException ae) {
                    if (out != null) {
                        out.close();
                    }
                    new File(downloadFile).delete();
                    throw ae;
                }
                catch (IOException | KeyNotFoundException e) {
                    if (out != null) {
                        out.close();
                    }
                    if (writer != null) {
                        writer.close();
                    }
                    new File(downloadFile).delete();
                    if (uncompress) {
                        try {
                            FileUtils.deleteDirectory((File)new File(localFileWithVersion));
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (!isUpdate) {
                        new File(localVersionFile).delete();
                    }
                    if (numTries < this._blobDownloadRetries) {
                        LOG.error("Failed to download blob, retrying", e);
                        continue;
                    }
                    throw e;
                }
            }
            LocalizedResource localizedResource = new LocalizedResource(key, localizedPath, uncompress);
            return localizedResource;
        }
        finally {
            if (blobstore != null) {
                blobstore.shutdown();
            }
        }
    }

    public void setBlobPermissions(Map<String, Object> conf, String user, String path) throws IOException {
        if (!ObjectReader.getBoolean((Object)conf.get("supervisor.run.worker.as.user"), (boolean)false)) {
            return;
        }
        String wlCommand = ObjectReader.getString((Object)conf.get("supervisor.worker.launcher"), (String)"");
        if (wlCommand.isEmpty()) {
            String stormHome = System.getProperty("storm.home");
            wlCommand = stormHome + "/bin/worker-launcher";
        }
        ArrayList<String> command = new ArrayList<String>(Arrays.asList(wlCommand, user, "blob", path));
        Object[] commandArray = command.toArray(new String[command.size()]);
        ShellUtils.ShellCommandExecutor shExec = new ShellUtils.ShellCommandExecutor((String[])commandArray);
        LOG.info("Setting blob permissions, command: {}", (Object)Arrays.toString(commandArray));
        try {
            shExec.execute();
            LOG.debug("output: {}", (Object)shExec.getOutput());
        }
        catch (ShellUtils.ExitCodeException e) {
            int exitCode = shExec.getExitCode();
            LOG.warn("Exit code from worker-launcher is : " + exitCode, (Throwable)e);
            LOG.debug("output: {}", (Object)shExec.getOutput());
            throw new IOException("Setting blob permissions failed (exitCode=" + exitCode + ") with output: " + shExec.getOutput(), e);
        }
    }

    public synchronized void handleCacheCleanup() {
        LocalizedResourceRetentionSet toClean = new LocalizedResourceRetentionSet(this._cacheTargetSize);
        for (LocalizedResourceSet t : this._userRsrc.values()) {
            toClean.addResources(t);
            LOG.debug("Resources to be cleaned after adding {} : {}", (Object)t.getUser(), (Object)toClean);
        }
        toClean.cleanup();
        LOG.debug("Resource cleanup: {}", (Object)toClean);
        for (LocalizedResourceSet t : this._userRsrc.values()) {
            if (t.getSize() != 0) continue;
            String user = t.getUser();
            LOG.debug("removing empty set: {}", (Object)user);
            File userFileCacheDir = this.getLocalUserFileCacheDir(user);
            this.getCacheDirForFiles(userFileCacheDir).delete();
            this.getCacheDirForArchives(userFileCacheDir).delete();
            this.getLocalUserFileCacheDir(user).delete();
            boolean dirsRemoved = this.getLocalUserDir(user).delete();
            if (!dirsRemoved) continue;
            this._userRsrc.remove(user);
        }
    }

    static class DownloadBlob
    implements Callable<LocalizedResource> {
        private Localizer _localizer;
        private Map _conf;
        private String _key;
        private File _localFile;
        private String _user;
        private boolean _uncompress;
        private boolean _isUpdate;

        public DownloadBlob(Localizer localizer, Map<String, Object> conf, String key, File localFile, String user, boolean uncompress, boolean update) {
            this._localizer = localizer;
            this._conf = conf;
            this._key = key;
            this._localFile = localFile;
            this._user = user;
            this._uncompress = uncompress;
            this._isUpdate = update;
        }

        @Override
        public LocalizedResource call() throws AuthorizationException, KeyNotFoundException, IOException {
            return this._localizer.downloadBlob(this._conf, this._key, this._localFile, this._user, this._uncompress, this._isUpdate);
        }
    }
}

