/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.pacemaker.codec;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.storm.messaging.netty.ISaslServer;
import org.apache.storm.messaging.netty.IServer;
import org.apache.storm.messaging.netty.KerberosSaslServerHandler;
import org.apache.storm.messaging.netty.SaslStormServerHandler;
import org.apache.storm.messaging.netty.StormServerHandler;
import org.apache.storm.pacemaker.codec.ThriftDecoder;
import org.apache.storm.pacemaker.codec.ThriftEncoder;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftNettyServerCodec {
    public static final String SASL_HANDLER = "sasl-handler";
    public static final String KERBEROS_HANDLER = "kerberos-handler";
    private IServer server;
    private AuthMethod authMethod;
    private Map<String, Object> topoConf;
    private static final Logger LOG = LoggerFactory.getLogger(ThriftNettyServerCodec.class);

    public ThriftNettyServerCodec(IServer server, Map<String, Object> topoConf, AuthMethod authMethod) {
        this.server = server;
        this.authMethod = authMethod;
        this.topoConf = topoConf;
    }

    public ChannelPipelineFactory pipelineFactory() {
        return new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() {
                ChannelPipeline pipeline = Channels.pipeline();
                pipeline.addLast("encoder", (ChannelHandler)new ThriftEncoder());
                pipeline.addLast("decoder", (ChannelHandler)new ThriftDecoder());
                if (ThriftNettyServerCodec.this.authMethod == AuthMethod.DIGEST) {
                    try {
                        LOG.debug("Adding SaslStormServerHandler to pacemaker server pipeline.");
                        pipeline.addLast(ThriftNettyServerCodec.SASL_HANDLER, (ChannelHandler)new SaslStormServerHandler((ISaslServer)ThriftNettyServerCodec.this.server));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                } else if (ThriftNettyServerCodec.this.authMethod == AuthMethod.KERBEROS) {
                    try {
                        LOG.debug("Adding KerberosSaslServerHandler to pacemaker server pipeline.");
                        ArrayList<String> authorizedUsers = new ArrayList<String>(1);
                        authorizedUsers.add((String)ThriftNettyServerCodec.this.topoConf.get("nimbus.daemon.user"));
                        pipeline.addLast(ThriftNettyServerCodec.KERBEROS_HANDLER, (ChannelHandler)new KerberosSaslServerHandler((ISaslServer)ThriftNettyServerCodec.this.server, ThriftNettyServerCodec.this.topoConf, "PacemakerServer", authorizedUsers));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                } else if (ThriftNettyServerCodec.this.authMethod == AuthMethod.NONE) {
                    LOG.debug("Not authenticating any clients. AuthMethod is NONE");
                }
                pipeline.addLast("handler", (ChannelHandler)new StormServerHandler(ThriftNettyServerCodec.this.server));
                return pipeline;
            }
        };
    }

    public static enum AuthMethod {
        DIGEST,
        KERBEROS,
        NONE;

    }
}

