/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.resource.strategies.eviction;

import java.util.Collection;
import java.util.Map;
import org.apache.storm.scheduler.Cluster;
import org.apache.storm.scheduler.TopologyDetails;
import org.apache.storm.scheduler.resource.RAS_Nodes;
import org.apache.storm.scheduler.resource.SchedulingState;
import org.apache.storm.scheduler.resource.User;
import org.apache.storm.scheduler.resource.strategies.eviction.IEvictionStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEvictionStrategy
implements IEvictionStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultEvictionStrategy.class);
    private Cluster cluster;
    private Map<String, User> userMap;
    private RAS_Nodes nodes;

    @Override
    public void prepare(SchedulingState schedulingState) {
        this.cluster = schedulingState.cluster;
        this.userMap = schedulingState.userMap;
        this.nodes = schedulingState.nodes;
    }

    @Override
    public boolean makeSpaceForTopo(TopologyDetails td) {
        LOG.debug("attempting to make space for topo {} from user {}", (Object)td.getName(), (Object)td.getTopologySubmitter());
        User submitter = this.userMap.get(td.getTopologySubmitter());
        if (submitter.getCPUResourceGuaranteed() == null || submitter.getMemoryResourceGuaranteed() == null || submitter.getCPUResourceGuaranteed() == 0.0 || submitter.getMemoryResourceGuaranteed() == 0.0) {
            return false;
        }
        double cpuNeeded = td.getTotalRequestedCpu() / submitter.getCPUResourceGuaranteed();
        double memoryNeeded = (td.getTotalRequestedMemOffHeap() + td.getTotalRequestedMemOnHeap()) / submitter.getMemoryResourceGuaranteed();
        User evictUser = this.findUserWithHighestAverageResourceUtilAboveGuarantee();
        if (1.0 - submitter.getCPUResourcePoolUtilization() >= cpuNeeded && 1.0 - submitter.getMemoryResourcePoolUtilization() >= memoryNeeded) {
            if (evictUser != null) {
                TopologyDetails topologyEvict = evictUser.getRunningTopologyWithLowestPriority();
                LOG.debug("Running Topology {} from user {} is still within user's resource guarantee thus, POTENTIALLY evicting Topology {} from user {} since:\n(1.0 - submitter.getCPUResourcePoolUtilization()) = {} >= cpuNeeded = {}\nand\n(1.0 - submitter.getMemoryResourcePoolUtilization()) = {} >= memoryNeeded = {}", new Object[]{td, submitter, topologyEvict, evictUser, 1.0 - submitter.getCPUResourcePoolUtilization(), cpuNeeded, 1.0 - submitter.getMemoryResourcePoolUtilization(), memoryNeeded});
                this.evictTopology(topologyEvict);
                return true;
            }
        } else if (evictUser != null && evictUser.getResourcePoolAverageUtilization() - 1.0 > (cpuNeeded + memoryNeeded) / 2.0 + (submitter.getResourcePoolAverageUtilization() - 1.0)) {
            TopologyDetails topologyEvict = evictUser.getRunningTopologyWithLowestPriority();
            LOG.debug("POTENTIALLY Evicting Topology {} from user {} since:\n((evictUser.getResourcePoolAverageUtilization() - 1.0) = {}\n(cpuNeeded + memoryNeeded) / 2) = {} and (submitter.getResourcePoolAverageUtilization() - 1.0)) = {} Thus,\n(evictUser.getResourcePoolAverageUtilization() - 1.0) = {} > (((cpuNeeded + memoryNeeded) / 2) + (submitter.getResourcePoolAverageUtilization() - 1.0)) = {}", new Object[]{topologyEvict, evictUser, evictUser.getResourcePoolAverageUtilization() - 1.0, (cpuNeeded + memoryNeeded) / 2.0, submitter.getResourcePoolAverageUtilization() - 1.0, evictUser.getResourcePoolAverageUtilization() - 1.0, (cpuNeeded + memoryNeeded) / 2.0 + (submitter.getResourcePoolAverageUtilization() - 1.0)});
            this.evictTopology(topologyEvict);
            return true;
        }
        for (TopologyDetails topo : submitter.getTopologiesRunning()) {
            if (topo.getTopologyPriority() <= td.getTopologyPriority()) continue;
            LOG.debug("POTENTIALLY Evicting Topology {} from user {} (itself) since topology {} has a lower priority than topology {}", new Object[]{topo, submitter, topo, td});
            this.evictTopology(topo);
            return true;
        }
        return false;
    }

    private void evictTopology(TopologyDetails topologyEvict) {
        Collection workersToEvict = this.cluster.getUsedSlotsByTopologyId(topologyEvict.getId());
        User submitter = this.userMap.get(topologyEvict.getTopologySubmitter());
        LOG.info("Evicting Topology {} with workers: {} from user {}", new Object[]{topologyEvict.getName(), workersToEvict, topologyEvict.getTopologySubmitter()});
        this.nodes.freeSlots(workersToEvict);
        submitter.moveTopoFromRunningToPending(topologyEvict, this.cluster);
    }

    private User findUserWithHighestAverageResourceUtilAboveGuarantee() {
        double most = 0.0;
        User mostOverUser = null;
        for (User user : this.userMap.values()) {
            double over = user.getResourcePoolAverageUtilization() - 1.0;
            if (!(over > most) || user.getTopologiesRunning().isEmpty()) continue;
            most = over;
            mostOverUser = user;
        }
        return mostOverUser;
    }
}

