/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.resource.strategies.priority;

import java.util.Map;
import org.apache.storm.scheduler.Cluster;
import org.apache.storm.scheduler.TopologyDetails;
import org.apache.storm.scheduler.resource.SchedulingState;
import org.apache.storm.scheduler.resource.User;
import org.apache.storm.scheduler.resource.strategies.priority.ISchedulingPriorityStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSchedulingPriorityStrategy
implements ISchedulingPriorityStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSchedulingPriorityStrategy.class);
    private Cluster cluster;
    private Map<String, User> userMap;

    @Override
    public void prepare(SchedulingState schedulingState) {
        this.cluster = schedulingState.cluster;
        this.userMap = schedulingState.userMap;
    }

    @Override
    public TopologyDetails getNextTopologyToSchedule() {
        User nextUser = this.getNextUser();
        if (nextUser == null) {
            return null;
        }
        return nextUser.getNextTopologyToSchedule();
    }

    public User getNextUser() {
        Double least = Double.POSITIVE_INFINITY;
        User ret = null;
        for (User user : this.userMap.values()) {
            double userMemoryPercentage;
            if (!user.hasTopologyNeedSchedule()) continue;
            Double userResourcePoolAverageUtilization = user.getResourcePoolAverageUtilization();
            if (least > userResourcePoolAverageUtilization) {
                ret = user;
                least = userResourcePoolAverageUtilization;
                continue;
            }
            if (!(Math.abs(least - userResourcePoolAverageUtilization) < 1.0E-4)) continue;
            double currentCpuPercentage = ret.getCPUResourceGuaranteed() / this.cluster.getClusterTotalCPUResource();
            double currentMemoryPercentage = ret.getMemoryResourceGuaranteed() / this.cluster.getClusterTotalMemoryResource();
            double currentAvgPercentage = (currentCpuPercentage + currentMemoryPercentage) / 2.0;
            double userCpuPercentage = user.getCPUResourceGuaranteed() / this.cluster.getClusterTotalCPUResource();
            double userAvgPercentage = (userCpuPercentage + (userMemoryPercentage = user.getMemoryResourceGuaranteed() / this.cluster.getClusterTotalMemoryResource())) / 2.0;
            if (!(userAvgPercentage > currentAvgPercentage)) continue;
            ret = user;
            least = userResourcePoolAverageUtilization;
        }
        return ret;
    }
}

