/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.testing;

import java.util.List;
import org.apache.storm.testing.TmpPath;
import org.apache.storm.zookeeper.Zookeeper;
import org.apache.zookeeper.server.NIOServerCnxnFactory;

public class InProcessZookeeper
implements AutoCloseable {
    private final TmpPath zkTmp = new TmpPath();
    private final NIOServerCnxnFactory zookeeper;
    private final long zkPort;

    public InProcessZookeeper() throws Exception {
        List portAndHandle = Zookeeper.mkInprocessZookeeper(this.zkTmp.getPath(), null);
        this.zkPort = (Long)portAndHandle.get(0);
        this.zookeeper = (NIOServerCnxnFactory)portAndHandle.get(1);
    }

    public long getPort() {
        return this.zkPort;
    }

    @Override
    public void close() throws Exception {
        Zookeeper.shutdownInprocessZookeeper(this.zookeeper);
        this.zkTmp.close();
    }
}

