/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.zookeeper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.curator.framework.recipes.leader.LeaderLatchListener;
import org.apache.curator.framework.recipes.leader.Participant;
import org.apache.storm.blobstore.BlobStore;
import org.apache.storm.nimbus.ILeaderElector;
import org.apache.storm.nimbus.NimbusInfo;
import org.apache.storm.utils.Utils;
import org.apache.storm.zookeeper.Zookeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaderElectorImp
implements ILeaderElector {
    private static Logger LOG = LoggerFactory.getLogger(LeaderElectorImp.class);
    private final Map<String, Object> conf;
    private final List<String> servers;
    private final CuratorFramework zk;
    private final String leaderlockPath;
    private final String id;
    private final AtomicReference<LeaderLatch> leaderLatch;
    private final AtomicReference<LeaderLatchListener> leaderLatchListener;
    private final BlobStore blobStore;

    public LeaderElectorImp(Map<String, Object> conf, List<String> servers, CuratorFramework zk, String leaderlockPath, String id, AtomicReference<LeaderLatch> leaderLatch, AtomicReference<LeaderLatchListener> leaderLatchListener, BlobStore blobStore) {
        this.conf = conf;
        this.servers = servers;
        this.zk = zk;
        this.leaderlockPath = leaderlockPath;
        this.id = id;
        this.leaderLatch = leaderLatch;
        this.leaderLatchListener = leaderLatchListener;
        this.blobStore = blobStore;
    }

    @Override
    public void prepare(Map<String, Object> conf) {
    }

    @Override
    public void addToLeaderLockQueue() throws Exception {
        if (LeaderLatch.State.CLOSED.equals((Object)this.leaderLatch.get().getState())) {
            this.leaderLatch.set(new LeaderLatch(this.zk, this.leaderlockPath));
            this.leaderLatchListener.set(Zookeeper.leaderLatchListenerImpl(this.conf, this.zk, this.blobStore, this.leaderLatch.get()));
            LOG.info("LeaderLatch was in closed state. Resetted the leaderLatch and listeners.");
        }
        if (LeaderLatch.State.LATENT.equals((Object)this.leaderLatch.get().getState())) {
            this.leaderLatch.get().addListener(this.leaderLatchListener.get());
            this.leaderLatch.get().start();
            LOG.info("Queued up for leader lock.");
        } else {
            LOG.info("Node already in queue for leader lock.");
        }
    }

    @Override
    public void removeFromLeaderLockQueue() throws Exception {
        if (LeaderLatch.State.STARTED.equals((Object)this.leaderLatch.get().getState())) {
            this.leaderLatch.get().close();
            LOG.info("Removed from leader lock queue.");
        } else {
            LOG.info("leader latch is not started so no removeFromLeaderLockQueue needed.");
        }
    }

    @Override
    public boolean isLeader() throws Exception {
        return this.leaderLatch.get().hasLeadership();
    }

    @Override
    public NimbusInfo getLeader() {
        try {
            return Zookeeper.toNimbusInfo(this.leaderLatch.get().getLeader());
        }
        catch (Exception e) {
            throw Utils.wrapInRuntime((Exception)e);
        }
    }

    @Override
    public List<NimbusInfo> getAllNimbuses() throws Exception {
        ArrayList<NimbusInfo> nimbusInfos = new ArrayList<NimbusInfo>();
        Collection participants = this.leaderLatch.get().getParticipants();
        for (Participant participant : participants) {
            nimbusInfos.add(Zookeeper.toNimbusInfo(participant));
        }
        return nimbusInfos;
    }

    @Override
    public void close() {
        LOG.info("closing zookeeper connection of leader elector.");
        this.zk.close();
    }
}

