/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.test.mock;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.faces.el.EvaluationException;
import javax.faces.el.PropertyNotFoundException;
import javax.faces.el.PropertyResolver;
import org.apache.commons.beanutils.PropertyUtils;

public class MockPropertyResolver
extends PropertyResolver {
    public Object getValue(Object base, Object property) throws EvaluationException, PropertyNotFoundException {
        if (base == null) {
            throw new NullPointerException();
        }
        String name = property.toString();
        try {
            if (base instanceof Map) {
                Map map = (Map)base;
                if (map.containsKey(name)) {
                    return map.get(name);
                }
                throw new PropertyNotFoundException(name);
            }
            return PropertyUtils.getSimpleProperty((Object)base, (String)name);
        }
        catch (IllegalAccessException e) {
            throw new EvaluationException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new EvaluationException(e.getTargetException());
        }
        catch (NoSuchMethodException e) {
            throw new PropertyNotFoundException(name);
        }
    }

    public Object getValue(Object base, int index) throws PropertyNotFoundException {
        return this.getValue(base, "" + index);
    }

    public void setValue(Object base, Object property, Object value) throws PropertyNotFoundException {
        if (base == null) {
            throw new NullPointerException();
        }
        String name = property.toString();
        try {
            if (base instanceof Map) {
                ((Map)base).put(name, value);
            } else {
                PropertyUtils.setSimpleProperty((Object)base, (String)name, (Object)value);
            }
        }
        catch (IllegalAccessException e) {
            throw new EvaluationException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new EvaluationException(e.getTargetException());
        }
        catch (NoSuchMethodException e) {
            throw new PropertyNotFoundException(name);
        }
    }

    public void setValue(Object base, int index, Object value) throws PropertyNotFoundException {
        this.setValue(base, "" + index, value);
    }

    public boolean isReadOnly(Object base, Object property) throws PropertyNotFoundException {
        if (base == null) {
            throw new NullPointerException();
        }
        String name = property.toString();
        return !PropertyUtils.isWriteable((Object)base, (String)name);
    }

    public boolean isReadOnly(Object base, int index) throws PropertyNotFoundException {
        return this.isReadOnly(base, "" + index);
    }

    public Class getType(Object base, Object property) throws PropertyNotFoundException {
        if (base == null) {
            throw new NullPointerException();
        }
        String name = property.toString();
        try {
            return PropertyUtils.getPropertyType((Object)base, (String)name);
        }
        catch (IllegalAccessException e) {
            throw new EvaluationException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new EvaluationException(e.getTargetException());
        }
        catch (NoSuchMethodException e) {
            throw new PropertyNotFoundException(name);
        }
    }

    public Class getType(Object base, int index) throws PropertyNotFoundException {
        return this.getType(base, "" + index);
    }
}

