/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.tiles;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.PageContext;

public class ComponentContext
implements Serializable {
    private Map attributes = null;

    public ComponentContext() {
    }

    public ComponentContext(Map attributes) {
        if (attributes != null) {
            this.attributes = new HashMap(attributes);
        }
    }

    public void addAll(Map newAttributes) {
        if (this.attributes == null) {
            this.attributes = new HashMap(newAttributes);
            return;
        }
        this.attributes.putAll(newAttributes);
    }

    public void addMissing(Map defaultAttributes) {
        if (defaultAttributes == null) {
            return;
        }
        if (this.attributes == null) {
            this.attributes = new HashMap(defaultAttributes);
            return;
        }
        Set entries = defaultAttributes.entrySet();
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (this.attributes.containsKey(entry.getKey())) continue;
            this.attributes.put(entry.getKey(), entry.getValue());
        }
    }

    public Object getAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    public Iterator getAttributeNames() {
        if (this.attributes == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.attributes.keySet().iterator();
    }

    public void putAttribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(name, value);
    }

    public Object findAttribute(String beanName, PageContext pageContext) {
        Object attribute = this.getAttribute(beanName);
        if (attribute == null) {
            attribute = pageContext.findAttribute(beanName);
        }
        return attribute;
    }

    public Object getAttribute(String beanName, int scope, PageContext pageContext) {
        if (scope == 8) {
            return this.getAttribute(beanName);
        }
        return pageContext.getAttribute(beanName, scope);
    }

    public static ComponentContext getContext(ServletRequest request) {
        if (request.getAttribute("javax.servlet.jsp.jspException") != null) {
            return null;
        }
        return (ComponentContext)request.getAttribute("org.apache.struts.taglib.tiles.CompContext");
    }

    public static void setContext(ComponentContext context, ServletRequest request) {
        request.setAttribute("org.apache.struts.taglib.tiles.CompContext", (Object)context);
    }
}

