/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.convention;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionSupport;
import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.Result;
import com.opensymphony.xwork2.UnknownHandler;
import com.opensymphony.xwork2.XWorkException;
import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.config.entities.InterceptorLocator;
import com.opensymphony.xwork2.config.entities.PackageConfig;
import com.opensymphony.xwork2.config.entities.ResultConfig;
import com.opensymphony.xwork2.config.entities.ResultTypeConfig;
import com.opensymphony.xwork2.config.providers.InterceptorBuilder;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.ClassLoaderUtil;
import com.opensymphony.xwork2.util.TextParseUtil;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.convention.ConventionsService;
import org.apache.struts2.convention.ResultMapBuilder;

public class ConventionUnknownHandler
implements UnknownHandler {
    private static final Logger LOG = LogManager.getLogger(ConventionUnknownHandler.class);
    protected Configuration configuration;
    protected ObjectFactory objectFactory;
    protected ServletContext servletContext;
    protected ResultMapBuilder resultMapBuilder;
    protected String defaultParentPackageName;
    protected PackageConfig parentPackage;
    private boolean redirectToSlash;
    private ConventionsService conventionsService;
    private String nameSeparator;
    protected Set<String> allowedMethods = new HashSet<String>();

    @Inject
    public ConventionUnknownHandler(Configuration configuration, ObjectFactory objectFactory, ServletContext servletContext, Container container, @Inject(value="struts.convention.default.parent.package") String defaultParentPackageName, @Inject(value="struts.convention.redirect.to.slash") String redirectToSlash, @Inject(value="struts.convention.action.name.separator") String nameSeparator) {
        this.configuration = configuration;
        this.objectFactory = objectFactory;
        this.servletContext = servletContext;
        this.resultMapBuilder = (ResultMapBuilder)container.getInstance(ResultMapBuilder.class, (String)container.getInstance(String.class, "struts.convention.resultMapBuilder"));
        this.conventionsService = (ConventionsService)container.getInstance(ConventionsService.class, (String)container.getInstance(String.class, "struts.convention.conventionsService"));
        this.defaultParentPackageName = defaultParentPackageName;
        this.nameSeparator = nameSeparator;
        this.parentPackage = configuration.getPackageConfig(defaultParentPackageName);
        if (this.parentPackage == null) {
            throw new ConfigurationException("Unknown default parent package [" + defaultParentPackageName + "]");
        }
        this.redirectToSlash = Boolean.parseBoolean(redirectToSlash);
        this.allowedMethods = TextParseUtil.commaDelimitedStringToSet((String)"execute,input,back,cancel,browse");
    }

    public ActionConfig handleUnknownAction(String namespace, String actionName) throws XWorkException {
        Resource resource;
        if (namespace == null || "/".equals(namespace)) {
            namespace = "";
        }
        Map<String, ResultTypeConfig> resultsByExtension = this.conventionsService.getResultTypesByExtension(this.parentPackage);
        String pathPrefix = this.determinePath(null, namespace);
        ActionConfig actionConfig = null;
        if (!actionName.equals("") && (resource = this.findResource(resultsByExtension, pathPrefix, actionName)) != null) {
            actionConfig = this.buildActionConfig(resource.path, resultsByExtension.get(resource.ext));
        }
        if (actionConfig == null) {
            resource = this.findResource(resultsByExtension, pathPrefix, actionName, "/index");
            if (!actionName.equals("") && this.redirectToSlash) {
                ResultTypeConfig redirectResultTypeConfig = (ResultTypeConfig)this.parentPackage.getAllResultTypeConfigs().get("redirect");
                String redirectNamespace = namespace + "/" + actionName;
                LOG.trace("Checking if there is an action named index in the namespace {}", new Object[]{redirectNamespace});
                actionConfig = this.configuration.getRuntimeConfiguration().getActionConfig(redirectNamespace, "index");
                if (actionConfig != null) {
                    LOG.trace("Found action config");
                    PackageConfig packageConfig = this.configuration.getPackageConfig(actionConfig.getPackageName());
                    if (redirectNamespace.equals(packageConfig.getNamespace())) {
                        LOG.trace("Action is not a default - redirecting");
                        return this.buildActionConfig(redirectNamespace + "/", redirectResultTypeConfig);
                    }
                    LOG.trace("Action was a default - NOT redirecting");
                }
                if (resource != null) {
                    return this.buildActionConfig(redirectNamespace + "/", redirectResultTypeConfig);
                }
            }
            if (resource != null) {
                actionConfig = this.buildActionConfig(resource.path, resultsByExtension.get(resource.ext));
            }
            if (actionConfig == null) {
                LOG.trace("Looking for action named [index] in namespace [{}] or in default namespace", new Object[]{namespace});
                actionConfig = this.configuration.getRuntimeConfiguration().getActionConfig(namespace, "index");
            }
        }
        return actionConfig;
    }

    protected Resource findResource(Map<String, ResultTypeConfig> resultsByExtension, String ... parts) {
        for (String ext : resultsByExtension.keySet()) {
            String canonicalPath = this.canonicalize(this.string(parts) + "." + ext);
            LOG.trace("Checking for {}", new Object[]{canonicalPath});
            try {
                if (this.servletContext.getResource(canonicalPath) == null) continue;
                return new Resource(canonicalPath, ext);
            }
            catch (MalformedURLException e) {
                LOG.error("Unable to parse path to the web application resource {} skipping...", new Object[]{canonicalPath});
            }
        }
        return null;
    }

    protected String canonicalize(String path) {
        if (path == null) {
            return null;
        }
        return path.replaceAll("/+", "/");
    }

    protected ActionConfig buildActionConfig(String path, ResultTypeConfig resultTypeConfig) {
        HashMap<String, ResultConfig> results = new HashMap<String, ResultConfig>();
        HashMap<String, String> params = new HashMap<String, String>();
        if (resultTypeConfig.getParams() != null) {
            params.putAll(resultTypeConfig.getParams());
        }
        params.put(resultTypeConfig.getDefaultResultParam(), path);
        PackageConfig pkg = this.configuration.getPackageConfig(this.defaultParentPackageName);
        List interceptors = InterceptorBuilder.constructInterceptorReference((InterceptorLocator)pkg, (String)pkg.getFullDefaultInterceptorRef(), Collections.emptyMap(), null, (ObjectFactory)this.objectFactory);
        ResultConfig config = new ResultConfig.Builder("success", resultTypeConfig.getClassName()).addParams(params).build();
        results.put("success", config);
        return new ActionConfig.Builder(this.defaultParentPackageName, "execute", ActionSupport.class.getName()).addInterceptors(interceptors).addResultConfigs(results).build();
    }

    private Result scanResultsByExtension(String ns, String actionName, String pathPrefix, String resultCode, ActionContext actionContext) {
        Map<String, ResultTypeConfig> resultsByExtension = this.conventionsService.getResultTypesByExtension(this.parentPackage);
        Result result = null;
        for (String ext : resultsByExtension.keySet()) {
            String path;
            if (LOG.isTraceEnabled()) {
                String fqan = ns + "/" + actionName;
                LOG.trace("Trying to locate the correct result for the FQ action [{}] with an file extension of [{}] in the directory [{}] and a result code of [{}]", new Object[]{fqan, ext, pathPrefix, resultCode});
            }
            if ((result = this.findResult(path = this.string(pathPrefix, actionName, this.nameSeparator, resultCode, ".", ext), resultCode, ext, actionContext, resultsByExtension)) != null) break;
            path = this.string(pathPrefix, actionName, ".", ext);
            result = this.findResult(path, resultCode, ext, actionContext, resultsByExtension);
            if (result != null) break;
            path = this.string(pathPrefix, resultCode, ".", ext);
            result = this.findResult(path, resultCode, ext, actionContext, resultsByExtension);
            if (result == null) continue;
            break;
        }
        return result;
    }

    public Result handleUnknownResult(ActionContext actionContext, String actionName, ActionConfig actionConfig, String resultCode) throws XWorkException {
        String pathPrefix;
        PackageConfig pkg = this.configuration.getPackageConfig(actionConfig.getPackageName());
        String ns = pkg.getNamespace();
        Result result = this.scanResultsByExtension(ns, actionName, pathPrefix = this.determinePath(actionConfig, ns), resultCode, actionContext);
        if (result == null) {
            Map<String, ResultTypeConfig> resultsByExtension = this.conventionsService.getResultTypesByExtension(pkg);
            for (String ext : resultsByExtension.keySet()) {
                String path;
                if (LOG.isTraceEnabled()) {
                    String fqan = ns + "/" + actionName;
                    LOG.trace("Checking for [{}/index.{}]", new Object[]{fqan, ext});
                }
                if ((result = this.findResult(path = this.string(pathPrefix, actionName, "/index", this.nameSeparator, resultCode, ".", ext), resultCode, ext, actionContext, resultsByExtension)) == null && (result = this.findResult(path = this.string(pathPrefix, actionName, "/index.", ext), resultCode, ext, actionContext, resultsByExtension)) == null) continue;
                break;
            }
        }
        if (result == null && resultCode != null) {
            String chainedTo = actionName + this.nameSeparator + resultCode;
            ActionConfig chainedToConfig = (ActionConfig)pkg.getActionConfigs().get(chainedTo);
            if (chainedToConfig != null) {
                LOG.trace("Action [{}] used as chain result for [{}] and result [{}]", new Object[]{chainedTo, actionName, resultCode});
                ResultTypeConfig chainResultType = (ResultTypeConfig)pkg.getAllResultTypeConfigs().get("chain");
                result = this.buildResult(chainedTo, resultCode, chainResultType, actionContext);
            }
        }
        return result;
    }

    protected Result findResult(String path, String resultCode, String ext, ActionContext actionContext, Map<String, ResultTypeConfig> resultsByExtension) {
        try {
            String classLoaderPath;
            LOG.trace("Checking ServletContext for {}", new Object[]{path});
            if (this.servletContext.getResource(path) != null) {
                LOG.trace("Found");
                return this.buildResult(path, resultCode, resultsByExtension.get(ext), actionContext);
            }
            LOG.trace("Checking ClassLoader for {}", new Object[]{path});
            String string = classLoaderPath = path.startsWith("/") ? path.substring(1, path.length()) : path;
            if (ClassLoaderUtil.getResource((String)classLoaderPath, this.getClass()) != null) {
                LOG.trace("Found");
                return this.buildResult(path, resultCode, resultsByExtension.get(ext), actionContext);
            }
        }
        catch (MalformedURLException e) {
            LOG.error("Unable to parse template path: {} skipping...", new Object[]{path});
        }
        return null;
    }

    protected Result buildResult(String path, String resultCode, ResultTypeConfig config, ActionContext invocationContext) {
        String resultClass = config.getClassName();
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        if (config.getParams() != null) {
            params.putAll(config.getParams());
        }
        params.put(config.getDefaultResultParam(), path);
        ResultConfig resultConfig = new ResultConfig.Builder(resultCode, resultClass).addParams(params).build();
        try {
            return this.objectFactory.buildResult(resultConfig, invocationContext.getContextMap());
        }
        catch (Exception e) {
            throw new XWorkException("Unable to build convention result", (Throwable)e, (Object)resultConfig);
        }
    }

    protected String string(String ... parts) {
        StringBuilder sb = new StringBuilder();
        for (String part : parts) {
            sb.append(part);
        }
        return sb.toString();
    }

    protected String determinePath(ActionConfig actionConfig, String namespace) {
        String finalPrefix = this.conventionsService.determineResultPath(actionConfig);
        if (!finalPrefix.endsWith("/")) {
            finalPrefix = finalPrefix + "/";
        }
        if (StringUtils.equals((CharSequence)namespace, (CharSequence)"/")) {
            namespace = "";
        }
        if (namespace.length() > 0) {
            if (namespace.startsWith("/")) {
                namespace = namespace.substring(1);
            }
            if (!namespace.endsWith("/")) {
                namespace = namespace + "/";
            }
        }
        return finalPrefix + namespace;
    }

    public Object handleUnknownActionMethod(Object action, String methodName) {
        return null;
    }

    public static class Resource {
        final String path;
        final String ext;

        public Resource(String path, String ext) {
            this.path = path;
            this.ext = ext;
        }
    }
}

