/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.views.tiles;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.ServletDispatcherResult;
import org.apache.struts2.tiles.StrutsTilesAnnotationProcessor;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.tiles.Definition;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.TilesException;
import org.apache.tiles.mgmt.MutableTilesContainer;
import org.apache.tiles.servlet.context.ServletUtil;

public class TilesResult
extends ServletDispatcherResult {
    private static final long serialVersionUID = -3806939435493086244L;
    private static final Logger LOG = LoggerFactory.getLogger(TilesResult.class);

    public TilesResult() {
    }

    public TilesResult(String location) {
        super(location);
    }

    public void doExecute(String location, ActionInvocation invocation) throws Exception {
        StrutsTilesAnnotationProcessor annotationProcessor = new StrutsTilesAnnotationProcessor();
        TilesDefinition tilesDefinition = null;
        Object action = invocation.getAction();
        String actionName = invocation.getInvocationContext().getName();
        if (StringUtils.isEmpty((CharSequence)location)) {
            String tileName;
            LOG.trace("location not set -> action must have one @TilesDefinition", new String[0]);
            tilesDefinition = annotationProcessor.findAnnotation(action, null);
            location = tileName = StringUtils.isNotEmpty((CharSequence)tilesDefinition.name()) ? tilesDefinition.name() : actionName;
            LOG.debug("using new location name '{}' and @TilesDefinition '{}'", new Object[]{location, tilesDefinition});
        }
        this.setLocation(location);
        this.setParse(false);
        ServletContext servletContext = ServletActionContext.getServletContext();
        TilesContainer container = ServletUtil.getContainer((ServletContext)servletContext);
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        boolean definitionValid = false;
        try {
            LOG.debug("checking if tiles definition exists '{}'", new String[]{location});
            definitionValid = container.isValidDefinition(location, new Object[]{request, response});
        }
        catch (TilesException e) {
            LOG.warn("got TilesException while checking if definiton exists, ignoring it", (Throwable)e, new String[0]);
        }
        if (!definitionValid) {
            if (tilesDefinition == null) {
                LOG.trace("tilesDefinition not found yet, searching in action", new String[0]);
                tilesDefinition = annotationProcessor.findAnnotation(action, location);
            }
            if (tilesDefinition != null) {
                Definition definition = annotationProcessor.buildTilesDefinition(location, tilesDefinition);
                if (container instanceof MutableTilesContainer) {
                    LOG.debug("registering tiles definition with name '{}'", new String[]{definition.getName()});
                    ((MutableTilesContainer)container).register(definition, new Object[]{request, response});
                } else {
                    LOG.error("cannot register tiles definition as tiles container is not mutable!", new String[0]);
                }
            } else {
                LOG.warn("could not find @TilesDefinition for action: {}", new String[]{actionName});
            }
        }
        container.render(location, new Object[]{request, response});
    }
}

