/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.synapse.commons.evaluators.EvaluatorException;
import org.apache.synapse.commons.evaluators.Parser;
import org.apache.synapse.commons.executors.PriorityExecutor;
import org.apache.synapse.commons.executors.config.PriorityExecutorFactory;
import org.apache.synapse.transport.nhttp.DefaultHttpGetProcessor;
import org.apache.synapse.transport.nhttp.HttpGetRequestProcessor;
import org.apache.synapse.transport.nhttp.NHttpConfiguration;
import org.apache.synapse.transport.nhttp.util.NhttpMetricsCollector;

public class ListenerContext {
    private Log log = LogFactory.getLog(ListenerContext.class);
    private ConfigurationContext cfgCtx;
    private TransportInDescription transportIn;
    private boolean ssl = false;
    private NhttpMetricsCollector metrics = null;
    private PriorityExecutor executor = null;
    private Parser parser = null;
    private boolean restDispatching = true;
    private HttpGetRequestProcessor httpGetRequestProcessor = null;
    private int port = 8280;
    private String host = "localhost";
    private String bindAddress = null;
    private HttpParams params = null;

    public ListenerContext(ConfigurationContext cfgCtx, TransportInDescription transportIn, boolean ssl) {
        this.cfgCtx = cfgCtx;
        this.transportIn = transportIn;
        this.ssl = ssl;
    }

    public void build() throws AxisFault {
        Parameter param = this.transportIn.getParameter("port");
        if (param != null) {
            this.port = Integer.parseInt((String)param.getValue());
        }
        int portOffset = 0;
        try {
            portOffset = Integer.parseInt(System.getProperty("portOffset", "0"));
        }
        catch (NumberFormatException e) {
            this.handleException("portOffset System property should be a valid Integer", e);
        }
        this.port += portOffset;
        param = this.transportIn.getParameter("bind-address");
        if (param != null) {
            this.bindAddress = ((String)param.getValue()).trim();
        }
        if ((param = this.transportIn.getParameter("hostname")) != null) {
            this.host = ((String)param.getValue()).trim();
        } else {
            try {
                this.host = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                this.log.warn((Object)"Unable to lookup local host name, using 'localhost'");
            }
        }
        this.metrics = new NhttpMetricsCollector(true, this.ssl);
        param = this.transportIn.getParameter("priorityConfigFile");
        if (param != null && param.getValue() != null) {
            this.createPriorityConfiguration(param.getValue().toString());
        }
        if ((param = this.transportIn.getParameter("disableRestServiceDispatching")) != null && param.getValue() != null && param.getValue().equals("true")) {
            this.restDispatching = false;
        }
        if ((param = this.transportIn.getParameter("httpGetProcessor")) != null && param.getValue() != null) {
            this.httpGetRequestProcessor = this.createHttpGetProcessor(param.getValue().toString());
            if (this.httpGetRequestProcessor == null) {
                this.handleException("Cannot create HttpGetRequestProcessor");
            }
        } else {
            this.httpGetRequestProcessor = new DefaultHttpGetProcessor();
        }
        this.params = this.getListenerParameters();
    }

    private void createPriorityConfiguration(String fileName) throws AxisFault {
        OMElement definitions = null;
        try {
            FileInputStream fis = new FileInputStream(fileName);
            definitions = new StAXOMBuilder((InputStream)fis).getDocumentElement();
            definitions.build();
        }
        catch (FileNotFoundException e) {
            this.handleException("Priority configuration file cannot be found : " + fileName, e);
        }
        catch (XMLStreamException e) {
            this.handleException("Error parsing priority configuration xml file " + fileName, e);
        }
        assert (definitions != null);
        OMElement executorElem = definitions.getFirstChildWithName(new QName("priorityExecutor"));
        if (executorElem == null) {
            this.handleException("priorityExecutor configuration is mandatory for priority based routing");
        }
        this.executor = PriorityExecutorFactory.createExecutor(null, (OMElement)executorElem, (boolean)false, (Properties)new Properties());
        OMElement conditionsElem = definitions.getFirstChildWithName(new QName("conditions"));
        if (conditionsElem == null) {
            this.handleException("Conditions configuration is mandatory for priority based routing");
        }
        this.executor.init();
        assert (conditionsElem != null);
        OMAttribute defPriorityAttr = conditionsElem.getAttribute(new QName("defaultPriority"));
        this.parser = defPriorityAttr != null ? new Parser(Integer.parseInt(defPriorityAttr.getAttributeValue())) : new Parser();
        try {
            this.parser.init(conditionsElem);
        }
        catch (EvaluatorException e) {
            this.handleException("Invalid conditions configuration for priority based mediation", (Exception)((Object)e));
        }
        this.log.info((Object)("Created a priority based executor from the configuration: " + fileName));
    }

    private HttpGetRequestProcessor createHttpGetProcessor(String str) throws AxisFault {
        Object obj = null;
        try {
            obj = Class.forName(str).newInstance();
        }
        catch (ClassNotFoundException e) {
            this.handleException("Error creating WSDL processor", e);
        }
        catch (InstantiationException e) {
            this.handleException("Error creating WSDL processor", e);
        }
        catch (IllegalAccessException e) {
            this.handleException("Error creating WSDL processor", e);
        }
        if (obj instanceof HttpGetRequestProcessor) {
            return obj;
        }
        this.handleException("Error creating WSDL processor. The HttpProcessor should be of type org.apache.synapse.transport.nhttp.HttpGetRequestProcessor");
        return null;
    }

    private HttpParams getListenerParameters() {
        BasicHttpParams params = new BasicHttpParams();
        NHttpConfiguration cfg = NHttpConfiguration.getInstance();
        params.setIntParameter("http.socket.timeout", cfg.getProperty("http.socket.timeout.receiver", 60000)).setIntParameter("http.socket.buffer-size", cfg.getProperty("http.socket.buffer-size", 8192)).setBooleanParameter("http.connection.stalecheck", cfg.getProperty("http.connection.stalecheck", 0) == 1).setBooleanParameter("http.tcp.nodelay", cfg.getProperty("http.tcp.nodelay", 1) == 1).setParameter("http.origin-server", (Object)"Synapse-HttpComponents-NIO");
        if (cfg.getBooleanValue("http.nio.interest-ops-queueing", false)) {
            params.setBooleanParameter("http.nio.interest-ops-queueing", true);
        }
        return params;
    }

    public ConfigurationContext getCfgCtx() {
        return this.cfgCtx;
    }

    public TransportInDescription getTransportIn() {
        return this.transportIn;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public NhttpMetricsCollector getMetrics() {
        return this.metrics;
    }

    public PriorityExecutor getExecutor() {
        return this.executor;
    }

    public Parser getParser() {
        return this.parser;
    }

    public boolean isRestDispatching() {
        return this.restDispatching;
    }

    public HttpGetRequestProcessor getHttpGetRequestProcessor() {
        return this.httpGetRequestProcessor;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public HttpParams getParams() {
        return this.params;
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        this.log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }

    private void handleException(String msg) throws AxisFault {
        this.log.error((Object)msg);
        throw new AxisFault(msg);
    }
}

