/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp.debug;

import java.util.ArrayList;
import java.util.List;
import org.apache.synapse.transport.nhttp.NHttpConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NhttpConnectionDebugConfig {
    private static final String KEY_VALUE_SEPARATOR_PROPERTY = "nhttp.debug.key.value.separator";
    private static final String FIELD_SEPARATOR_PROPERTY = "nhttp.debug.field.separator";
    private static final String STATEMENT_SEPARATOR_PROPERTY = "nhttp.debug.statement.separator";
    private static final String HEADER_INFO_PROPERTY = "nhttp.debug.headers";
    private static final String HEADER_INFO_ALL = "all";
    private static final String HEADER_INFO_NONE = "none";
    private static final String DEFAULT_KEY_VALUE_SEPARATOR = "=";
    private static final String DEFAULT_FIELD_SEPARATOR = ", ";
    private static final String DEFAULT_STATEMENT_SEPARATOR = "\n";
    private String keyValueSeparator = NHttpConfiguration.getInstance().getStringValue("nhttp.debug.key.value.separator", "=");
    private String fieldSeparator = NHttpConfiguration.getInstance().getStringValue("nhttp.debug.field.separator", ", ");
    private String statementSeparator = NHttpConfiguration.getInstance().getStringValue("nhttp.debug.statement.separator", "\n");
    private List<String> headers;
    private boolean noHeaders = false;
    private boolean allHeaders = true;
    private static NhttpConnectionDebugConfig _instance;

    private NhttpConnectionDebugConfig() {
        String headerSet = NHttpConfiguration.getInstance().getStringValue(HEADER_INFO_PROPERTY, HEADER_INFO_ALL);
        if (HEADER_INFO_NONE.equals(headerSet)) {
            this.noHeaders = true;
        } else if (HEADER_INFO_ALL.equals(headerSet)) {
            this.allHeaders = true;
        } else {
            String[] headerNames = headerSet.split(",");
            this.headers = new ArrayList<String>();
            for (String headerName : headerNames) {
                this.headers.add(headerName.trim());
            }
        }
    }

    public static NhttpConnectionDebugConfig getInstance() {
        if (_instance == null) {
            _instance = new NhttpConnectionDebugConfig();
        }
        return _instance;
    }

    public String getKeyValueSeparator() {
        return this.keyValueSeparator;
    }

    public String getFieldSeparator() {
        return this.fieldSeparator;
    }

    public String getStatementSeparator() {
        return this.statementSeparator;
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public boolean isNoHeaders() {
        return this.noHeaders;
    }

    public boolean isAllHeaders() {
        return this.allHeaders;
    }
}

