/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.batch.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.tika.batch.BatchNoRestartError;
import org.apache.tika.batch.FileResource;
import org.apache.tika.batch.FileResourceConsumer;
import org.apache.tika.batch.OutputStreamFactory;

public abstract class AbstractFSConsumer
extends FileResourceConsumer {
    public AbstractFSConsumer(ArrayBlockingQueue<FileResource> fileQueue) {
        super(fileQueue);
    }

    protected OutputStream getOutputStream(OutputStreamFactory fsOSFactory, FileResource fileResource) {
        OutputStream os = null;
        try {
            os = fsOSFactory.getOutputStream(fileResource.getMetadata());
        }
        catch (IOException e) {
            logger.error("{}", (Object)this.getXMLifiedLogMsg(IO_OS, fileResource.getResourceId(), e, new String[0]));
            throw new BatchNoRestartError("IOException trying to open output stream for " + fileResource.getResourceId() + " :: " + e.getMessage());
        }
        return os;
    }

    protected InputStream getInputStream(FileResource fileResource) {
        InputStream is = null;
        try {
            is = fileResource.openInputStream();
        }
        catch (IOException e) {
            logger.warn("{}", (Object)this.getXMLifiedLogMsg(IO_IS, fileResource.getResourceId(), e, new String[0]));
            this.flushAndClose(is);
        }
        return is;
    }
}

