/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import org.apache.poi.hpsf.ClassID;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.Ole10Native;
import org.apache.poi.poifs.filesystem.Ole10NativeException;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.StringUtil;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.Detector;
import org.apache.tika.detect.zip.DefaultZipContainerDetector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.BoundedInputStream;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Office;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.PasswordProvider;
import org.apache.tika.parser.microsoft.OfficeParser;
import org.apache.tika.parser.microsoft.OfficeParserConfig;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.tika.utils.StringUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

abstract class AbstractPOIFSExtractor {
    private static final String OCX_NAME = "\u0003OCXNAME";
    protected final Metadata parentMetadata;
    protected final OfficeParserConfig officeParserConfig;
    protected final ParseContext context;
    private final EmbeddedDocumentUtil embeddedDocumentUtil;
    private PasswordProvider passwordProvider;

    protected AbstractPOIFSExtractor(ParseContext context) {
        this(context, null);
    }

    protected AbstractPOIFSExtractor(ParseContext context, Metadata parentMetadata) {
        this.embeddedDocumentUtil = new EmbeddedDocumentUtil(context);
        this.passwordProvider = (PasswordProvider)context.get(PasswordProvider.class);
        this.officeParserConfig = (OfficeParserConfig)context.get(OfficeParserConfig.class, (Object)new OfficeParserConfig());
        this.parentMetadata = parentMetadata;
        this.context = context;
    }

    protected TikaConfig getTikaConfig() {
        return this.embeddedDocumentUtil.getTikaConfig();
    }

    protected Detector getDetector() {
        return this.embeddedDocumentUtil.getDetector();
    }

    protected String getPassword() {
        if (this.passwordProvider != null) {
            return this.passwordProvider.getPassword(this.parentMetadata);
        }
        return null;
    }

    protected void handleEmbeddedResource(TikaInputStream resource, String filename, String relationshipID, String mediaType, XHTMLContentHandler xhtml, boolean outputHtml) throws IOException, SAXException, TikaException {
        this.handleEmbeddedResource(resource, filename, relationshipID, null, mediaType, xhtml, outputHtml);
    }

    protected void handleEmbeddedResource(TikaInputStream resource, String filename, String relationshipID, ClassID storageClassID, String mediaType, XHTMLContentHandler xhtml, boolean outputHtml) throws IOException, SAXException, TikaException {
        this.handleEmbeddedResource(resource, new Metadata(), filename, relationshipID, storageClassID, mediaType, xhtml, outputHtml);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleEmbeddedResource(TikaInputStream resource, Metadata embeddedMetadata, String filename, String relationshipID, ClassID storageClassID, String mediaType, XHTMLContentHandler xhtml, boolean outputHtml) throws IOException, SAXException, TikaException {
        try {
            if (filename != null) {
                embeddedMetadata.set("resourceName", filename);
            }
            if (relationshipID != null) {
                embeddedMetadata.set("embeddedRelationshipId", relationshipID);
            }
            if (storageClassID != null) {
                embeddedMetadata.set("embeddedStorageClassId", storageClassID.toString());
            }
            if (mediaType != null) {
                embeddedMetadata.set("Content-Type", mediaType);
            }
            if (this.embeddedDocumentUtil.shouldParseEmbedded(embeddedMetadata)) {
                this.embeddedDocumentUtil.parseEmbedded((InputStream)resource, (ContentHandler)xhtml, embeddedMetadata, outputHtml);
            }
        }
        finally {
            resource.close();
        }
    }

    protected void handleEmbeddedOfficeDoc(DirectoryEntry dir, XHTMLContentHandler xhtml, boolean outputHtml) throws IOException, SAXException, TikaException {
        this.handleEmbeddedOfficeDoc(dir, null, xhtml, outputHtml);
    }

    protected void handleEmbeddedOfficeDoc(DirectoryEntry dir, String resourceName, XHTMLContentHandler xhtml, boolean outputHtml) throws IOException, SAXException, TikaException {
        Entry ooxml;
        Object object = dir.hasEntry("Package") ? dir.getEntry("Package") : (ooxml = dir.hasEntry("package") ? dir.getEntry("package") : null);
        if (ooxml != null) {
            Metadata metadata = new Metadata();
            metadata.set("Content-Length", Integer.toString(((DocumentEntry)ooxml).getSize()));
            TikaInputStream stream = TikaInputStream.get((InputStream)new DocumentInputStream((DocumentEntry)ooxml));
            try {
                DefaultZipContainerDetector detector = new DefaultZipContainerDetector();
                MediaType type = null;
                try {
                    type = detector.detect((InputStream)stream, metadata);
                }
                catch (SecurityException e) {
                    throw e;
                }
                catch (Exception e) {
                    EmbeddedDocumentUtil.recordEmbeddedStreamException((Throwable)e, (Metadata)this.parentMetadata);
                    if (stream != null) {
                        stream.close();
                    }
                    return;
                }
                this.handleEmbeddedResource(stream, metadata, null, dir.getName(), dir.getStorageClsid(), type.toString(), xhtml, outputHtml);
                return;
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable type) {
                        Throwable detector;
                        detector.addSuppressed(type);
                    }
                }
            }
        }
        Metadata metadata = new Metadata();
        metadata.set("embeddedRelationshipId", dir.getName());
        if (dir.getStorageClsid() != null) {
            metadata.set("embeddedStorageClassId", dir.getStorageClsid().toString());
        }
        OfficeParser.POIFSDocumentType type = OfficeParser.POIFSDocumentType.detectType(dir);
        String rName = resourceName == null ? dir.getName() : resourceName;
        this.extractOCXName(dir, metadata);
        if (type == OfficeParser.POIFSDocumentType.OLE10_NATIVE) {
            this.handleOLENative(dir, type, rName, metadata, xhtml, outputHtml);
        } else if (type == OfficeParser.POIFSDocumentType.COMP_OBJ) {
            this.handleCompObj(dir, type, rName, metadata, xhtml, outputHtml);
        } else if (type == OfficeParser.POIFSDocumentType.OUTLOOK) {
            metadata.set("Content-Type", type.getType().toString());
            String name = AbstractPOIFSExtractor.tryToGetMsgTitle(dir, rName);
            if (!StringUtils.isBlank((String)name)) {
                if (StringUtils.isBlank((String)type.getExtension())) {
                    metadata.set("resourceName", name);
                } else {
                    metadata.set("resourceName", name + "." + type.getExtension());
                }
            }
            this.parseEmbedded(dir, xhtml, metadata, outputHtml);
        } else {
            metadata.set("Content-Type", type.getType().toString());
            if (!StringUtils.isBlank((String)rName)) {
                if (StringUtils.isBlank((String)type.getExtension())) {
                    metadata.set("resourceName", rName);
                } else {
                    metadata.set("resourceName", rName + "." + type.getExtension());
                }
            }
            this.parseEmbedded(dir, xhtml, metadata, outputHtml);
        }
    }

    private void extractOCXName(DirectoryEntry dir, Metadata metadata) {
        if (!dir.hasEntry(OCX_NAME)) {
            return;
        }
        try {
            Entry e = dir.getEntry(OCX_NAME);
            if (!e.isDocumentEntry()) {
                return;
            }
            UnsynchronizedByteArrayOutputStream bos = UnsynchronizedByteArrayOutputStream.builder().get();
            try (DocumentInputStream dis = new DocumentInputStream((DocumentEntry)e);){
                IOUtils.copy((InputStream)dis, (OutputStream)bos);
            }
            byte[] bytes = bos.toByteArray();
            int charCount = bytes.length - 4;
            if (charCount < 0) {
                return;
            }
            if (charCount % 2 != 0) {
                return;
            }
            String ocxName = StringUtil.getFromUnicodeLE0Terminated((byte[])bytes, (int)0, (int)(charCount /= 2));
            metadata.set(Office.OCX_NAME, ocxName);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCompObj(DirectoryEntry dir, OfficeParser.POIFSDocumentType type, String rName, Metadata metadata, XHTMLContentHandler xhtml, boolean outputHtml) throws IOException, SAXException {
        DocumentEntry contentsEntry;
        String contentsEntryName = this.getContentsEntryName(dir);
        if (contentsEntryName == null) {
            return;
        }
        try {
            contentsEntry = (DocumentEntry)dir.getEntry(contentsEntryName);
        }
        catch (FileNotFoundException fnfe) {
            EmbeddedDocumentUtil.recordEmbeddedStreamException((Throwable)fnfe, (Metadata)this.parentMetadata);
            return;
        }
        int length = contentsEntry.getSize();
        DocumentInputStream inp = null;
        try {
            inp = new DocumentInputStream(contentsEntry);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            EmbeddedDocumentUtil.recordEmbeddedStreamException((Throwable)e, (Metadata)this.parentMetadata);
            return;
        }
        try (TikaInputStream tis = TikaInputStream.get((InputStream)inp);){
            MediaType mediaType = this.getDetector().detect((InputStream)tis, metadata);
            String extension = type.getExtension();
            try {
                MimeType mimeType = this.embeddedDocumentUtil.getMimeTypes().forName(mediaType.toString());
                extension = mimeType.getExtension();
            }
            catch (MimeTypeException mimeTypeException) {
                // empty catch block
            }
            metadata.set("Content-Type", mediaType.getType());
            metadata.set("resourceName", rName + extension);
            metadata.set("Content-Length", Integer.toString(length));
            this.parseEmbedded(dir, tis, xhtml, metadata, outputHtml);
        }
        finally {
            inp.close();
        }
    }

    private String getContentsEntryName(DirectoryEntry dir) {
        if (dir.hasEntry("CONTENTS")) {
            return "CONTENTS";
        }
        if (dir.hasEntry("Contents")) {
            return "Contents";
        }
        for (String n : dir.getEntryNames()) {
            if (!"contents".equalsIgnoreCase(n)) continue;
            return n;
        }
        return null;
    }

    private void handleOLENative(DirectoryEntry dir, OfficeParser.POIFSDocumentType type, String rName, Metadata metadata, XHTMLContentHandler xhtml, boolean outputHtml) throws IOException, SAXException {
        byte[] data = null;
        try {
            Ole10Native ole = Ole10Native.createFromEmbeddedOleObject((DirectoryNode)((DirectoryNode)dir));
            if (ole.getLabel() != null) {
                metadata.set("resourceName", rName + "/" + ole.getLabel());
            } else {
                metadata.add("resourceName", rName);
            }
            if (ole.getCommand() != null) {
                metadata.add(TikaCoreProperties.ORIGINAL_RESOURCE_NAME, ole.getCommand());
            }
            if (ole.getFileName() != null) {
                metadata.add(TikaCoreProperties.ORIGINAL_RESOURCE_NAME, ole.getFileName());
            }
            data = ole.getDataBuffer();
            metadata.set("Content-Length", Integer.toString(data.length));
        }
        catch (Ole10NativeException ole) {
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            EmbeddedDocumentUtil.recordEmbeddedStreamException((Throwable)e, (Metadata)this.parentMetadata);
            return;
        }
        try (TikaInputStream tis = TikaInputStream.get(data);){
            this.parseEmbedded(dir, tis, xhtml, metadata, outputHtml);
        }
    }

    private void parseEmbedded(DirectoryEntry dir, TikaInputStream tis, XHTMLContentHandler xhtml, Metadata metadata, boolean outputHtml) throws IOException, SAXException {
        if (!this.embeddedDocumentUtil.shouldParseEmbedded(metadata)) {
            return;
        }
        if (dir.getStorageClsid() != null) {
            metadata.set("embeddedStorageClassId", dir.getStorageClsid().toString());
        }
        this.embeddedDocumentUtil.parseEmbedded((InputStream)tis, (ContentHandler)xhtml, metadata, outputHtml);
    }

    private void parseEmbedded(DirectoryEntry dir, XHTMLContentHandler xhtml, Metadata metadata, boolean outputHtml) throws IOException, SAXException {
        if (!this.embeddedDocumentUtil.shouldParseEmbedded(metadata)) {
            return;
        }
        try (TikaInputStream tis = TikaInputStream.get((byte[])new byte[0]);){
            tis.setOpenContainer((Object)dir);
            if (dir.getStorageClsid() != null) {
                metadata.set("embeddedStorageClassId", dir.getStorageClsid().toString());
            }
            this.embeddedDocumentUtil.parseEmbedded((InputStream)tis, (ContentHandler)xhtml, metadata, outputHtml);
        }
    }

    public static String tryToGetMsgTitle(DirectoryEntry node, String defaultVal) {
        for (String entryName : new String[]{"__substg1.0_0037001F", "__substg1.0_0E1D001F", "__substg1.0_0070001F"}) {
            String string;
            Entry entry = node.getEntry(entryName);
            if (!(entry instanceof DocumentEntry)) continue;
            BoundedInputStream is = new BoundedInputStream(1000L, (InputStream)new DocumentInputStream((DocumentEntry)entry));
            try {
                string = org.apache.commons.io.IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_16LE);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            is.close();
            return string;
        }
        return defaultVal;
    }
}

