/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.mvel;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.tiles.context.TilesRequestContextHolder;
import org.apache.tiles.mvel.ReadOnlyVariableResolverFactory;
import org.apache.tiles.request.ApplicationContext;
import org.apache.tiles.request.Request;
import org.apache.tiles.request.reflect.CannotAccessMethodException;
import org.apache.tiles.util.CombinedBeanInfo;
import org.mvel2.integration.VariableResolver;

public class TilesContextVariableResolverFactory
extends ReadOnlyVariableResolverFactory {
    private CombinedBeanInfo requestBeanInfo = new CombinedBeanInfo(new Class[]{Request.class, ApplicationContext.class});

    public TilesContextVariableResolverFactory(TilesRequestContextHolder requestHolder) {
        super(requestHolder);
    }

    public boolean isTarget(String name) {
        return this.requestBeanInfo.getMappedDescriptors(Request.class).containsKey(name) || this.requestBeanInfo.getMappedDescriptors(ApplicationContext.class).containsKey(name);
    }

    @Override
    public VariableResolver createVariableResolver(String name) {
        ReadOnlyVariableResolverFactory.ReadOnlyVariableResolver resolver = null;
        PropertyDescriptor descriptor = (PropertyDescriptor)this.requestBeanInfo.getMappedDescriptors(Request.class).get(name);
        if (descriptor != null) {
            resolver = new RequestVariableResolver(name, descriptor);
        } else {
            descriptor = (PropertyDescriptor)this.requestBeanInfo.getMappedDescriptors(ApplicationContext.class).get(name);
            if (descriptor != null) {
                resolver = new ApplicationVariableResolver(name, descriptor);
            }
        }
        return resolver;
    }

    private class ApplicationVariableResolver
    extends ReadOnlyVariableResolverFactory.ReadOnlyVariableResolver {
        private PropertyDescriptor descriptor;

        public ApplicationVariableResolver(String name, PropertyDescriptor descriptor) {
            super(name);
            this.descriptor = descriptor;
        }

        public Class getType() {
            return this.descriptor.getPropertyType();
        }

        public Object getValue() {
            Method method = this.descriptor.getReadMethod();
            try {
                return method.invoke((Object)TilesContextVariableResolverFactory.this.requestHolder.getTilesRequestContext().getApplicationContext(), new Object[0]);
            }
            catch (IllegalArgumentException e) {
                throw new CannotAccessMethodException("Arguments are wrong for property '" + this.descriptor.getName() + "'", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new CannotAccessMethodException("Cannot access getter method for property '" + this.descriptor.getName() + "'", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new CannotAccessMethodException("The getter method for property '" + this.descriptor.getName() + "' threw an exception", (Throwable)e);
            }
        }
    }

    private class RequestVariableResolver
    extends ReadOnlyVariableResolverFactory.ReadOnlyVariableResolver {
        private PropertyDescriptor descriptor;

        public RequestVariableResolver(String name, PropertyDescriptor descriptor) {
            super(name);
            this.descriptor = descriptor;
        }

        public Class getType() {
            return this.descriptor.getPropertyType();
        }

        public Object getValue() {
            Method method = this.descriptor.getReadMethod();
            try {
                return method.invoke((Object)TilesContextVariableResolverFactory.this.requestHolder.getTilesRequestContext(), new Object[0]);
            }
            catch (IllegalArgumentException e) {
                throw new CannotAccessMethodException("Arguments are wrong for property '" + this.descriptor.getName() + "'", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new CannotAccessMethodException("Cannot access getter method for property '" + this.descriptor.getName() + "'", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new CannotAccessMethodException("The getter method for property '" + this.descriptor.getName() + "' threw an exception", (Throwable)e);
            }
        }
    }
}

