/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.request.locale;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import org.apache.tiles.request.locale.PostfixedApplicationResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLApplicationResource
extends PostfixedApplicationResource {
    private static final Logger LOG = LoggerFactory.getLogger(URLApplicationResource.class);
    private URL url;
    private File file;

    public URLApplicationResource(String localePath, URL url) {
        super(localePath);
        this.url = url;
        if ("file".equals(url.getProtocol())) {
            this.file = URLApplicationResource.getFile(url);
        }
    }

    public URLApplicationResource(String path, Locale locale, URL url) {
        super(path, locale);
        this.url = url;
        if ("file".equals(url.getProtocol())) {
            this.file = URLApplicationResource.getFile(url);
        }
    }

    private static File getFile(URL url) {
        try {
            return new File(new URI(url.toExternalForm()).getSchemeSpecificPart());
        }
        catch (URISyntaxException e) {
            LOG.debug("Cannot translate URL to file name, expect a performance impact", (Throwable)e);
            return null;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.file != null) {
            return new FileInputStream(this.file);
        }
        return this.url.openConnection().getInputStream();
    }

    @Override
    public long getLastModified() throws IOException {
        if (this.file != null) {
            return this.file.lastModified();
        }
        URLConnection connection = this.url.openConnection();
        if (connection instanceof JarURLConnection) {
            return ((JarURLConnection)connection).getJarEntry().getTime();
        }
        long result = connection.getLastModified();
        return result;
    }

    public String toString() {
        return "Resource " + this.getLocalePath() + " at " + this.url.toString();
    }

    protected URL getURL() {
        return this.url;
    }

    protected File getFile() {
        return this.file;
    }
}

