/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.maven.plugin.tomcat7.run;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.tomcat.maven.plugin.tomcat7.AbstractTomcat7Mojo;
import org.apache.tomcat.maven.plugin.tomcat7.run.ExtraDependency;
import org.apache.tomcat.maven.plugin.tomcat7.run.ExtraResource;
import org.apache.tomcat.maven.plugin.tomcat7.run.WarRunDependency;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.SelectorUtils;

public abstract class AbstractExecWarMojo
extends AbstractTomcat7Mojo {
    @Parameter(defaultValue="${project.artifact}", required=true, readonly=true)
    protected Artifact projectArtifact;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${plugin.artifacts}", required=true)
    protected List<Artifact> pluginArtifacts;
    @Parameter(defaultValue="${project.build.directory}")
    protected File buildDirectory;
    @Parameter(defaultValue="${project.build.directory}/tomcat7-maven-plugin-exec")
    private File pluginWorkDirectory;
    @Parameter(property="maven.tomcat.exec.war.tomcatConf", defaultValue="src/main/tomcatconf")
    protected File tomcatConfigurationFilesDirectory;
    @Parameter(defaultValue="src/main/tomcatconf/server.xml", property="maven.tomcat.exec.war.serverXml")
    protected File serverXml;
    @Parameter(property="tomcat.jar.finalName", defaultValue="${project.artifactId}-${project.version}-war-exec.jar", required=true)
    protected String finalName;
    @Parameter(property="maven.tomcat.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="maven.tomcat.path", defaultValue="${project.artifactId}", required=true)
    protected String path;
    @Parameter
    protected List<WarRunDependency> warRunDependencies;
    @Component
    protected ArtifactResolver artifactResolver;
    @Component
    protected ArtifactFactory artifactFactory;
    @Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    protected ArtifactRepository local;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", required=true, readonly=true)
    protected List<ArtifactRepository> remoteRepos;
    @Component
    protected MavenProjectHelper projectHelper;
    @Parameter(property="maven.tomcat.exec.war.attachArtifact", defaultValue="true", required=true)
    protected boolean attachArtifact;
    @Parameter(property="maven.tomcat.exec.war.attachArtifactClassifier", defaultValue="exec-war", required=true)
    protected String attachArtifactClassifier;
    @Parameter(property="maven.tomcat.exec.war.attachArtifactType", defaultValue="jar", required=true)
    protected String attachArtifactClassifierType;
    @Parameter(property="maven.tomcat.exec.war.enableNaming", defaultValue="false", required=true)
    protected boolean enableNaming;
    @Parameter(property="maven.tomcat.exec.war.enableRemoteIpValve", defaultValue="true", required=true)
    protected String enableRemoteIpValve;
    @Parameter(property="maven.tomcat.exec.war.accessLogValveFormat", defaultValue="%h %l %u %t %r %s %b %I %D", required=true)
    protected String accessLogValveFormat;
    @Parameter
    protected List<ExtraDependency> extraDependencies;
    @Parameter
    protected List<ExtraResource> extraResources;
    @Parameter(property="maven.tomcat.exec.war.mainClass", defaultValue="org.apache.tomcat.maven.runner.Tomcat7RunnerCli", required=true)
    protected String mainClass;
    @Parameter(property="maven.tomcat.exec.war.connectorHttpProtocol", defaultValue="HTTP/1.1", required=true)
    protected String connectorHttpProtocol;
    @Parameter(property="maven.tomcat.exec.war.httpPort")
    protected String httpPort;
    @Parameter
    protected String[] excludes;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"skip execution");
            return;
        }
        File warExecFile = new File(this.buildDirectory, this.finalName);
        if (warExecFile.exists()) {
            warExecFile.delete();
        }
        File execWarJar = new File(this.buildDirectory, this.finalName);
        FileOutputStream execWarJarOutputStream = null;
        ArchiveOutputStream os = null;
        File tmpPropertiesFile = null;
        File tmpManifestFile = null;
        FileOutputStream tmpPropertiesFileOutputStream = null;
        PrintWriter tmpManifestWriter = null;
        try {
            tmpPropertiesFile = new File(this.buildDirectory, "war-exec.properties");
            if (tmpPropertiesFile.exists()) {
                tmpPropertiesFile.delete();
            }
            tmpPropertiesFile.getParentFile().mkdirs();
            tmpManifestFile = new File(this.buildDirectory, "war-exec.manifest");
            if (tmpManifestFile.exists()) {
                tmpManifestFile.delete();
            }
            tmpPropertiesFileOutputStream = new FileOutputStream(tmpPropertiesFile);
            execWarJar.getParentFile().mkdirs();
            execWarJar.createNewFile();
            execWarJarOutputStream = new FileOutputStream(execWarJar);
            tmpManifestWriter = new PrintWriter(tmpManifestFile);
            Properties properties = new Properties();
            properties.put("generationTimestamp", Long.toString(System.currentTimeMillis()));
            properties.put("enableNaming", Boolean.toString(this.enableNaming));
            properties.put("enableRemoteIpValve", this.enableRemoteIpValve);
            properties.put("accessLogValveFormat", this.accessLogValveFormat);
            properties.put("connectorhttpProtocol", this.connectorHttpProtocol);
            if (this.httpPort != null) {
                properties.put("httpPort", this.httpPort);
            }
            os = new ArchiveStreamFactory().createArchiveOutputStream("jar", (OutputStream)execWarJarOutputStream);
            if ("war".equals(this.project.getPackaging())) {
                os.putArchiveEntry((ArchiveEntry)new JarArchiveEntry(StringUtils.removeStart((String)this.path, (String)"/") + ".war"));
                IOUtils.copy((InputStream)new FileInputStream(this.projectArtifact.getFile()), (OutputStream)os);
                os.closeArchiveEntry();
                properties.put("wars", StringUtils.removeStart((String)this.path, (String)"/") + ".war|" + this.path);
            } else if (this.warRunDependencies != null && !this.warRunDependencies.isEmpty()) {
                for (WarRunDependency warRunDependency : this.warRunDependencies) {
                    String contextPath;
                    if (warRunDependency.dependency == null) continue;
                    Dependency dependency = warRunDependency.dependency;
                    String version = dependency.getVersion();
                    if (StringUtils.isEmpty((String)version)) {
                        version = this.findArtifactVersion(dependency);
                    }
                    if (StringUtils.isEmpty((String)version)) {
                        throw new MojoExecutionException("Dependency '" + dependency.getGroupId() + "':'" + dependency.getArtifactId() + "' does not have version specified");
                    }
                    Artifact artifact = this.artifactFactory.createArtifactWithClassifier(dependency.getGroupId(), dependency.getArtifactId(), version, dependency.getType(), dependency.getClassifier());
                    this.artifactResolver.resolve(artifact, this.remoteRepos, this.local);
                    File warFileToBundle = new File(this.resolvePluginWorkDir(), artifact.getFile().getName());
                    FileUtils.copyFile((File)artifact.getFile(), (File)warFileToBundle);
                    if (warRunDependency.contextXml != null) {
                        warFileToBundle = this.addContextXmlToWar(warRunDependency.contextXml, warFileToBundle);
                    }
                    String warFileName = artifact.getFile().getName();
                    os.putArchiveEntry((ArchiveEntry)new JarArchiveEntry(warFileName));
                    IOUtils.copy((InputStream)new FileInputStream(warFileToBundle), (OutputStream)os);
                    os.closeArchiveEntry();
                    String propertyWarValue = properties.getProperty("wars");
                    String string = contextPath = StringUtils.isEmpty((String)warRunDependency.contextPath) ? "/" : warRunDependency.contextPath;
                    if (propertyWarValue != null) {
                        properties.put("wars", propertyWarValue + ";" + warFileName + "|" + contextPath);
                        continue;
                    }
                    properties.put("wars", warFileName + "|" + contextPath);
                }
            }
            if (this.serverXml != null && this.serverXml.exists()) {
                os.putArchiveEntry((ArchiveEntry)new JarArchiveEntry("conf/server.xml"));
                IOUtils.copy((InputStream)new FileInputStream(this.serverXml), (OutputStream)os);
                os.closeArchiveEntry();
                properties.put("useServerXml", Boolean.TRUE.toString());
            } else {
                properties.put("useServerXml", Boolean.FALSE.toString());
            }
            os.putArchiveEntry((ArchiveEntry)new JarArchiveEntry("conf/web.xml"));
            IOUtils.copy((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/conf/web.xml"), (OutputStream)os);
            os.closeArchiveEntry();
            properties.store(tmpPropertiesFileOutputStream, "created by Apache Tomcat Maven plugin");
            tmpPropertiesFileOutputStream.flush();
            tmpPropertiesFileOutputStream.close();
            os.putArchiveEntry((ArchiveEntry)new JarArchiveEntry("tomcat.standalone.properties"));
            IOUtils.copy((InputStream)new FileInputStream(tmpPropertiesFile), (OutputStream)os);
            os.closeArchiveEntry();
            for (Artifact pluginArtifact : this.pluginArtifacts) {
                if (!StringUtils.equals((String)"org.apache.tomcat", (String)pluginArtifact.getGroupId()) && !StringUtils.equals((String)"org.apache.tomcat.embed", (String)pluginArtifact.getGroupId()) && !StringUtils.equals((String)"org.eclipse.jdt.core.compiler", (String)pluginArtifact.getGroupId()) && !StringUtils.equals((String)"commons-cli", (String)pluginArtifact.getArtifactId()) && !StringUtils.equals((String)"tomcat7-war-runner", (String)pluginArtifact.getArtifactId())) continue;
                JarFile jarFile = new JarFile(pluginArtifact.getFile());
                this.extractJarToArchive(jarFile, os, null);
            }
            if (this.extraDependencies != null && !this.extraDependencies.isEmpty()) {
                for (ExtraDependency dependency : this.extraDependencies) {
                    String version = dependency.getVersion();
                    if (StringUtils.isEmpty((String)version)) {
                        version = this.findArtifactVersion(dependency);
                    }
                    if (StringUtils.isEmpty((String)version)) {
                        throw new MojoExecutionException("Dependency '" + dependency.getGroupId() + "':'" + dependency.getArtifactId() + "' does not have version specified");
                    }
                    Artifact artifact = this.artifactFactory.createArtifact(dependency.getGroupId(), dependency.getArtifactId(), version, dependency.getScope(), dependency.getType());
                    this.artifactResolver.resolve(artifact, this.remoteRepos, this.local);
                    JarFile jarFile = new JarFile(artifact.getFile());
                    this.extractJarToArchive(jarFile, os, this.excludes);
                }
            }
            Manifest manifest = new Manifest();
            Manifest.Attribute mainClassAtt = new Manifest.Attribute();
            mainClassAtt.setName("Main-Class");
            mainClassAtt.setValue(this.mainClass);
            manifest.addConfiguredAttribute(mainClassAtt);
            manifest.write(tmpManifestWriter);
            tmpManifestWriter.flush();
            tmpManifestWriter.close();
            os.putArchiveEntry((ArchiveEntry)new JarArchiveEntry("META-INF/MANIFEST.MF"));
            IOUtils.copy((InputStream)new FileInputStream(tmpManifestFile), (OutputStream)os);
            os.closeArchiveEntry();
            if (this.attachArtifact) {
                this.projectHelper.attachArtifact(this.project, this.attachArtifactClassifierType, this.attachArtifactClassifier, execWarJar);
            }
            if (this.extraResources != null) {
                for (ExtraResource extraResource : this.extraResources) {
                    DirectoryScanner directoryScanner = new DirectoryScanner();
                    directoryScanner.setBasedir(extraResource.getDirectory());
                    directoryScanner.addDefaultExcludes();
                    directoryScanner.setExcludes(this.toStringArray(extraResource.getExcludes()));
                    directoryScanner.setIncludes(this.toStringArray(extraResource.getIncludes()));
                    directoryScanner.scan();
                    for (String includeFile : directoryScanner.getIncludedFiles()) {
                        this.getLog().debug((CharSequence)("include file:" + includeFile));
                        os.putArchiveEntry((ArchiveEntry)new JarArchiveEntry(includeFile));
                        IOUtils.copy((InputStream)new FileInputStream(new File(extraResource.getDirectory(), includeFile)), (OutputStream)os);
                        os.closeArchiveEntry();
                    }
                }
            }
            if (this.tomcatConfigurationFilesDirectory != null && this.tomcatConfigurationFilesDirectory.exists()) {
                String aConfigOutputDir = "conf/";
                this.copyDirectoryContentIntoArchive(this.tomcatConfigurationFilesDirectory, aConfigOutputDir, os);
            }
        }
        catch (ManifestException e) {
            try {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
                catch (IOException e2) {
                    throw new MojoExecutionException(e2.getMessage(), (Exception)e2);
                }
                catch (ArchiveException e3) {
                    throw new MojoExecutionException(e3.getMessage(), (Exception)((Object)e3));
                }
                catch (ArtifactNotFoundException e4) {
                    throw new MojoExecutionException(e4.getMessage(), (Exception)((Object)e4));
                }
                catch (ArtifactResolutionException e5) {
                    throw new MojoExecutionException(e5.getMessage(), (Exception)((Object)e5));
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(os);
                IOUtils.closeQuietly(tmpManifestWriter);
                IOUtils.closeQuietly(execWarJarOutputStream);
                IOUtils.closeQuietly(tmpPropertiesFileOutputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)os);
        IOUtils.closeQuietly((Writer)tmpManifestWriter);
        IOUtils.closeQuietly((OutputStream)execWarJarOutputStream);
        IOUtils.closeQuietly((OutputStream)tmpPropertiesFileOutputStream);
    }

    protected String findArtifactVersion(Dependency dependency) {
        for (Dependency projectDependency : this.project.getDependencies()) {
            if (!this.sameDependencyWithoutVersion(dependency, projectDependency)) continue;
            return projectDependency.getVersion();
        }
        for (Dependency projectDependency : this.project.getDependencyManagement().getDependencies()) {
            if (!this.sameDependencyWithoutVersion(dependency, projectDependency)) continue;
            return projectDependency.getVersion();
        }
        return null;
    }

    protected boolean sameDependencyWithoutVersion(Dependency that, Dependency dependency) {
        return StringUtils.equals((String)that.getGroupId(), (String)dependency.getGroupId()) && StringUtils.equals((String)that.getArtifactId(), (String)dependency.getArtifactId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyDirectoryContentIntoArchive(File sourceFolder, String destinationPath, ArchiveOutputStream archiveOutputStream) throws IOException {
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(sourceFolder);
        directoryScanner.addDefaultExcludes();
        directoryScanner.scan();
        for (String includeFileName : directoryScanner.getIncludedFiles()) {
            this.getLog().debug((CharSequence)("include configuration file : " + destinationPath + includeFileName));
            File inputFile = new File(sourceFolder, includeFileName);
            FileInputStream sourceFileInputStream = null;
            try {
                sourceFileInputStream = new FileInputStream(inputFile);
                archiveOutputStream.putArchiveEntry((ArchiveEntry)new JarArchiveEntry(destinationPath + StringUtils.replace((String)includeFileName, (String)"\\", (String)"/")));
                IOUtils.copy((InputStream)sourceFileInputStream, (OutputStream)archiveOutputStream);
                archiveOutputStream.closeArchiveEntry();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(sourceFileInputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)sourceFileInputStream);
        }
    }

    protected File resolvePluginWorkDir() throws MojoExecutionException {
        if (!this.pluginWorkDirectory.exists() && !this.pluginWorkDirectory.mkdirs()) {
            throw new MojoExecutionException("Could not create plugin work directory at " + this.pluginWorkDirectory.getAbsolutePath());
        }
        return this.pluginWorkDirectory;
    }

    protected String[] toStringArray(List list) {
        if (list == null || list.isEmpty()) {
            return new String[0];
        }
        ArrayList<String> res = new ArrayList<String>(list.size());
        Iterator ite = list.iterator();
        while (ite.hasNext()) {
            res.add((String)ite.next());
        }
        return res.toArray(new String[res.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File addContextXmlToWar(File contextXmlFile, File warFile) throws IOException, ArchiveException {
        ArchiveOutputStream os = null;
        FileOutputStream warOutputStream = null;
        File tmpWar = File.createTempFile("tomcat", "war-exec");
        tmpWar.deleteOnExit();
        try {
            warOutputStream = new FileOutputStream(tmpWar);
            os = new ArchiveStreamFactory().createArchiveOutputStream("jar", (OutputStream)warOutputStream);
            os.putArchiveEntry((ArchiveEntry)new JarArchiveEntry("META-INF/context.xml"));
            IOUtils.copy((InputStream)new FileInputStream(contextXmlFile), (OutputStream)os);
            os.closeArchiveEntry();
            JarFile jarFile = new JarFile(warFile);
            this.extractJarToArchive(jarFile, os, null);
            os.flush();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(os);
            IOUtils.closeQuietly((OutputStream)warOutputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)os);
        IOUtils.closeQuietly((OutputStream)warOutputStream);
        return tmpWar;
    }

    protected void extractJarToArchive(JarFile file, ArchiveOutputStream os, String[] excludes) throws IOException {
        Enumeration<JarEntry> entries = file.entries();
        while (entries.hasMoreElements()) {
            JarEntry j = entries.nextElement();
            if (excludes != null && excludes.length > 0) {
                for (String exclude : excludes) {
                    if (!SelectorUtils.match((String)exclude, (String)j.getName())) continue;
                }
            }
            if (StringUtils.equalsIgnoreCase((String)j.getName(), (String)"META-INF/MANIFEST.MF")) continue;
            os.putArchiveEntry((ArchiveEntry)new JarArchiveEntry(j.getName()));
            IOUtils.copy((InputStream)file.getInputStream(j), (OutputStream)os);
            os.closeArchiveEntry();
        }
        if (file != null) {
            file.close();
        }
    }
}

