/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.mbeans;

import java.io.IOException;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.AlreadyBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.util.HashMap;
import java.util.Map;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnectorServer;
import javax.management.remote.rmi.RMIJRMPServerImpl;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.rmi.ssl.SslRMIServerSocketFactory;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apache.tomcat.util.net.jsse.JSSEUtil;
import org.apache.tomcat.util.res.StringManager;

public class JmxRemoteLifecycleListener
extends SSLHostConfig
implements LifecycleListener {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(JmxRemoteLifecycleListener.class);
    protected static final StringManager sm = StringManager.getManager(JmxRemoteLifecycleListener.class);
    protected String rmiBindAddress = null;
    protected int rmiRegistryPortPlatform = -1;
    protected int rmiServerPortPlatform = -1;
    protected boolean rmiRegistrySSL = true;
    protected boolean rmiServerSSL = true;
    protected boolean authenticate = true;
    protected String passwordFile = null;
    protected String loginModuleName = null;
    protected String accessFile = null;
    protected boolean useLocalPorts = false;
    protected transient JMXConnectorServer csPlatform = null;

    public String getRmiBindAddress() {
        return this.rmiBindAddress;
    }

    public void setRmiBindAddress(String theRmiBindAddress) {
        this.rmiBindAddress = theRmiBindAddress;
    }

    public int getRmiServerPortPlatform() {
        return this.rmiServerPortPlatform;
    }

    public void setRmiServerPortPlatform(int theRmiServerPortPlatform) {
        this.rmiServerPortPlatform = theRmiServerPortPlatform;
    }

    public int getRmiRegistryPortPlatform() {
        return this.rmiRegistryPortPlatform;
    }

    public void setRmiRegistryPortPlatform(int theRmiRegistryPortPlatform) {
        this.rmiRegistryPortPlatform = theRmiRegistryPortPlatform;
    }

    public boolean getUseLocalPorts() {
        return this.useLocalPorts;
    }

    public void setUseLocalPorts(boolean useLocalPorts) {
        this.useLocalPorts = useLocalPorts;
    }

    public boolean isRmiRegistrySSL() {
        return this.rmiRegistrySSL;
    }

    public void setRmiRegistrySSL(boolean rmiRegistrySSL) {
        this.rmiRegistrySSL = rmiRegistrySSL;
    }

    public boolean isRmiServerSSL() {
        return this.rmiServerSSL;
    }

    public void setRmiServerSSL(boolean rmiServerSSL) {
        this.rmiServerSSL = rmiServerSSL;
    }

    public boolean isAuthenticate() {
        return this.authenticate;
    }

    public void setAuthenticate(boolean authenticate) {
        this.authenticate = authenticate;
    }

    public String getPasswordFile() {
        return this.passwordFile;
    }

    public void setPasswordFile(String passwordFile) {
        this.passwordFile = passwordFile;
    }

    public String getLoginModuleName() {
        return this.loginModuleName;
    }

    public void setLoginModuleName(String loginModuleName) {
        this.loginModuleName = loginModuleName;
    }

    public String getAccessFile() {
        return this.accessFile;
    }

    public void setAccessFile(String accessFile) {
        this.accessFile = accessFile;
    }

    protected void init() {
        String loginModuleNameValue;
        String accessFileValue;
        String passwordFileValue;
        String authenticateValue;
        String clientAuthValue;
        String ciphersValue;
        String protocolsValue;
        String rmiServerSSLValue;
        String rmiRegistrySSLValue = System.getProperty("com.sun.management.jmxremote.registry.ssl");
        if (rmiRegistrySSLValue != null) {
            this.setRmiRegistrySSL(Boolean.parseBoolean(rmiRegistrySSLValue));
        }
        if ((rmiServerSSLValue = System.getProperty("com.sun.management.jmxremote.ssl")) != null) {
            this.setRmiServerSSL(Boolean.parseBoolean(rmiServerSSLValue));
        }
        if ((protocolsValue = System.getProperty("com.sun.management.jmxremote.ssl.enabled.protocols")) != null) {
            this.setEnabledProtocols(protocolsValue.split(","));
        }
        if ((ciphersValue = System.getProperty("com.sun.management.jmxremote.ssl.enabled.cipher.suites")) != null) {
            this.setCiphers(ciphersValue);
        }
        if ((clientAuthValue = System.getProperty("com.sun.management.jmxremote.ssl.need.client.auth")) != null) {
            this.setCertificateVerification(clientAuthValue);
        }
        if ((authenticateValue = System.getProperty("com.sun.management.jmxremote.authenticate")) != null) {
            this.setAuthenticate(Boolean.parseBoolean(authenticateValue));
        }
        if ((passwordFileValue = System.getProperty("com.sun.management.jmxremote.password.file")) != null) {
            this.setPasswordFile(passwordFileValue);
        }
        if ((accessFileValue = System.getProperty("com.sun.management.jmxremote.access.file")) != null) {
            this.setAccessFile(accessFileValue);
        }
        if ((loginModuleNameValue = System.getProperty("com.sun.management.jmxremote.login.config")) != null) {
            this.setLoginModuleName(loginModuleNameValue);
        }
    }

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        if ("start".equals(event.getType())) {
            this.init();
            SSLContext sslContext = null;
            if (this.getCertificates().size() > 0) {
                SSLHostConfigCertificate certificate = (SSLHostConfigCertificate)this.getCertificates().iterator().next();
                JSSEUtil sslUtil = new JSSEUtil(certificate);
                try {
                    sslContext = SSLContext.getInstance(this.getSslProtocol());
                    this.setEnabledProtocols(sslUtil.getEnabledProtocols());
                    this.setEnabledCiphers(sslUtil.getEnabledCiphers());
                    sslContext.init(sslUtil.getKeyManagers(), sslUtil.getTrustManagers(), null);
                    SSLSessionContext sessionContext = sslContext.getServerSessionContext();
                    if (sessionContext != null) {
                        sslUtil.configureSessionContext(sessionContext);
                    }
                }
                catch (Exception e) {
                    log.error((Object)sm.getString("jmxRemoteLifecycleListener.invalidSSLConfiguration"), (Throwable)e);
                }
            }
            System.setProperty("java.rmi.server.randomIDs", "true");
            HashMap<String, Object> env = new HashMap<String, Object>();
            RMIClientSocketFactory registryCsf = null;
            RMIServerSocketFactory registrySsf = null;
            RMIClientSocketFactory serverCsf = null;
            RMIServerSocketFactory serverSsf = null;
            if (this.rmiRegistrySSL) {
                registryCsf = new SslRMIClientSocketFactory();
                registrySsf = this.rmiBindAddress == null ? new SslRMIServerSocketFactory(sslContext, this.getEnabledCiphers(), this.getEnabledProtocols(), this.getCertificateVerification() == SSLHostConfig.CertificateVerification.REQUIRED) : new SslRmiServerBindSocketFactory(sslContext, this.getEnabledCiphers(), this.getEnabledProtocols(), this.getCertificateVerification() == SSLHostConfig.CertificateVerification.REQUIRED, this.rmiBindAddress);
            } else if (this.rmiBindAddress != null) {
                registrySsf = new RmiServerBindSocketFactory(this.rmiBindAddress);
            }
            if (this.rmiServerSSL) {
                serverCsf = new SslRMIClientSocketFactory();
                serverSsf = this.rmiBindAddress == null ? new SslRMIServerSocketFactory(sslContext, this.getEnabledCiphers(), this.getEnabledProtocols(), this.getCertificateVerification() == SSLHostConfig.CertificateVerification.REQUIRED) : new SslRmiServerBindSocketFactory(sslContext, this.getEnabledCiphers(), this.getEnabledProtocols(), this.getCertificateVerification() == SSLHostConfig.CertificateVerification.REQUIRED, this.rmiBindAddress);
            } else if (this.rmiBindAddress != null) {
                serverSsf = new RmiServerBindSocketFactory(this.rmiBindAddress);
            }
            if (this.rmiBindAddress != null) {
                System.setProperty("java.rmi.server.hostname", this.rmiBindAddress);
            }
            if (this.useLocalPorts) {
                registryCsf = new RmiClientLocalhostSocketFactory(registryCsf);
                serverCsf = new RmiClientLocalhostSocketFactory(serverCsf);
            }
            env.put("jmx.remote.rmi.server.credential.types", new String[]{String[].class.getName(), String.class.getName()});
            if (serverCsf != null) {
                env.put("jmx.remote.rmi.client.socket.factory", serverCsf);
                env.put("com.sun.jndi.rmi.factory.socket", registryCsf);
            }
            if (serverSsf != null) {
                env.put("jmx.remote.rmi.server.socket.factory", serverSsf);
            }
            if (this.authenticate) {
                env.put("jmx.remote.x.password.file", this.passwordFile);
                env.put("jmx.remote.x.access.file", this.accessFile);
                env.put("jmx.remote.x.login.config", this.loginModuleName);
            }
            this.csPlatform = this.createServer("Platform", this.rmiBindAddress, this.rmiRegistryPortPlatform, this.rmiServerPortPlatform, env, registryCsf, registrySsf, serverCsf, serverSsf);
        } else if ("stop".equals(event.getType())) {
            this.destroyServer("Platform", this.csPlatform);
        }
    }

    private JMXConnectorServer createServer(String serverName, String bindAddress, int theRmiRegistryPort, int theRmiServerPort, Map<String, Object> theEnv, RMIClientSocketFactory registryCsf, RMIServerSocketFactory registrySsf, RMIClientSocketFactory serverCsf, RMIServerSocketFactory serverSsf) {
        JMXServiceURL serviceUrl;
        Registry registry;
        try {
            registry = LocateRegistry.createRegistry(theRmiRegistryPort, registryCsf, registrySsf);
        }
        catch (RemoteException e) {
            log.error((Object)sm.getString("jmxRemoteLifecycleListener.createRegistryFailed", new Object[]{serverName, Integer.toString(theRmiRegistryPort)}), (Throwable)e);
            return null;
        }
        if (bindAddress == null) {
            bindAddress = "localhost";
        }
        String url = "service:jmx:rmi://" + bindAddress;
        try {
            serviceUrl = new JMXServiceURL(url);
        }
        catch (MalformedURLException e) {
            log.error((Object)sm.getString("jmxRemoteLifecycleListener.invalidURL", new Object[]{serverName, url}), (Throwable)e);
            return null;
        }
        RMIConnectorServer cs = null;
        try {
            RMIJRMPServerImpl server = new RMIJRMPServerImpl(this.rmiServerPortPlatform, serverCsf, serverSsf, theEnv);
            cs = new RMIConnectorServer(serviceUrl, theEnv, server, ManagementFactory.getPlatformMBeanServer());
            cs.start();
            registry.bind("jmxrmi", server.toStub());
            log.info((Object)sm.getString("jmxRemoteLifecycleListener.start", new Object[]{Integer.toString(theRmiRegistryPort), Integer.toString(theRmiServerPort), serverName}));
        }
        catch (IOException | AlreadyBoundException e) {
            log.error((Object)sm.getString("jmxRemoteLifecycleListener.createServerFailed", new Object[]{serverName}), (Throwable)e);
        }
        return cs;
    }

    private void destroyServer(String serverName, JMXConnectorServer theConnectorServer) {
        if (theConnectorServer != null) {
            try {
                theConnectorServer.stop();
            }
            catch (IOException e) {
                log.error((Object)sm.getString("jmxRemoteLifecycleListener.destroyServerFailed", new Object[]{serverName}), (Throwable)e);
            }
        }
    }

    public static class SslRmiServerBindSocketFactory
    extends SslRMIServerSocketFactory {
        private final InetAddress bindAddress;
        private final SSLContext sslContext;

        public SslRmiServerBindSocketFactory(SSLContext sslContext, String[] enabledCipherSuites, String[] enabledProtocols, boolean needClientAuth, String address) {
            super(sslContext, enabledCipherSuites, enabledProtocols, needClientAuth);
            this.sslContext = sslContext;
            InetAddress bindAddress = null;
            try {
                bindAddress = InetAddress.getByName(address);
            }
            catch (UnknownHostException e) {
                log.error((Object)sm.getString("jmxRemoteLifecycleListener.invalidRmiBindAddress", new Object[]{address}), (Throwable)e);
            }
            this.bindAddress = bindAddress;
        }

        @Override
        public ServerSocket createServerSocket(int port) throws IOException {
            SSLServerSocketFactory sslServerSocketFactory = this.sslContext == null ? (SSLServerSocketFactory)SSLServerSocketFactory.getDefault() : this.sslContext.getServerSocketFactory();
            SSLServerSocket sslServerSocket = (SSLServerSocket)sslServerSocketFactory.createServerSocket(port, 0, this.bindAddress);
            if (this.getEnabledCipherSuites() != null) {
                sslServerSocket.setEnabledCipherSuites(this.getEnabledCipherSuites());
            }
            if (this.getEnabledProtocols() != null) {
                sslServerSocket.setEnabledProtocols(this.getEnabledProtocols());
            }
            sslServerSocket.setNeedClientAuth(this.getNeedClientAuth());
            return sslServerSocket;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.bindAddress == null ? 0 : this.bindAddress.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SslRmiServerBindSocketFactory other = (SslRmiServerBindSocketFactory)obj;
            return !(this.bindAddress == null ? other.bindAddress != null : !this.bindAddress.equals(other.bindAddress));
        }
    }

    public static class RmiServerBindSocketFactory
    implements RMIServerSocketFactory {
        private final InetAddress bindAddress;

        public RmiServerBindSocketFactory(String address) {
            InetAddress bindAddress = null;
            try {
                bindAddress = InetAddress.getByName(address);
            }
            catch (UnknownHostException e) {
                log.error((Object)sm.getString("jmxRemoteLifecycleListener.invalidRmiBindAddress", new Object[]{address}), (Throwable)e);
            }
            this.bindAddress = bindAddress;
        }

        @Override
        public ServerSocket createServerSocket(int port) throws IOException {
            return new ServerSocket(port, 0, this.bindAddress);
        }
    }

    public static class RmiClientLocalhostSocketFactory
    implements RMIClientSocketFactory,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final String FORCED_HOST = "localhost";
        private final RMIClientSocketFactory factory;

        public RmiClientLocalhostSocketFactory(RMIClientSocketFactory theFactory) {
            this.factory = theFactory;
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException {
            if (this.factory == null) {
                return new Socket(FORCED_HOST, port);
            }
            return this.factory.createSocket(FORCED_HOST, port);
        }
    }
}

