/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.arquillian.openejb;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.spi.Extension;
import org.apache.openejb.arquillian.openejb.reflection.Assets;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.Enumerator;
import org.apache.openejb.util.URLs;
import org.apache.openejb.util.reflection.Reflections;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Filter;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.base.filter.IncludeRegExpPaths;

public class SWClassLoader
extends ClassLoader
implements Closeable {
    private final Collection<Archive<?>> archives;
    private final Collection<Closeable> closeables = new ArrayList<Closeable>();

    public SWClassLoader(ClassLoader parent, Archive<?> ... ar) {
        super(parent);
        this.archives = new ArrayList(Arrays.asList(ar));
        for (Archive<?> a : ar) {
            ArchiveStreamHandler.set(a, this.closeables);
            boolean isWar = WebArchive.class.isInstance(a);
            if (!isWar) continue;
            for (Node n : a.getContent((Filter)new IncludeRegExpPaths("/WEB-INF/lib/.*\\.jar")).values()) {
                JavaArchive jar;
                Asset asset = n.getAsset();
                if (FileAsset.class.isInstance(asset)) {
                    jar = (JavaArchive)ShrinkWrap.createFromZipFile(JavaArchive.class, (File)Assets.get(File.class, "file", asset));
                    this.archives.add((Archive<?>)jar);
                    ArchiveStreamHandler.set(jar, this.closeables);
                    continue;
                }
                if (!UrlAsset.class.isInstance(asset)) continue;
                jar = (JavaArchive)ShrinkWrap.createFromZipFile(JavaArchive.class, (File)URLs.toFile((URL)Assets.get(URL.class, "url", asset)));
                this.archives.add((Archive<?>)jar);
                ArchiveStreamHandler.set(jar, this.closeables);
            }
        }
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (name == null) {
            return super.getResources(null);
        }
        boolean cdiExtensions = name.startsWith("META-INF/services/" + Extension.class.getName());
        if (cdiExtensions || !name.contains("META-INF/services/javax")) {
            LinkedList<Archive<?>> node = this.findNodes(name);
            if (!node.isEmpty()) {
                ArrayList<URL> urls = new ArrayList<URL>();
                for (Archive archive : node) {
                    urls.add(new URL(null, "archive:" + archive.getName() + (!name.startsWith("/") ? "/" : "") + name, new ArchiveStreamHandler()));
                }
                if (cdiExtensions && !"true".equalsIgnoreCase(SystemInstance.get().getProperty("openejb.arquillian.cdi.extension.skip-externals", "false"))) {
                    this.addContainerExtensions(name, urls);
                }
                return SWClassLoader.enumerator(urls);
            }
            if (cdiExtensions) {
                if ("true".equalsIgnoreCase(SystemInstance.get().getProperty("openejb.arquillian.cdi.extension.skip-externals", "false"))) {
                    return SWClassLoader.enumerator(Collections.emptyList());
                }
                return SWClassLoader.enumerator(this.addContainerExtensions(name, new ArrayList<URL>(2)));
            }
        }
        return super.getResources(name);
    }

    private List<URL> addContainerExtensions(String name, List<URL> urls) throws IOException {
        ArrayList<URL> containerExtensions = Collections.list(this.getParent().getResources(name));
        for (URL u : containerExtensions) {
            String externalForm = u.toExternalForm();
            if (!externalForm.contains("myfaces-impl") && !externalForm.contains("bval-jsr")) continue;
            urls.add(u);
        }
        return urls;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        LinkedList<Archive<?>> node = this.findNodes(name);
        if (!node.isEmpty()) {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (Archive archive : node) {
                urls.add(new URL(null, "archive:" + archive.getName() + (!name.startsWith("/") ? "/" : "") + name, new ArchiveStreamHandler()));
            }
            return SWClassLoader.enumerator(urls);
        }
        return super.findResources(name);
    }

    public URL getWebResource(String name) {
        for (Archive<?> a : this.archives) {
            Node node;
            if (!WebArchive.class.isInstance(a) || (node = a.get(name)) == null) continue;
            try {
                return new URL(null, "archive:" + a.getName() + (!name.startsWith("/") ? "/" : "") + name, new ArchiveStreamHandler());
            }
            catch (MalformedURLException e) {
            }
        }
        return null;
    }

    public LinkedList<Archive<?>> findNodes(String name) {
        LinkedList items = new LinkedList();
        for (Archive<?> a : this.archives) {
            boolean isWar;
            Node node = a.get(ArchivePaths.create((String)(((isWar = WebArchive.class.isInstance(a)) ? "/WEB-INF/classes/" : "") + name)));
            if (node == null) continue;
            items.add(a);
        }
        return items;
    }

    private static Enumeration<URL> enumerator(List<URL> urls) {
        return new Enumerator(urls);
    }

    @Override
    protected URL findResource(String name) {
        LinkedList<Archive<?>> node = this.findNodes(name);
        if (!node.isEmpty()) {
            Archive<?> i = node.getLast();
            try {
                return new URL(null, "archive:" + i.getName() + (!name.startsWith("/") ? "/" : "") + name, new ArchiveStreamHandler());
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return super.findResource(name);
    }

    @Override
    public void close() throws IOException {
        for (Archive<?> a : this.archives) {
            ArchiveStreamHandler.reset(a.getName());
        }
        for (Closeable cl : this.closeables) {
            try {
                cl.close();
            }
            catch (IOException iOException) {}
        }
    }

    public Collection<Archive<?>> getArchives() {
        return this.archives;
    }

    static {
        try {
            Field handler = URL.class.getDeclaredField("handlers");
            handler.setAccessible(true);
            ((Hashtable)handler.get(null)).put("archive", new ArchiveStreamHandler());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class ArchiveStreamHandler
    extends URLStreamHandler {
        public static final Map<String, Archive<?>> archives = new HashMap();
        public static final Map<String, Collection<Closeable>> closeables = new HashMap<String, Collection<Closeable>>();

        private ArchiveStreamHandler() {
        }

        public static void set(Archive<?> ar, Collection<Closeable> c) {
            String archiveName = ar.getName();
            archives.put(archiveName, ar);
            closeables.put(archiveName, c);
        }

        public static void reset(String archiveName) {
            archives.remove(archiveName);
            closeables.remove(archiveName);
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            final String arName = ArchiveStreamHandler.key(u);
            Archive<?> archive = archives.get(arName);
            String path = ArchiveStreamHandler.path(archive.getName(), WebArchive.class.isInstance(archive) ? "/WEB-INF/classes/" : "", u);
            Node node = archive.get(path);
            if (node == null && (node = archive.get(ArchiveStreamHandler.path(archive.getName(), "", u))) == null) {
                throw new IOException(u.toExternalForm() + " not found");
            }
            final Asset asset = node.getAsset();
            if (UrlAsset.class.isInstance(asset)) {
                return ((URL)URL.class.cast(Reflections.get((Object)asset, (String)"url"))).openConnection();
            }
            if (FileAsset.class.isInstance(asset)) {
                return ((File)File.class.cast(Reflections.get((Object)asset, (String)"file"))).toURI().toURL().openConnection();
            }
            if (ClassLoaderAsset.class.isInstance(asset)) {
                return ((ClassLoader)ClassLoader.class.cast(Reflections.get((Object)asset, (String)"classLoader"))).getResource((String)String.class.cast(Reflections.get((Object)asset, (String)"resourceName"))).openConnection();
            }
            return new URLConnection(u){

                @Override
                public void connect() throws IOException {
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    InputStream input = asset.openStream();
                    Collection<Closeable> c = closeables.get(arName);
                    c.add(input);
                    return input;
                }
            };
        }

        private static String path(String arName, String prefix, URL url) {
            String p = url.getPath();
            String out = p.substring(arName.length(), p.length());
            if (prefix.endsWith("/") && out.startsWith("/")) {
                return prefix + out.substring(1);
            }
            return prefix + out;
        }

        private static String key(URL url) {
            String p = url.getPath();
            if (p == null) {
                return null;
            }
            int endIndex = p.indexOf(47);
            if (endIndex >= 0) {
                return p.substring(0, endIndex);
            }
            return p;
        }
    }
}

