/*
 * Decompiled with CFR 0.152.
 */
package javax.json.bind.spi;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.List;
import java.util.ServiceLoader;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbException;

public abstract class JsonbProvider {
    private static final String DEFAULT_PROVIDER = "org.apache.johnzon.jsonb.JohnzonProvider";

    public static JsonbProvider provider() {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(() -> JsonbProvider.doLoadProvider(null));
        }
        return JsonbProvider.doLoadProvider(null);
    }

    public static JsonbProvider provider(String providerFqn) {
        if (providerFqn == null) {
            throw new IllegalArgumentException();
        }
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(() -> JsonbProvider.doLoadProvider(providerFqn));
        }
        return JsonbProvider.doLoadProvider(providerFqn);
    }

    private static JsonbProvider doLoadProvider(String providerFqn) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clazz = Class.forName("org.apache.geronimo.osgi.locator.ProviderLocator");
            Method getServices = clazz.getDeclaredMethod("getServices", String.class, Class.class, ClassLoader.class);
            List osgiProviders = (List)getServices.invoke(null, JsonbProvider.class.getName(), JsonbProvider.class, tccl);
            if (osgiProviders != null && !osgiProviders.isEmpty()) {
                return (JsonbProvider)osgiProviders.iterator().next();
            }
        }
        catch (Throwable clazz) {
            // empty catch block
        }
        for (JsonbProvider provider : ServiceLoader.load(JsonbProvider.class)) {
            if (providerFqn == null) {
                return provider;
            }
            if (!providerFqn.equals(provider.getClass().getName())) continue;
            return provider;
        }
        if (providerFqn != null) {
            String msg = providerFqn + " not found";
            throw new JsonbException(msg, new ClassNotFoundException(msg));
        }
        try {
            return (JsonbProvider)JsonbProvider.class.cast(Thread.currentThread().getContextClassLoader().loadClass(DEFAULT_PROVIDER).newInstance());
        }
        catch (ClassNotFoundException cnfe) {
            throw new JsonbException("org.apache.johnzon.jsonb.JohnzonProvider not found", cnfe);
        }
        catch (Exception x) {
            throw new JsonbException("org.apache.johnzon.jsonb.JohnzonProvider couldn't be instantiated: " + x, x);
        }
    }

    public abstract JsonbBuilder create();
}

