/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.maven.util;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;

public final class XmlFormatter {
    public static String format(String in) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(in));
            Document document = db.parse(is);
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)DOMImplementationLS.class.cast(registry.getDOMImplementation("XML 3.0 LS 3.0"));
            if (impl == null) {
                return in;
            }
            LSSerializer serializer = impl.createLSSerializer();
            if (serializer.getDomConfig().canSetParameter("format-pretty-print", Boolean.TRUE)) {
                serializer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
                LSOutput lsOutput = impl.createLSOutput();
                lsOutput.setEncoding("UTF-8");
                StringWriter stringWriter = new StringWriter();
                lsOutput.setCharacterStream(stringWriter);
                serializer.write(document, lsOutput);
                return stringWriter.toString();
            }
            return in;
        }
        catch (Throwable t) {
            return in;
        }
    }

    private XmlFormatter() {
    }
}

