/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.maven.plugins;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.logging.SimpleFormatter;
import org.apache.catalina.LifecycleState;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.openejb.core.ParentClassLoaderFinder;
import org.apache.openejb.core.ProvidedClassLoaderFinder;
import org.apache.openejb.loader.Files;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.maven.util.MavenLogStreamFactory;
import org.apache.openejb.maven.util.XmlFormatter;
import org.apache.openejb.util.JuliLogStreamFactory;
import org.apache.tomee.catalina.TomEERuntimeException;
import org.apache.tomee.embedded.Configuration;
import org.apache.tomee.embedded.Container;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM)
public class TomEEEmbeddedMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.packaging}")
    protected String packaging;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}")
    protected File warFile;
    @Parameter(property="tomee-embedded-plugin.http", defaultValue="8080")
    protected int httpPort;
    @Parameter(property="tomee-embedded-plugin.httpsPort", defaultValue="8443")
    protected int httpsPort;
    @Parameter(property="tomee-embedded-plugin.ajp", defaultValue="8009")
    protected int ajpPort = 8009;
    @Parameter(property="tomee-embedded-plugin.stop", defaultValue="8005")
    protected int stopPort;
    @Parameter(property="tomee-embedded-plugin.host", defaultValue="localhost")
    protected String host;
    @Parameter(property="tomee-embedded-plugin.lib", defaultValue="${project.build.directory}/apache-tomee-embedded")
    protected String dir;
    @Parameter(property="tomee-embedded-plugin.keystoreFile")
    protected String keystoreFile;
    @Parameter(property="tomee-embedded-plugin.keystorePass")
    protected String keystorePass;
    @Parameter(property="tomee-embedded-plugin.keystoreType", defaultValue="JKS")
    protected String keystoreType;
    @Parameter(property="tomee-embedded-plugin.clientAuth")
    protected String clientAuth;
    @Parameter(property="tomee-embedded-plugin.keyAlias")
    protected String keyAlias;
    @Parameter(property="tomee-embedded-plugin.sslProtocol")
    protected String sslProtocol;
    @Parameter
    protected File serverXml;
    @Parameter(property="tomee-embedded-plugin.ssl", defaultValue="false")
    protected boolean ssl;
    @Parameter(property="tomee-embedded-plugin.withEjbRemote", defaultValue="false")
    protected boolean withEjbRemote;
    @Parameter(property="tomee-embedded-plugin.quickSession", defaultValue="true")
    protected boolean quickSession;
    @Parameter(property="tomee-embedded-plugin.skipHttp", defaultValue="false")
    protected boolean skipHttp;
    @Parameter(property="tomee-embedded-plugin.classpathAsWar", defaultValue="false")
    protected boolean classpathAsWar;
    @Parameter(property="tomee-embedded-plugin.useProjectClasspath", defaultValue="true")
    protected boolean useProjectClasspath;
    @Parameter(property="tomee-embedded-plugin.modules", defaultValue="${project.build.outputDirectory}")
    protected List<File> modules;
    @Parameter(property="tomee-embedded-plugin.docBase", defaultValue="${project.basedir}/src/main/webapp")
    protected File docBase;
    @Parameter(property="tomee-embedded-plugin.context")
    protected String context;
    @Parameter
    protected Map<String, String> containerProperties;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="tomee-embedded-plugin.mavenLog", defaultValue="true")
    private boolean mavenLog;
    @Parameter(property="tomee-embedded-plugin.keepServerXmlAsThis", defaultValue="false")
    private boolean keepServerXmlAsThis;
    @Parameter
    private Map<String, String> users;
    @Parameter
    private Map<String, String> roles;
    @Parameter(property="tomee-plugin.jsp-development", defaultValue="true")
    private boolean forceJspDevelopment;
    @Component
    private ArtifactFactory factory;
    @Component
    private ArtifactResolver resolver;
    @Parameter(defaultValue="${localRepository}", readonly=true)
    private ArtifactRepository local;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true)
    private List<ArtifactRepository> remoteRepos;
    @Parameter
    private List<String> applications;
    @Parameter
    private List<String> applicationScopes;
    @Parameter(property="tomee-plugin.skip-current-project", defaultValue="false")
    private boolean skipCurrentProject;
    @Parameter(property="tomee-plugin.application-copy", defaultValue="${project.build.directory}/tomee-embedded/applications")
    private File applicationCopyFolder;
    @Parameter(property="tomee-plugin.work", defaultValue="${project.build.directory}/tomee-embedded-work")
    private File workDir;
    @Parameter
    protected PlexusConfiguration inlinedServerXml;
    @Parameter
    protected PlexusConfiguration inlinedTomEEXml;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.classpathAsWar && "pom".equals(this.packaging)) {
            this.getLog().warn((CharSequence)"this project is a pom, it is not deployable");
            return;
        }
        Properties originalSystProp = new Properties();
        originalSystProp.putAll((Map<?, ?>)System.getProperties());
        this.configureJULIfNeeded();
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        String logFactory = System.getProperty("openejb.log.factory");
        MavenLogStreamFactory.setLogger((Log)this.getLog());
        if (this.mavenLog) {
            System.setProperty("openejb.log.factory", MavenLogStreamFactory.class.getName());
            System.setProperty("openejb.jul.forceReload", "true");
        }
        if (this.inlinedServerXml != null && this.inlinedServerXml.getChildCount() > 0) {
            if (this.serverXml != null && this.serverXml.exists()) {
                throw new MojoFailureException("you can't define a server.xml and an inlinedServerXml");
            }
            try {
                FileUtils.forceMkdir((File)this.workDir);
                this.serverXml = new File(this.workDir, "server.xml_dump");
                FileUtils.fileWrite((File)this.serverXml, (String)XmlFormatter.format((String)this.inlinedServerXml.getChild(0).toString()));
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
        final Container container = new Container(){

            public void setup(Configuration configuration) {
                super.setup(configuration);
                if (TomEEEmbeddedMojo.this.inlinedTomEEXml != null && TomEEEmbeddedMojo.this.inlinedTomEEXml.getChildCount() > 0) {
                    try {
                        File conf = new File(TomEEEmbeddedMojo.this.dir, "conf");
                        FileUtils.forceMkdir((File)conf);
                        FileUtils.fileWrite((File)new File(conf, "tomee.xml"), (String)XmlFormatter.format((String)TomEEEmbeddedMojo.this.inlinedTomEEXml.getChild(0).toString()));
                    }
                    catch (Exception e) {
                        throw new TomEERuntimeException((Throwable)e);
                    }
                }
            }
        };
        Configuration config = this.getConfig();
        container.setup(config);
        Thread hook = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (container.getTomcat() != null && container.getTomcat().getServer().getState() != LifecycleState.DESTROYED) {
                    Thread thread = Thread.currentThread();
                    ClassLoader old = thread.getContextClassLoader();
                    thread.setContextClassLoader(ParentClassLoaderFinder.Helper.get());
                    try {
                        if (!TomEEEmbeddedMojo.this.classpathAsWar) {
                            container.undeploy(TomEEEmbeddedMojo.this.warFile.getAbsolutePath());
                        }
                        container.stop();
                    }
                    catch (Exception e) {
                        TomEEEmbeddedMojo.this.getLog().error((CharSequence)"can't stop TomEE", (Throwable)e);
                    }
                    finally {
                        thread.setContextClassLoader(old);
                    }
                }
            }
        };
        hook.setName("TomEE-Embedded-ShutdownHook");
        try {
            container.start();
            SystemInstance.get().setComponent(ParentClassLoaderFinder.class, (Object)new ProvidedClassLoaderFinder(loader));
            Runtime.getRuntime().addShutdownHook(hook);
            if (!this.skipCurrentProject) {
                if (!this.classpathAsWar) {
                    container.deploy('/' + (this.context == null ? this.warFile.getName() : this.context), this.warFile, true);
                } else {
                    if (this.useProjectClasspath) {
                        thread.setContextClassLoader(this.createClassLoader(loader));
                    }
                    container.deployClasspathAsWebApp(this.context, this.docBase, new String[0]);
                }
            }
            if (this.applications != null && !this.applications.isEmpty()) {
                Files.mkdirs((File)this.applicationCopyFolder);
                for (String app : this.applications) {
                    String name;
                    String renameStr = "?name=";
                    int nameIndex = app.lastIndexOf("?name=");
                    String coordinates = nameIndex > 0 ? app.substring(0, nameIndex) : app;
                    File file = this.mvnToFile(coordinates);
                    String string = name = nameIndex > 0 ? app.substring(nameIndex + "?name=".length() + 1) : file.getName();
                    if (this.applicationCopyFolder != null) {
                        File copy = new File(this.applicationCopyFolder, name);
                        IO.copy((File)file, (File)copy);
                        file = copy;
                    }
                    container.deploy(name, file);
                }
            }
            this.getLog().info((CharSequence)("TomEE embedded started on " + config.getHost() + ":" + config.getHttpPort()));
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"can't start TomEE", (Throwable)e);
        }
        try {
            String line;
            Scanner scanner = new Scanner(System.in);
            while ((line = scanner.nextLine()) != null) {
                switch (line.trim()) {
                    case "exit": 
                    case "quit": {
                        Runtime.getRuntime().removeShutdownHook(hook);
                        container.close();
                        return;
                    }
                }
            }
        }
        catch (Exception e) {
            Thread.interrupted();
        }
        finally {
            if (logFactory == null) {
                System.clearProperty("openejb.log.factory");
            } else {
                System.setProperty("openejb.log.factory", logFactory);
            }
            thread.setContextClassLoader(loader);
            System.setProperties(originalSystProp);
        }
    }

    private File mvnToFile(String lib) throws Exception {
        String[] infos = lib.split(":");
        if (infos.length < 3) {
            throw new MojoExecutionException("format for librairies should be <groupId>:<artifactId>:<version>[:<type>[:<classifier>]]");
        }
        String type = infos.length >= 4 ? infos[3] : "war";
        String classifier = infos.length == 5 ? infos[4] : null;
        Artifact artifact = this.factory.createDependencyArtifact(infos[0], infos[1], VersionRange.createFromVersion((String)infos[2]), type, classifier, "compile");
        this.resolver.resolve(artifact, this.remoteRepos, this.local);
        return artifact.getFile();
    }

    private void configureJULIfNeeded() {
        if (this.containerProperties != null && "true".equalsIgnoreCase(this.containerProperties.get("openejb.jul.forceReload"))) {
            System.getProperties().putAll(this.containerProperties);
            new JuliLogStreamFactory();
            String simpleFormat = this.containerProperties.get("java.util.logging.SimpleFormatter.format");
            if (simpleFormat != null) {
                try {
                    Field field = SimpleFormatter.class.getDeclaredField("format");
                    field.setAccessible(true);
                    int modifiers = field.getModifiers();
                    if (Modifier.isFinal(modifiers)) {
                        Field modifiersField = Field.class.getDeclaredField("modifiers");
                        modifiersField.setAccessible(true);
                        modifiersField.setInt(field, modifiers & 0xFFFFFFEF);
                    }
                    field.set(null, simpleFormat);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private ClassLoader createClassLoader(final ClassLoader parent) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (Artifact artifact : this.project.getArtifacts()) {
            String scope = artifact.getScope();
            if (this.applicationScopes == null && !"compile".equals(scope) && !"runtime".equals(scope) || this.applicationScopes != null && !this.applicationScopes.contains(scope)) continue;
            try {
                urls.add(artifact.getFile().toURI().toURL());
            }
            catch (MalformedURLException e) {
                this.getLog().warn((CharSequence)("can't use artifact " + artifact.toString()));
            }
        }
        if (this.modules != null) {
            for (File file : this.modules) {
                if (file.exists()) {
                    try {
                        urls.add(file.toURI().toURL());
                    }
                    catch (MalformedURLException e) {
                        this.getLog().warn((CharSequence)("can't use path " + file.getAbsolutePath()));
                    }
                    continue;
                }
                this.getLog().warn((CharSequence)("can't find " + file.getAbsolutePath()));
            }
        }
        return urls.isEmpty() ? parent : new URLClassLoader(urls.toArray(new URL[urls.size()]), parent){

            public boolean equals(Object obj) {
                return super.equals(obj) || parent.equals(obj);
            }
        };
    }

    private Configuration getConfig() {
        Configuration config = new Configuration();
        for (Field field : ((Object)((Object)this)).getClass().getDeclaredFields()) {
            try {
                Field configField = Configuration.class.getDeclaredField(field.getName());
                field.setAccessible(true);
                configField.setAccessible(true);
                Object value = field.get((Object)this);
                if (value == null) continue;
                configField.set(config, value);
                this.getLog().debug((CharSequence)("using " + field.getName() + " = " + value));
            }
            catch (NoSuchFieldException nsfe) {
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("can't initialize attribute " + field.getName()));
            }
        }
        if (this.containerProperties != null) {
            Properties props = new Properties();
            props.putAll(this.containerProperties);
            config.setProperties(props);
        }
        if (this.forceJspDevelopment) {
            if (config.getProperties() == null) {
                config.setProperties(new Properties());
            }
            config.getProperties().put("tomee.jsp-development", "true");
        }
        return config;
    }
}

