/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cxf.transport.util;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.apache.openejb.server.cxf.transport.util.CxfUtil;

public class CxfContainerClassLoader
extends ClassLoader {
    private static final ClassLoader CONTAINER_LOADER = CxfUtil.class.getClassLoader();
    public static final String CXF_PACKAGE = "org.apache.cxf.";
    private final ThreadLocal<ClassLoader> tccl = new ThreadLocal();

    public CxfContainerClassLoader() {
        super(CONTAINER_LOADER);
    }

    public void tccl(ClassLoader loader) {
        if (loader != this) {
            this.tccl.set(loader);
        }
    }

    public void clear() {
        this.tccl.remove();
    }

    public boolean hasTccl() {
        ClassLoader current = this.tccl.get();
        if (current != null) {
            return true;
        }
        this.tccl.remove();
        return false;
    }

    private ClassLoader tccl() {
        ClassLoader current = this.tccl.get();
        if (current != null) {
            return current;
        }
        this.tccl.remove();
        return CONTAINER_LOADER;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (name.startsWith(CXF_PACKAGE)) {
            Throwable th = new ClassNotFoundException(name);
            try {
                return CONTAINER_LOADER.loadClass(name);
            }
            catch (Exception e) {
                th = e;
            }
            catch (Error err) {
                th = err;
            }
            try {
                return this.tccl().loadClass(name);
            }
            catch (Error | Exception throwable) {
                if (Error.class.isInstance(th)) {
                    throw (Error)Error.class.cast(th);
                }
                if (ClassNotFoundException.class.isInstance(th)) {
                    throw (ClassNotFoundException)ClassNotFoundException.class.cast(th);
                }
                throw new ClassNotFoundException(th.getMessage(), th);
            }
        }
        return this.tccl().loadClass(name);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.findClass(name);
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    @Override
    protected URL findResource(String name) {
        return this.tccl().getResource(name);
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        return this.tccl().getResources(name);
    }

    public boolean equals(Object o) {
        ClassLoader classLoader = this.tccl();
        if (classLoader == null || CxfContainerClassLoader.class.isInstance(classLoader)) {
            return CONTAINER_LOADER.equals(o);
        }
        return classLoader.equals(o);
    }

    public int hashCode() {
        ClassLoader classLoader = this.tccl();
        if (classLoader == null || CxfContainerClassLoader.class.isInstance(classLoader)) {
            return CONTAINER_LOADER.hashCode();
        }
        return classLoader.hashCode();
    }
}

