/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.httpd;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import org.apache.openejb.server.httpd.HttpRequest;
import org.apache.openejb.server.httpd.HttpSession;
import org.apache.openejb.server.httpd.ServletSessionAdapter;

public class ServletRequestAdapter
implements HttpRequest {
    private final HttpServletRequest request;

    public ServletRequestAdapter(HttpServletRequest request) {
        this.request = request;
    }

    public ServletRequestAdapter(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        this.request = request;
        request.setAttribute(HttpRequest.SERVLET_REQUEST, (Object)request);
        request.setAttribute(HttpRequest.SERVLET_RESPONSE, (Object)response);
        request.setAttribute(HttpRequest.SERVLET_CONTEXT, (Object)servletContext);
    }

    public HttpSession getSession(boolean create) {
        javax.servlet.http.HttpSession session = this.request.getSession(create);
        if (session != null) {
            return new ServletSessionAdapter(session);
        }
        return null;
    }

    public Principal getUserPrincipal() {
        return this.request.getUserPrincipal();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.request.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.request.isRequestedSessionIdFromUrl();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.request.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdValid() {
        return this.request.isRequestedSessionIdValid();
    }

    public boolean isUserInRole(String s) {
        return this.request.isUserInRole(s);
    }

    public void login(String s, String s1) throws ServletException {
        this.request.login(s, s1);
    }

    public void logout() throws ServletException {
        this.request.logout();
    }

    public HttpSession getSession() {
        javax.servlet.http.HttpSession session = this.request.getSession();
        if (session != null) {
            return new ServletSessionAdapter(session);
        }
        return null;
    }

    public String changeSessionId() {
        return this.request.changeSessionId();
    }

    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    public Enumeration<String> getHeaderNames() {
        return this.request.getHeaderNames();
    }

    public Enumeration<String> getHeaders(String s) {
        return this.request.getHeaders(s);
    }

    public int getIntHeader(String s) {
        return this.request.getIntHeader(s);
    }

    @Override
    public URI getURI() {
        try {
            return new URI(this.request.getScheme(), null, this.request.getServerName(), this.request.getServerPort(), this.request.getRequestURI(), this.request.getQueryString(), null);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public int getContentLength() {
        return this.request.getContentLength();
    }

    public long getContentLengthLong() {
        return this.request.getContentLengthLong();
    }

    @Override
    public String getContentType() {
        return this.request.getContentType();
    }

    public DispatcherType getDispatcherType() {
        return this.request.getDispatcherType();
    }

    public boolean authenticate(HttpServletResponse httpServletResponse) throws IOException, ServletException {
        return this.request.authenticate(httpServletResponse);
    }

    public String getAuthType() {
        return this.request.getAuthType();
    }

    public String getContextPath() {
        return this.request.getContextPath();
    }

    public Cookie[] getCookies() {
        return this.request.getCookies();
    }

    public long getDateHeader(String s) {
        return this.request.getDateHeader(s);
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.request.getInputStream();
    }

    public String getLocalAddr() {
        return this.request.getLocalAddr();
    }

    public Locale getLocale() {
        return this.request.getLocale();
    }

    public Enumeration<Locale> getLocales() {
        return this.request.getLocales();
    }

    public String getLocalName() {
        return this.request.getLocalName();
    }

    public int getLocalPort() {
        return this.request.getLocalPort();
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public Part getPart(String s) throws IOException, ServletException {
        return this.request.getPart(s);
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> httpUpgradeHandlerClass) throws IOException, ServletException {
        return (T)this.request.upgrade(httpUpgradeHandlerClass);
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return this.request.getParts();
    }

    public String getPathInfo() {
        return this.request.getPathInfo();
    }

    public String getPathTranslated() {
        return this.request.getPathTranslated();
    }

    public String getQueryString() {
        return this.request.getQueryString();
    }

    public String getRemoteUser() {
        return this.request.getRemoteUser();
    }

    public String getRequestedSessionId() {
        return this.request.getRequestedSessionId();
    }

    public String getRequestURI() {
        return this.request.getRequestURI();
    }

    public StringBuffer getRequestURL() {
        return this.request.getRequestURL();
    }

    public String getServletPath() {
        return this.request.getServletPath();
    }

    @Override
    public String getParameter(String name) {
        return this.request.getParameter(name);
    }

    public Map<String, String[]> getParameterMap() {
        return this.request.getParameterMap();
    }

    public Enumeration<String> getParameterNames() {
        return this.request.getParameterNames();
    }

    public String[] getParameterValues(String s) {
        return this.request.getParameterValues(s);
    }

    public String getProtocol() {
        return this.request.getProtocol();
    }

    public BufferedReader getReader() throws IOException {
        return this.request.getReader();
    }

    public String getRealPath(String s) {
        return this.request.getRealPath(s);
    }

    @Override
    public Map getParameters() {
        return this.request.getParameterMap();
    }

    public AsyncContext getAsyncContext() {
        return this.request.getAsyncContext();
    }

    @Override
    public Object getAttribute(String s) {
        return this.request.getAttribute(s);
    }

    public Enumeration<String> getAttributeNames() {
        return this.request.getAttributeNames();
    }

    public String getCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    @Override
    public void setAttribute(String s, Object o) {
        this.request.setAttribute(s, o);
    }

    public void setCharacterEncoding(String s) throws UnsupportedEncodingException {
        this.request.setCharacterEncoding(s);
    }

    public AsyncContext startAsync() {
        return this.request.startAsync();
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) {
        return this.request.startAsync(servletRequest, servletResponse);
    }

    @Override
    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.request.getRemoteHost();
    }

    public int getRemotePort() {
        return this.request.getRemotePort();
    }

    public RequestDispatcher getRequestDispatcher(String s) {
        return this.request.getRequestDispatcher(s);
    }

    public String getScheme() {
        return this.request.getScheme();
    }

    public String getServerName() {
        return this.request.getServerName();
    }

    public int getServerPort() {
        return this.request.getServerPort();
    }

    public ServletContext getServletContext() {
        return this.request.getServletContext();
    }

    public boolean isAsyncStarted() {
        return this.request.isAsyncStarted();
    }

    public boolean isAsyncSupported() {
        return this.request.isAsyncSupported();
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }

    public void removeAttribute(String s) {
        this.request.removeAttribute(s);
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }
}

