/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.jee;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.openejb.jee.IsolationLevel;
import org.apache.openejb.jee.Keyable;
import org.apache.openejb.jee.Property;
import org.apache.openejb.jee.Text;
import org.apache.openejb.jee.TextMap;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="data-sourceType", propOrder={"descriptions", "name", "className", "serverName", "portNumber", "databaseName", "url", "user", "password", "property", "loginTimeout", "transactional", "isolationLevel", "initialPoolSize", "maxPoolSize", "minPoolSize", "maxIdleTime", "maxStatements"})
public class DataSource
implements Keyable<String> {
    @XmlTransient
    protected TextMap description = new TextMap();
    @XmlElement(required=true)
    protected String name;
    @XmlElement(name="class-name")
    protected String className;
    @XmlElement(name="server-name")
    protected String serverName;
    @XmlElement(name="port-number")
    protected Integer portNumber;
    @XmlElement(name="database-name")
    protected String databaseName;
    protected String url;
    protected String user;
    protected String password;
    protected List<Property> property;
    @XmlElement(name="login-timeout")
    protected Integer loginTimeout;
    protected Boolean transactional;
    @XmlElement(name="isolation-level")
    protected IsolationLevel isolationLevel;
    @XmlElement(name="initial-pool-size")
    protected Integer initialPoolSize;
    @XmlElement(name="max-pool-size")
    protected Integer maxPoolSize;
    @XmlElement(name="min-pool-size")
    protected Integer minPoolSize;
    @XmlElement(name="max-idle-time")
    protected Integer maxIdleTime;
    @XmlElement(name="max-statements")
    protected Integer maxStatements;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlID
    @XmlSchemaType(name="ID")
    protected String id;

    @XmlElement(name="description")
    public Text[] getDescriptions() {
        return this.description.toArray();
    }

    public DataSource() {
    }

    public DataSource(String name, String className) {
        this.name = name;
        this.className = className;
    }

    public DataSource name(String name) {
        this.name = name;
        return this;
    }

    public DataSource className(String className) {
        this.className = className;
        return this;
    }

    public DataSource serverName(String serverName) {
        this.serverName = serverName;
        return this;
    }

    public DataSource portNumber(Integer portNumber) {
        this.portNumber = portNumber;
        return this;
    }

    public DataSource databaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public DataSource url(String url) {
        this.url = url;
        return this;
    }

    public DataSource user(String user) {
        this.user = user;
        return this;
    }

    public DataSource password(String password) {
        this.password = password;
        return this;
    }

    public DataSource property(String name, String value) {
        this.getProperty().add(new Property(name, value));
        return this;
    }

    public DataSource loginTimeout(Integer loginTimeout) {
        this.loginTimeout = loginTimeout;
        return this;
    }

    public DataSource transactional(Boolean transactional) {
        this.transactional = transactional;
        return this;
    }

    public DataSource isolationLevel(IsolationLevel isolationLevel) {
        this.isolationLevel = isolationLevel;
        return this;
    }

    public DataSource initialPoolSize(Integer initialPoolSize) {
        this.initialPoolSize = initialPoolSize;
        return this;
    }

    public DataSource maxPoolSize(Integer maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
        return this;
    }

    public DataSource minPoolSize(Integer minPoolSize) {
        this.minPoolSize = minPoolSize;
        return this;
    }

    public DataSource maxIdleTime(Integer maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
        return this;
    }

    public DataSource maxStatements(Integer maxStatements) {
        this.maxStatements = maxStatements;
        return this;
    }

    public void setDescriptions(Text[] text) {
        this.description.set(text);
    }

    public String getDescription() {
        return this.description.get();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String value) {
        this.className = value;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String value) {
        this.serverName = value;
    }

    public Integer getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(Integer value) {
        this.portNumber = value;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String value) {
        this.databaseName = value;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String value) {
        this.url = value;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String value) {
        this.user = value;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String value) {
        this.password = value;
    }

    public List<Property> getProperty() {
        if (this.property == null) {
            this.property = new ArrayList<Property>();
        }
        return this.property;
    }

    public Integer getLoginTimeout() {
        return this.loginTimeout;
    }

    public void setLoginTimeout(Integer value) {
        this.loginTimeout = value;
    }

    public Boolean getTransactional() {
        return this.transactional;
    }

    public void setTransactional(Boolean value) {
        this.transactional = value;
    }

    public IsolationLevel getIsolationLevel() {
        return this.isolationLevel;
    }

    public void setIsolationLevel(IsolationLevel value) {
        this.isolationLevel = value;
    }

    public Integer getInitialPoolSize() {
        return this.initialPoolSize;
    }

    public void setInitialPoolSize(Integer value) {
        this.initialPoolSize = value;
    }

    public Integer getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(Integer value) {
        this.maxPoolSize = value;
    }

    public Integer getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setMinPoolSize(Integer value) {
        this.minPoolSize = value;
    }

    public Integer getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(Integer value) {
        this.maxIdleTime = value;
    }

    public Integer getMaxStatements() {
        return this.maxStatements;
    }

    public void setMaxStatements(Integer value) {
        this.maxStatements = value;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    @Override
    public String getKey() {
        String name = this.getName();
        if (name.startsWith("java:comp/env/")) {
            return name.substring("java:comp/env/".length());
        }
        return name;
    }
}

