/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.loader;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.openejb.loader.ClassPath;
import org.apache.openejb.loader.ClassPathFactory;
import org.apache.openejb.loader.FileUtils;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.LoaderRuntimeException;
import org.apache.openejb.loader.Options;
import org.apache.openejb.loader.event.ComponentAdded;
import org.apache.openejb.loader.event.ComponentRemoved;
import org.apache.openejb.loader.provisining.ProvisioningResolver;
import org.apache.openejb.observer.ObserverManager;

public final class SystemInstance {
    private static final String PROFILE_PROP = "openejb.profile";
    private static final String DEFAULT_PROFILE = "development";
    private final long startTime = System.currentTimeMillis();
    private final Properties internalProperties = new Properties(System.getProperties());
    private final Options options;
    private final FileUtils home;
    private final FileUtils base;
    private final ClassLoader classLoader;
    private final Map<Class, Object> components;
    private final ClassPath classPath;
    private final ObserverManager observerManager = new ObserverManager();
    private static SystemInstance system;
    private static boolean initialized;

    private SystemInstance(Properties properties) {
        String baseDirCanonicalPath;
        String homeDirCanonicalPath;
        this.components = new HashMap<Class, Object>();
        for (String key : System.getProperties().stringPropertyNames()) {
            String value;
            String pkg;
            if (key.startsWith("sun.") || key.startsWith("os.") || key.startsWith("user.") || key.startsWith("awt.") || key.startsWith("java.") && ((pkg = key.substring("java.".length())).startsWith("vm.") || pkg.startsWith("runtime.") || pkg.startsWith("awt.") || pkg.startsWith("specification.") || pkg.startsWith("class.") || pkg.startsWith("library.") || pkg.startsWith("ext.") || pkg.startsWith("vendor.") || pkg.startsWith("endorsed.")) || (value = System.getProperty(key)) == null) continue;
            this.internalProperties.put(key, value);
        }
        this.internalProperties.putAll((Map<?, ?>)properties);
        this.options = new Options(this.internalProperties, new Options(System.getProperties()));
        this.home = new FileUtils("openejb.home", "user.dir", this.internalProperties);
        this.base = new FileUtils("openejb.base", "openejb.home", this.internalProperties);
        this.classPath = ClassPathFactory.createClassPath(this.internalProperties.getProperty("openejb.loader", "context"));
        this.classLoader = this.classPath.getClassLoader();
        try {
            homeDirCanonicalPath = this.home.getDirectory().getCanonicalPath();
            baseDirCanonicalPath = this.base.getDirectory().getCanonicalPath();
        }
        catch (IOException e) {
            throw new LoaderRuntimeException("Failed to create default instance of SystemInstance", e);
        }
        this.internalProperties.setProperty("openejb.home", homeDirCanonicalPath);
        this.internalProperties.setProperty("openejb.base", baseDirCanonicalPath);
        System.setProperty("derby.system.home", System.getProperty("derby.system.home", baseDirCanonicalPath));
    }

    public <E> E fireEvent(E event) {
        return this.observerManager.fireEvent(event);
    }

    public boolean addObserver(Object observer) {
        return this.observerManager.addObserver(observer);
    }

    public boolean removeObserver(Object observer) {
        return this.observerManager.removeObserver(observer);
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Options getOptions() {
        return this.options;
    }

    public Properties getProperties() {
        return this.internalProperties;
    }

    public String getProperty(String key) {
        return this.internalProperties.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.internalProperties.getProperty(key, defaultValue);
    }

    public Object setProperty(String key, String value) {
        return this.setProperty(key, value, false);
    }

    public Object setProperty(String key, String value, boolean isExternalProperty) {
        if (isExternalProperty) {
            System.setProperty(key, value);
        }
        return this.internalProperties.setProperty(key, value);
    }

    public FileUtils getHome() {
        if (!SystemInstance.isInitialized()) {
            return new FileUtils("openejb.home", "user.dir", System.getProperties());
        }
        return this.home;
    }

    public FileUtils getBase() {
        if (!SystemInstance.isInitialized()) {
            return new FileUtils("openejb.base", "openejb.home", System.getProperties());
        }
        return this.base;
    }

    public ClassPath getClassPath() {
        return this.classPath;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public <T> T getComponent(Class<T> type) {
        Object component = this.components.get(type);
        if (component != null) {
            return (T)component;
        }
        String classname = this.getProperty(type.getName());
        if (classname != null) {
            try {
                T instance = type.cast(Thread.currentThread().getContextClassLoader().loadClass(classname).newInstance());
                this.components.put(type, instance);
                return instance;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    public <T> T removeComponent(Class<T> type) {
        Object component = this.components.remove(type);
        if (component != null) {
            this.fireEvent(new ComponentRemoved<Object>(type, component));
        }
        return (T)component;
    }

    public <T> T setComponent(Class<T> type, T value) {
        Object removed = this.components.put(type, value);
        if (removed != null) {
            this.fireEvent(new ComponentRemoved<T>(type, value));
        }
        if (value != null) {
            this.fireEvent(new ComponentAdded<T>(type, value));
        }
        return (T)removed;
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static synchronized void reset() {
        try {
            System.clearProperty("openejb.loader");
            system = new SystemInstance(new Properties());
            initialized = false;
        }
        catch (Exception e) {
            throw new LoaderRuntimeException("Failed to create default instance of SystemInstance", e);
        }
    }

    public static synchronized void init(Properties properties) throws Exception {
        if (initialized) {
            return;
        }
        system = new SystemInstance(properties);
        SystemInstance.readUserSystemProperties();
        SystemInstance.readSystemProperties();
        SystemInstance.readSystemProperties(SystemInstance.get().currentProfile());
        System.getProperties().putAll((Map<?, ?>)system.getProperties());
        initialized = true;
        SystemInstance.get().setProperty("openejb.profile.custom", Boolean.toString(!SystemInstance.get().isDefaultProfile()));
        SystemInstance.initDefaultComponents();
    }

    private static void initDefaultComponents() {
        SystemInstance systemInstance = SystemInstance.get();
        systemInstance.components.put(ProvisioningResolver.class, new ProvisioningResolver());
    }

    private static void readUserSystemProperties() {
        File file = new File(System.getProperty("user.home"), ".openejb/system.properties");
        SystemInstance.addSystemProperties(file);
    }

    public File getConf(String subPath) {
        File conf = null;
        try {
            conf = system.getBase().getDirectory("conf");
        }
        catch (IOException e) {
            // empty catch block
        }
        if (conf == null || !conf.exists()) {
            try {
                conf = system.getBase().getDirectory("etc");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (conf == null || !conf.exists()) {
            return new File(system.getBase().getDirectory(), "conf");
        }
        if (subPath == null) {
            return conf;
        }
        return new File(conf, subPath);
    }

    private static void readSystemProperties(String prefix) {
        String completePrefix = prefix != null && !prefix.isEmpty() ? prefix + "." : "";
        File conf = system.getConf(completePrefix + "system.properties");
        if (conf != null && conf.exists()) {
            SystemInstance.addSystemProperties(conf);
        }
    }

    private static void readSystemProperties() {
        SystemInstance.readSystemProperties(null);
    }

    private static void addSystemProperties(File file) {
        Properties systemProperties;
        if (!file.exists()) {
            return;
        }
        try {
            systemProperties = IO.readProperties(file);
        }
        catch (IOException e) {
            return;
        }
        system.getProperties().putAll((Map<?, ?>)systemProperties);
    }

    public static SystemInstance get() {
        return system;
    }

    public String currentProfile() {
        return this.getProperty(PROFILE_PROP, DEFAULT_PROFILE);
    }

    public boolean isDefaultProfile() {
        return DEFAULT_PROFILE.equals(this.currentProfile());
    }

    public boolean hasProperty(String propName) {
        return this.internalProperties.get(propName) != null;
    }

    public void removeObservers() {
        this.observerManager.destroy();
    }

    static {
        SystemInstance.reset();
    }
}

