/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import java.io.File;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.loader.WebappLoader;
import org.apache.openejb.ClassLoaderUtil;
import org.apache.openejb.classloader.ClassLoaderConfigurer;
import org.apache.openejb.classloader.CompositeClassLoaderConfigurer;
import org.apache.openejb.config.QuickJarsTxtParser;
import org.apache.openejb.loader.SystemInstance;
import org.apache.tomee.catalina.Contexts;
import org.apache.tomee.catalina.TomEEWebappClassLoader;

public class TomEEWebappLoader
extends WebappLoader {
    public static final boolean SKIP_BACKGROUND_PROCESS = "true".equals(SystemInstance.get().getProperty("tomee.classloader.skip-background-process", "false"));
    private volatile ClassLoader loader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backgroundProcess() {
        if (SKIP_BACKGROUND_PROCESS) {
            return;
        }
        ClassLoader classloader = super.getClassLoader();
        if (classloader instanceof TomEEWebappClassLoader) {
            TomEEWebappClassLoader tomEEWebappClassLoader = (TomEEWebappClassLoader)((Object)classloader);
            tomEEWebappClassLoader.restarting();
            try {
                super.backgroundProcess();
            }
            finally {
                tomEEWebappClassLoader.restarted();
            }
        } else {
            super.backgroundProcess();
        }
    }

    public boolean modified() {
        return !SKIP_BACKGROUND_PROCESS && super.modified();
    }

    protected void stopInternal() throws LifecycleException {
        this.loader = this.getClassLoader();
        super.stopInternal();
    }

    public void clearLoader() {
        this.loader = null;
    }

    public ClassLoader internalLoader() {
        return this.loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startInternal() throws LifecycleException {
        TomEEWebappClassLoader webappClassLoader;
        if (this.getClassLoader() != null && (webappClassLoader = (TomEEWebappClassLoader)((Object)TomEEWebappClassLoader.class.cast(this.getClassLoader()))).isStopped()) {
            webappClassLoader.internalStop();
        }
        Context context = this.getContext();
        ClassLoaderConfigurer configurer = ClassLoaderUtil.configurer((String)context.getName());
        File war = Contexts.warPath((Context)Context.class.cast(context));
        File jarsXml = new File(war, "WEB-INF/jars.txt");
        ClassLoaderConfigurer configurerTxt = QuickJarsTxtParser.parse((File)jarsXml);
        if (configurerTxt != null) {
            configurer = new CompositeClassLoaderConfigurer(new ClassLoaderConfigurer[]{configurer, configurerTxt});
        }
        TomEEWebappClassLoader.initContext(configurer);
        TomEEWebappClassLoader.initContext(context);
        try {
            super.startInternal();
        }
        finally {
            TomEEWebappClassLoader.cleanContext();
        }
    }

    public String toString() {
        return "TomEE" + super.toString();
    }
}

