/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.embedded;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import org.apache.catalina.Realm;
import org.apache.openejb.util.NetworkUtil;
import org.apache.tomee.embedded.LoginConfigBuilder;
import org.apache.tomee.embedded.SecurityConstaintBuilder;

public class Configuration {
    private int httpPort = 8080;
    private int stopPort = 8005;
    private String host = "localhost";
    protected String dir;
    private File serverXml;
    private boolean keepServerXmlAsThis;
    private Properties properties;
    private boolean quickSession = true;
    private boolean skipHttp;
    private int httpsPort = 8443;
    private boolean ssl;
    private boolean withEjbRemote;
    private String keystoreFile;
    private String keystorePass;
    private String keystoreType = "JKS";
    private String clientAuth;
    private String keyAlias;
    private String sslProtocol;
    private String webXml;
    private LoginConfigBuilder loginConfig;
    private Collection<SecurityConstaintBuilder> securityConstraints = new LinkedList<SecurityConstaintBuilder>();
    private Realm realm;
    private boolean deployOpenEjbApp;
    private Map<String, String> users;
    private Map<String, String> roles;
    private String tempDir = new File(System.getProperty("java.io.tmpdir"), "tomee-embedded_" + System.currentTimeMillis()).getAbsolutePath();

    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public Configuration randomHttpPort() {
        this.httpPort = NetworkUtil.getNextAvailablePort();
        return this;
    }

    public int getStopPort() {
        return this.stopPort;
    }

    public void setStopPort(int stopPort) {
        this.stopPort = stopPort;
    }

    public String getDir() {
        return this.dir;
    }

    public Configuration dir(String dir) {
        this.setDir(dir);
        return this;
    }

    public boolean isWithEjbRemote() {
        return this.withEjbRemote;
    }

    public Configuration withEjbRemote(boolean withEjbRemote) {
        this.setWithEjbRemote(withEjbRemote);
        return this;
    }

    public void setWithEjbRemote(boolean withEjbRemote) {
        this.withEjbRemote = withEjbRemote;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public String getHost() {
        return this.host;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public void setHttpsPort(int httpsPort) {
        this.httpsPort = httpsPort;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getKeystoreFile() {
        return this.keystoreFile;
    }

    public void setKeystoreFile(String keystoreFile) {
        this.keystoreFile = keystoreFile;
    }

    public String getKeystorePass() {
        return this.keystorePass;
    }

    public void setKeystorePass(String keystorePass) {
        this.keystorePass = keystorePass;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public void setKeystoreType(String keystoreType) {
        this.keystoreType = keystoreType;
    }

    public String getClientAuth() {
        return this.clientAuth;
    }

    public void setClientAuth(String clientAuth) {
        this.clientAuth = clientAuth;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    public void setServerXml(String file) {
        if (file == null) {
            this.serverXml = null;
        } else {
            File sXml = new File(file);
            if (sXml.exists()) {
                this.serverXml = sXml;
            }
        }
    }

    public File getServerXmlFile() {
        return this.serverXml;
    }

    public boolean hasServerXml() {
        return this.serverXml != null && this.serverXml.exists();
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public boolean isQuickSession() {
        return this.quickSession;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public boolean isSkipHttp() {
        return this.skipHttp;
    }

    public void setSkipHttp(boolean skipHttp) {
        this.skipHttp = skipHttp;
    }

    public void setQuickSession(boolean quickSession) {
        this.quickSession = quickSession;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public Configuration property(String key, String value) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.setProperty(key, value);
        return this;
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public void setTempDir(String tempDir) {
        this.tempDir = tempDir;
    }

    public boolean isDeployOpenEjbApp() {
        return this.deployOpenEjbApp;
    }

    public void setDeployOpenEjbApp(boolean deployOpenEjbApp) {
        this.deployOpenEjbApp = deployOpenEjbApp;
    }

    public Configuration http(int port) {
        this.setHttpPort(port);
        return this;
    }

    public Map<String, String> getUsers() {
        return this.users;
    }

    public void setUsers(Map<String, String> users) {
        this.users = users;
    }

    public Map<String, String> getRoles() {
        return this.roles;
    }

    public void setRoles(Map<String, String> roles) {
        this.roles = roles;
    }

    public boolean isKeepServerXmlAsThis() {
        return this.keepServerXmlAsThis;
    }

    public void setKeepServerXmlAsThis(boolean keepServerXmlAsThis) {
        this.keepServerXmlAsThis = keepServerXmlAsThis;
    }

    public Configuration user(String name, String pwd) {
        if (this.users == null) {
            this.users = new HashMap<String, String>();
        }
        this.users.put(name, pwd);
        return this;
    }

    public Configuration role(String user, String roles) {
        if (this.roles == null) {
            this.roles = new HashMap<String, String>();
        }
        this.roles.put(user, roles);
        return this;
    }

    public Configuration setWebXml(String webXml) {
        this.webXml = webXml;
        return this;
    }

    public String getWebXml() {
        return this.webXml;
    }

    public LoginConfigBuilder getLoginConfig() {
        return this.loginConfig;
    }

    public Configuration loginConfig(LoginConfigBuilder loginConfig) {
        this.loginConfig = loginConfig;
        return this;
    }

    public Collection<SecurityConstaintBuilder> getSecurityConstraints() {
        return this.securityConstraints;
    }

    public Configuration securityConstaint(SecurityConstaintBuilder constraint) {
        this.securityConstraints.add(constraint);
        return this;
    }

    public Realm getRealm() {
        return this.realm;
    }

    public Configuration setRealm(Realm realm) {
        this.realm = realm;
        return this;
    }
}

