/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.embedded;

import java.io.File;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.openejb.loader.JarLocation;
import org.apache.openejb.loader.ProvisioningUtil;
import org.apache.tomee.embedded.Configuration;
import org.apache.tomee.embedded.Container;

public class Main {
    public static final String PORT = "port";
    public static final String SHUTDOWN = "shutdown";
    public static final String PATH = "path";
    public static final String CONTEXT = "context";
    public static final String DIRECTORY = "directory";
    public static final String DOC_BASE = "doc-base";
    public static final String AS_WAR = "as-war";

    public static void main(String[] args) {
        CommandLine line;
        PosixParser parser = new PosixParser();
        Options options = Main.createOptions();
        try {
            line = parser.parse(options, args, true);
        }
        catch (ParseException exp) {
            new HelpFormatter().printHelp("java -jar tomee-embedded-user.jar", options);
            return;
        }
        try {
            File me;
            final Container container = new Container(Main.createConfiguration(line));
            String[] contexts = line.hasOption(CONTEXT) ? line.getOptionValues(CONTEXT) : null;
            boolean autoWar = true;
            int i = 0;
            if (line.hasOption(PATH)) {
                for (String path : line.getOptionValues(PATH)) {
                    Set locations = ProvisioningUtil.realLocation((String)path);
                    for (String location : locations) {
                        File file = new File(location);
                        if (!file.exists()) {
                            System.err.println(file.getAbsolutePath() + " does not exist, skipping");
                            continue;
                        }
                        String name = file.getName().replaceAll("\\.[A-Za-z]+$", "");
                        if (contexts != null) {
                            name = contexts[i++];
                        }
                        container.deploy(name, file, true);
                    }
                }
                autoWar = false;
            }
            if (line.hasOption(AS_WAR)) {
                container.deployClasspathAsWebApp(contexts == null || i == contexts.length ? "" : contexts[i], line.hasOption(DOC_BASE) ? new File(line.getOptionValue(DOC_BASE)) : null, new String[0]);
                autoWar = false;
            }
            if (autoWar && (me = JarLocation.jarLocation(Main.class)).getName().endsWith(".war")) {
                container.deploy(contexts == null || i == contexts.length ? "" : contexts[i], me);
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        container.stop();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            container.await();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Options createOptions() {
        Options options = new Options();
        options.addOption(null, PATH, true, "");
        options.addOption(null, CONTEXT, true, "Context name for applications (same order than paths)");
        options.addOption("p", PORT, true, "TomEE http port");
        options.addOption("s", SHUTDOWN, true, "TomEE shutdown port");
        options.addOption("d", DIRECTORY, true, "TomEE directory");
        options.addOption("c", AS_WAR, false, "deploy classpath as war");
        options.addOption("b", DOC_BASE, true, "when deploy classpath as war, the doc base");
        return options;
    }

    private static Configuration createConfiguration(CommandLine args) {
        Configuration config = new Configuration();
        config.setDir(System.getProperty("java.io.tmpdir"));
        config.setHttpPort(Integer.parseInt(args.getOptionValue(PORT, "8080")));
        config.setStopPort(Integer.parseInt(args.getOptionValue(SHUTDOWN, "8005")));
        config.setDir(args.getOptionValue(DIRECTORY, new File(new File("."), "apache-tomee").getAbsolutePath()));
        return config;
    }
}

