/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.embedded.internal;

import java.io.File;
import java.net.URL;
import java.util.List;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.webresources.StandardRoot;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.observer.Observes;
import org.apache.openejb.util.URLs;
import org.apache.openejb.util.reflection.Reflections;
import org.apache.tomee.catalina.TomcatWebAppBuilder;
import org.apache.tomee.embedded.Configuration;
import org.apache.tomee.embedded.SecurityConstaintBuilder;

public class StandardContextCustomizer {
    private final WebModule module;
    private final Configuration config;

    public StandardContextCustomizer(Configuration configuration, WebModule webModule) {
        this.module = webModule;
        this.config = configuration;
    }

    public void customize(@Observes LifecycleEvent event) {
        boolean rightPath;
        Object data = event.getSource();
        if (!StandardContext.class.isInstance(data)) {
            return;
        }
        StandardContext context = (StandardContext)StandardContext.class.cast(data);
        String contextRoot = this.module.getContextRoot();
        String path = context.getPath();
        boolean bl = path.isEmpty() && contextRoot.equals(path) || (contextRoot.startsWith("/") ? contextRoot : '/' + contextRoot).equals(path) ? true : (rightPath = false);
        if (!rightPath) {
            return;
        }
        switch (event.getType()) {
            case "before_start": {
                StandardRoot resources = new StandardRoot((Context)context);
                context.setResources((WebResourceRoot)resources);
                if (!this.module.getProperties().containsKey("fakeJarLocation")) {
                    context.setDocBase(this.module.getJarLocation());
                }
                List allResources = (List)List.class.cast(Reflections.get((Object)resources, (String)"allResources"));
                Object mainResources = allResources.remove(1);
                allResources.add(mainResources);
                for (URL url : this.module.getScannableUrls()) {
                    File file = URLs.toFile((URL)url);
                    String absolutePath = file.getAbsolutePath();
                    if (file.isDirectory()) {
                        resources.createWebResourceSet(WebResourceRoot.ResourceSetType.CLASSES_JAR, "/WEB-INF/classes", absolutePath, "", "/");
                        if (!new File(file, "META-INF/resources").exists()) continue;
                        resources.createWebResourceSet(WebResourceRoot.ResourceSetType.RESOURCE_JAR, "/", absolutePath, "", "/META-INF/resources");
                        continue;
                    }
                    resources.createWebResourceSet(WebResourceRoot.ResourceSetType.CLASSES_JAR, "/WEB-INF/lib", absolutePath, null, "/");
                    resources.createWebResourceSet(WebResourceRoot.ResourceSetType.RESOURCE_JAR, "/", url, "/META-INF/resources");
                }
                if (this.config == null) break;
                if (this.config.getLoginConfig() != null) {
                    context.setLoginConfig(this.config.getLoginConfig().build());
                }
                for (SecurityConstaintBuilder sc : this.config.getSecurityConstraints()) {
                    context.addConstraint(sc.build());
                }
                if (this.config.getWebXml() == null) break;
                context.getServletContext().setAttribute("org.apache.catalina.deploy.alt_dd", (Object)this.config.getWebXml());
                break;
            }
            case "configure_start": {
                ((TomcatWebAppBuilder)SystemInstance.get().getComponent(TomcatWebAppBuilder.class)).setFinderOnContextConfig(context, this.module.appModule());
                break;
            }
        }
    }
}

