/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.embedded.internal;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.logging.Logger;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.Loader;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.webresources.StandardRoot;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.observer.Observes;
import org.apache.openejb.util.URLs;
import org.apache.openejb.util.reflection.Reflections;
import org.apache.tomee.catalina.TomcatWebAppBuilder;
import org.apache.tomee.embedded.Configuration;
import org.apache.tomee.embedded.SecurityConstaintBuilder;

public class StandardContextCustomizer {
    private final WebModule module;
    private final Configuration config;
    private final ClassLoader loader;

    public StandardContextCustomizer(Configuration configuration, WebModule webModule, boolean keepClassloader) {
        this.module = webModule;
        this.config = configuration;
        this.loader = keepClassloader ? Thread.currentThread().getContextClassLoader() : null;
    }

    public void customize(@Observes LifecycleEvent event) {
        boolean rightPath;
        Object data = event.getSource();
        if (!StandardContext.class.isInstance(data)) {
            return;
        }
        StandardContext context = (StandardContext)StandardContext.class.cast(data);
        String contextRoot = this.module.getContextRoot();
        String path = context.getPath();
        boolean bl = path.isEmpty() && contextRoot.equals(path) || (contextRoot.startsWith("/") ? contextRoot : '/' + contextRoot).equals(path) ? true : (rightPath = false);
        if (!rightPath) {
            return;
        }
        switch (event.getType()) {
            case "before_start": {
                File file;
                StandardRoot resources = new StandardRoot((Context)context);
                resources.setCachingAllowed(this.config.areWebResourcesCached());
                context.setResources((WebResourceRoot)resources);
                if (!this.module.getProperties().containsKey("fakeJarLocation")) {
                    context.setDocBase(this.module.getJarLocation());
                }
                List allResources = (List)List.class.cast(Reflections.get((Object)resources, (String)"allResources"));
                Object mainResources = allResources.remove(1);
                allResources.add(mainResources);
                for (URL url : this.module.getScannableUrls()) {
                    file = URLs.toFile((URL)url);
                    String absolutePath = file.getAbsolutePath();
                    if (file.isDirectory()) {
                        resources.createWebResourceSet(WebResourceRoot.ResourceSetType.CLASSES_JAR, "/WEB-INF/classes", absolutePath, "", "/");
                        if (!new File(file, "META-INF/resources").exists()) continue;
                        resources.createWebResourceSet(WebResourceRoot.ResourceSetType.RESOURCE_JAR, "/", absolutePath, "", "/META-INF/resources");
                        continue;
                    }
                    if (!absolutePath.endsWith(".jar") && !Boolean.getBoolean("tomee.embedded.resources.add-war-as-jar")) continue;
                    resources.createWebResourceSet(WebResourceRoot.ResourceSetType.CLASSES_JAR, "/WEB-INF/lib", absolutePath, null, "/");
                    resources.createWebResourceSet(WebResourceRoot.ResourceSetType.RESOURCE_JAR, "/", url, "/META-INF/resources");
                }
                if (this.config.getCustomWebResources() != null) {
                    for (String web : this.config.getCustomWebResources()) {
                        file = new File(web);
                        if (file.isDirectory()) {
                            try {
                                resources.createWebResourceSet(WebResourceRoot.ResourceSetType.RESOURCE_JAR, "/", file.toURI().toURL(), "/");
                                continue;
                            }
                            catch (MalformedURLException e) {
                                throw new IllegalArgumentException(e);
                            }
                        }
                        Logger.getLogger(StandardContextCustomizer.class.getName()).warning("'" + web + "' is not a directory, ignoring");
                    }
                }
                if (this.config.getLoginConfig() != null) {
                    context.setLoginConfig(this.config.getLoginConfig().build());
                }
                for (SecurityConstaintBuilder sc : this.config.getSecurityConstraints()) {
                    context.addConstraint(sc.build());
                }
                if (this.config.getWebXml() != null) {
                    context.getServletContext().setAttribute("org.apache.catalina.deploy.alt_dd", (Object)this.config.getWebXml());
                }
                if (this.loader == null) break;
                context.setLoader((Loader)new ProvidedLoader(this.loader));
                break;
            }
            case "configure_start": {
                ((TomcatWebAppBuilder)SystemInstance.get().getComponent(TomcatWebAppBuilder.class)).setFinderOnContextConfig(context, this.module.appModule());
                break;
            }
        }
    }

    private static final class ProvidedLoader
    implements Loader {
        private final ClassLoader delegate;
        private Context context;

        private ProvidedLoader(ClassLoader loader) {
            this.delegate = loader;
        }

        public void backgroundProcess() {
        }

        public ClassLoader getClassLoader() {
            return this.delegate;
        }

        public Context getContext() {
            return this.context;
        }

        public void setContext(Context context) {
            this.context = context;
        }

        public boolean modified() {
            return false;
        }

        public boolean getDelegate() {
            return false;
        }

        public void setDelegate(boolean delegate) {
        }

        public boolean getReloadable() {
            return false;
        }

        public void setReloadable(boolean reloadable) {
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }
    }
}

