/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.loader;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.openejb.config.NewLoaderLogic;
import org.apache.openejb.util.URLs;
import org.apache.tomcat.JarScanFilter;
import org.apache.tomcat.JarScanType;
import org.apache.tomcat.JarScannerCallback;
import org.apache.tomcat.util.scan.StandardJarScanner;
import org.apache.xbean.finder.ClassLoaders;
import org.apache.xbean.finder.filter.Filter;
import org.apache.xbean.finder.filter.Filters;

public class TomEEJarScanner
extends StandardJarScanner {
    public TomEEJarScanner() {
        this.setJarScanFilter(new TomEEFilter(null));
    }

    private void configureFilter(JarScanFilter jarScanFilter) {
        this.setJarScanFilter(new TomEEFilter(jarScanFilter));
    }

    public void setJarScanFilter(JarScanFilter jarScanFilter) {
        super.setJarScanFilter(jarScanFilter);
        if (!TomEEFilter.class.isInstance(jarScanFilter)) {
            this.configureFilter(jarScanFilter);
        }
    }

    public void scan(JarScanType scanType, ServletContext context, JarScannerCallback callback) {
        super.scan(scanType, context, callback);
        this.embeddedSurefireScanning(scanType, context, callback);
    }

    private void embeddedSurefireScanning(JarScanType scanType, ServletContext context, JarScannerCallback callback) {
        if (this.isScanClassPath() && System.getProperty("surefire.real.class.path") != null) {
            Method process = null;
            try {
                Set urls = ClassLoaders.findUrls((ClassLoader)context.getClassLoader().getParent());
                boolean scanAllDirectories = this.isScanAllDirectories();
                for (URL url : urls) {
                    File cpe = URLs.toFile((URL)url);
                    if (!cpe.getName().endsWith(".jar") && scanType != JarScanType.PLUGGABILITY && !scanAllDirectories || !this.getJarScanFilter().check(scanType, cpe.getName())) continue;
                    try {
                        if (process == null && !(process = StandardJarScanner.class.getDeclaredMethod("process", JarScanType.class, JarScannerCallback.class, URL.class, String.class, Boolean.TYPE)).isAccessible()) {
                            process.setAccessible(true);
                        }
                        process.invoke((Object)this, scanType, callback, url, null, true);
                    }
                    catch (Exception ioe) {}
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    private static class TomEEFilter
    implements JarScanFilter {
        private static final Filter INCLUDE = Filters.tokens((String[])new String[]{"javax.faces-2.", "spring-security-taglibs", "spring-webmvc"});
        private final JarScanFilter delegate;

        public TomEEFilter(JarScanFilter jarScanFilter) {
            this.delegate = jarScanFilter;
        }

        public boolean check(JarScanType jarScanType, String jarName) {
            if (jarScanType == JarScanType.TLD) {
                if (INCLUDE.accept(jarName)) {
                    return true;
                }
                if (jarName.startsWith("tomcat-websocket") || jarName.startsWith("myfaces-impl")) {
                    return false;
                }
            }
            if (jarName.startsWith("johnzon-")) {
                return false;
            }
            return !NewLoaderLogic.skip((String)jarName) && (this.delegate == null || this.delegate.check(jarScanType, jarName));
        }
    }
}

