/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.crypto.SECP256K1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/apache/tuweni/devp2p/SigHash;", "", "signature", "Lorg/apache/tuweni/crypto/SECP256K1$Signature;", "hash", "Lorg/apache/tuweni/bytes/Bytes32;", "(Lorg/apache/tuweni/crypto/SECP256K1$Signature;Lorg/apache/tuweni/bytes/Bytes32;)V", "getHash", "()Lorg/apache/tuweni/bytes/Bytes32;", "getSignature", "()Lorg/apache/tuweni/crypto/SECP256K1$Signature;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "devp2p"})
public final class SigHash {
    @NotNull
    private final SECP256K1.Signature signature;
    @NotNull
    private final Bytes32 hash;

    @NotNull
    public final SECP256K1.Signature getSignature() {
        return this.signature;
    }

    @NotNull
    public final Bytes32 getHash() {
        return this.hash;
    }

    public SigHash(@NotNull SECP256K1.Signature signature, @NotNull Bytes32 hash) {
        Intrinsics.checkParameterIsNotNull((Object)signature, (String)"signature");
        Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
        this.signature = signature;
        this.hash = hash;
    }

    @NotNull
    public final SECP256K1.Signature component1() {
        return this.signature;
    }

    @NotNull
    public final Bytes32 component2() {
        return this.hash;
    }

    @NotNull
    public final SigHash copy(@NotNull SECP256K1.Signature signature, @NotNull Bytes32 hash) {
        Intrinsics.checkParameterIsNotNull((Object)signature, (String)"signature");
        Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
        return new SigHash(signature, hash);
    }

    @NotNull
    public static /* synthetic */ SigHash copy$default(SigHash sigHash2, SECP256K1.Signature signature, Bytes32 bytes32, int n, Object object) {
        if ((n & 1) != 0) {
            signature = sigHash2.signature;
        }
        if ((n & 2) != 0) {
            bytes32 = sigHash2.hash;
        }
        return sigHash2.copy(signature, bytes32);
    }

    @NotNull
    public String toString() {
        return "SigHash(signature=" + this.signature + ", hash=" + this.hash + ")";
    }

    public int hashCode() {
        SECP256K1.Signature signature = this.signature;
        Bytes32 bytes32 = this.hash;
        return (signature != null ? signature.hashCode() : 0) * 31 + (bytes32 != null ? bytes32.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof SigHash)) break block3;
                SigHash sigHash2 = (SigHash)object;
                if (!Intrinsics.areEqual((Object)this.signature, (Object)sigHash2.signature) || !Intrinsics.areEqual((Object)this.hash, (Object)sigHash2.hash)) break block3;
            }
            return true;
        }
        return false;
    }
}

