/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.discovery;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.devp2p.EthereumNodeRecord;
import org.apache.tuweni.discovery.DNSEntry;
import org.apache.tuweni.discovery.InvalidEntryException;
import org.apache.tuweni.io.Base64URLSafe;
import org.apache.tuweni.rlp.InvalidRLPEncodingException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\u0004H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000b"}, d2={"Lorg/apache/tuweni/discovery/ENRNode;", "Lorg/apache/tuweni/discovery/DNSEntry;", "attrs", "", "", "(Ljava/util/Map;)V", "nodeRecord", "Lorg/apache/tuweni/devp2p/EthereumNodeRecord;", "getNodeRecord", "()Lorg/apache/tuweni/devp2p/EthereumNodeRecord;", "toString", "dns-discovery"})
public final class ENRNode
implements DNSEntry {
    @NotNull
    private final EthereumNodeRecord nodeRecord;

    @NotNull
    public final EthereumNodeRecord getNodeRecord() {
        return this.nodeRecord;
    }

    @NotNull
    public String toString() {
        return this.nodeRecord.toString();
    }

    public ENRNode(@NotNull Map<String, String> attrs) {
        Intrinsics.checkParameterIsNotNull(attrs, (String)"attrs");
        if (attrs.get("enr") == null) {
            throw (Throwable)new InvalidEntryException("Missing attributes on enr entry");
        }
        try {
            String string = attrs.get("enr");
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Bytes bytes = Base64URLSafe.decode((String)string);
            Intrinsics.checkExpressionValueIsNotNull((Object)bytes, (String)"Base64URLSafe.decode(attrs[\"enr\"]!!)");
            this.nodeRecord = EthereumNodeRecord.Companion.fromRLP(bytes);
        }
        catch (InvalidRLPEncodingException e) {
            throw (Throwable)new InvalidEntryException(e.getMessage());
        }
    }
}

