/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.datetime;

import java.util.Locale;
import org.apache.wicket.datetime.DateConverter;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class StyleDateConverter
extends DateConverter {
    private static final long serialVersionUID = 1L;
    private final String dateStyle;

    public StyleDateConverter(boolean applyTimeZoneDifference) {
        this("S-", applyTimeZoneDifference);
    }

    public StyleDateConverter(String dateStyle, boolean applyTimeZoneDifference) {
        super(applyTimeZoneDifference);
        if (dateStyle == null) {
            throw new IllegalArgumentException("dateStyle must be not null");
        }
        this.dateStyle = dateStyle;
    }

    public final String getDatePattern() {
        return DateTimeFormat.patternForStyle((String)this.dateStyle, (Locale)this.getLocale());
    }

    protected DateTimeFormatter getFormat() {
        DateTimeFormatter dtf = DateTimeFormat.forPattern((String)this.getDatePattern()).withPivotYear(2000);
        return dtf;
    }
}

