/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.tree.table;

import java.io.Serializable;
import javax.swing.tree.TreeNode;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.extensions.markup.html.tree.table.AbstractPropertyColumn;
import org.apache.wicket.extensions.markup.html.tree.table.ColumnLocation;
import org.apache.wicket.extensions.markup.html.tree.table.IRenderable;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.Response;
import org.apache.wicket.util.string.Strings;

public class PropertyRenderableColumn<T>
extends AbstractPropertyColumn<T> {
    private static final long serialVersionUID = 1L;
    private boolean contentAsTooltip = false;
    private boolean escapeContent = true;

    public PropertyRenderableColumn(ColumnLocation location, String header, String propertyExpression) {
        this(location, (IModel<String>)Model.of((Serializable)((Object)header)), propertyExpression);
    }

    public PropertyRenderableColumn(ColumnLocation location, IModel<String> header, String propertyExpression) {
        super(location, header, propertyExpression);
    }

    public boolean isContentAsTooltip() {
        return this.contentAsTooltip;
    }

    public boolean isEscapeContent() {
        return this.escapeContent;
    }

    @Override
    public Component newCell(MarkupContainer parent, String id, TreeNode node, int level) {
        return null;
    }

    @Override
    public IRenderable newCell(TreeNode node, int level) {
        return new IRenderable(){
            private static final long serialVersionUID = 1L;

            @Override
            public void render(TreeNode node, Response response) {
                String content = PropertyRenderableColumn.this.getNodeValue(node);
                if (content == null) {
                    content = "";
                }
                if (PropertyRenderableColumn.this.isEscapeContent()) {
                    content = ((Object)Strings.escapeMarkup((CharSequence)content)).toString();
                }
                response.write((CharSequence)"<span");
                if (PropertyRenderableColumn.this.isContentAsTooltip()) {
                    response.write((CharSequence)(" title=\"" + content + "\""));
                }
                response.write((CharSequence)">");
                response.write((CharSequence)content);
                response.write((CharSequence)"</span>");
            }
        };
    }

    public void setContentAsTooltip(boolean contentAsTooltip) {
        this.contentAsTooltip = contentAsTooltip;
    }

    public void setEscapeContent(boolean escapeContent) {
        this.escapeContent = escapeContent;
    }
}

