/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.request.UrlDecoder;
import org.apache.wicket.request.UrlEncoder;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Objects;
import org.apache.wicket.util.string.StringValue;
import org.apache.wicket.util.string.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Url
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_CHARSET_NAME = "UTF-8";
    private final List<String> segments = new ArrayList<String>();
    private final List<QueryParameter> parameters = new ArrayList<QueryParameter>();
    private String charsetName;
    private transient Charset _charset;

    private static QueryParameter parseQueryParameter(String qp, Charset charset) {
        if (qp.indexOf(61) == -1) {
            return new QueryParameter(Url.decodeParameter(qp, charset), "");
        }
        String[] parts = Strings.split((String)qp, (char)'=');
        if (parts.length == 0) {
            return new QueryParameter("", "");
        }
        if (parts.length == 1) {
            return new QueryParameter("", Url.decodeParameter(parts[0], charset));
        }
        return new QueryParameter(Url.decodeParameter(parts[0], charset), Url.decodeParameter(parts[1], charset));
    }

    public static Url parse(String url) {
        return Url.parse(url, null);
    }

    public static Url parse(String url, Charset charset) {
        String query;
        String segments;
        Args.notNull((Object)url, (String)"url");
        Url result = new Url(charset);
        charset = result.getCharset();
        int qIndex = url.indexOf(63);
        if (qIndex == -1) {
            segments = url;
            query = "";
        } else {
            segments = url.substring(0, qIndex);
            query = url.substring(qIndex + 1);
        }
        if (segments.length() > 0) {
            boolean removeLast = false;
            if (segments.endsWith("/")) {
                segments = segments + "/x";
                removeLast = true;
            }
            String[] segmentArray = Strings.split((String)segments, (char)'/');
            if (removeLast) {
                segmentArray[segmentArray.length - 1] = null;
            }
            for (String s : segmentArray) {
                if (s == null) continue;
                result.segments.add(Url.decodeSegment(s, charset));
            }
        }
        if (query.length() > 0) {
            String[] queryArray;
            for (String s : queryArray = Strings.split((String)query, (char)'&')) {
                result.parameters.add(Url.parseQueryParameter(s, charset));
            }
        }
        return result;
    }

    public Charset getCharset() {
        if (Strings.isEmpty((CharSequence)this.charsetName)) {
            this.charsetName = DEFAULT_CHARSET_NAME;
        }
        if (this._charset == null) {
            this._charset = Charset.forName(this.charsetName);
        }
        return this._charset;
    }

    private void setCharset(Charset charset) {
        if (charset == null) {
            this.charsetName = DEFAULT_CHARSET_NAME;
        }
        this._charset = null;
    }

    public Url() {
    }

    public Url(Charset charset) {
        this.setCharset(charset);
    }

    public Url(Url url) {
        Args.notNull((Object)url, (String)"url");
        this.segments.addAll(url.getSegments());
        this.parameters.addAll(url.getQueryParameters());
        this.setCharset(url.getCharset());
    }

    public Url(List<String> segments, List<QueryParameter> parameters) {
        this(segments, parameters, null);
    }

    public Url(List<String> segments, List<QueryParameter> parameters, Charset charset) {
        Args.notNull(segments, (String)"segments");
        Args.notNull(parameters, (String)"parameters");
        this.segments.addAll(segments);
        this.parameters.addAll(parameters);
        this.setCharset(charset);
    }

    public List<String> getSegments() {
        return this.segments;
    }

    public List<QueryParameter> getQueryParameters() {
        return this.parameters;
    }

    public boolean isAbsolute() {
        return !this.getSegments().isEmpty() && Strings.isEmpty((CharSequence)this.getSegments().get(0));
    }

    public void removeQueryParameters(String name) {
        Iterator<QueryParameter> i = this.getQueryParameters().iterator();
        while (i.hasNext()) {
            QueryParameter param = i.next();
            if (!Objects.equal((Object)name, (Object)param.getName())) continue;
            i.remove();
        }
    }

    public void removeLeadingSegments(int count) {
        Args.withinRange((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(this.segments.size()), (Comparable)Integer.valueOf(count), (String)"count");
        for (int i = 0; i < count; ++i) {
            this.segments.remove(0);
        }
    }

    public void prependLeadingSegments(List<String> newSegments) {
        Args.notNull(newSegments, (String)"segments");
        this.segments.addAll(0, newSegments);
    }

    public void setQueryParameter(String name, Object value) {
        this.removeQueryParameters(name);
        this.addQueryParameter(name, value);
    }

    public void addQueryParameter(String name, Object value) {
        if (value != null) {
            QueryParameter parameter = new QueryParameter(name, value.toString());
            this.getQueryParameters().add(parameter);
        }
    }

    public QueryParameter getQueryParameter(String name) {
        for (QueryParameter parameter : this.parameters) {
            if (!Objects.equal((Object)name, (Object)parameter.getName())) continue;
            return parameter;
        }
        return null;
    }

    public StringValue getQueryParameterValue(String name) {
        QueryParameter parameter = this.getQueryParameter(name);
        if (parameter == null) {
            return StringValue.valueOf((String)null);
        }
        return StringValue.valueOf((String)parameter.getValue());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Url)) {
            return false;
        }
        Url rhs = (Url)obj;
        return ((Object)this.getSegments()).equals(rhs.getSegments()) && ((Object)this.getQueryParameters()).equals(rhs.getQueryParameters());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getSegments(), this.getQueryParameters()});
    }

    private static String encodeSegment(String string, Charset charset) {
        return UrlEncoder.PATH_INSTANCE.encode(string, charset);
    }

    private static String decodeSegment(String string, Charset charset) {
        return UrlDecoder.PATH_INSTANCE.decode(string, charset);
    }

    private static String encodeParameter(String string, Charset charset) {
        return UrlEncoder.QUERY_INSTANCE.encode(string, charset);
    }

    private static String decodeParameter(String string, Charset charset) {
        return UrlDecoder.QUERY_INSTANCE.decode(string, charset);
    }

    public String toString() {
        return this.toString(this.getCharset());
    }

    public String toString(Charset charset) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String s : this.getSegments()) {
            if (!first) {
                result.append('/');
            }
            first = false;
            result.append(Url.encodeSegment(s, charset));
        }
        first = true;
        for (QueryParameter p : this.getQueryParameters()) {
            if (first) {
                result.append("?");
                first = false;
            } else {
                result.append("&");
            }
            result.append(p.toString(charset));
        }
        return result.toString();
    }

    private boolean isLastSegmentReal() {
        if (this.segments.isEmpty()) {
            return false;
        }
        String last = this.segments.get(this.segments.size() - 1);
        return last.length() > 0 && !".".equals(last) && !"..".equals(last);
    }

    private boolean isLastSegmentEmpty(List<String> segments) {
        if (segments.isEmpty()) {
            return false;
        }
        String last = segments.get(segments.size() - 1);
        return last.length() == 0;
    }

    private boolean isLastSegmentEmpty() {
        return this.isLastSegmentEmpty(this.segments);
    }

    private boolean isAtLeastOnSegmentReal(List<String> segments) {
        for (String s : segments) {
            if (s.length() <= 0 || ".".equals(s) || "..".equals(s)) continue;
            return true;
        }
        return false;
    }

    public void concatSegments(List<String> segments) {
        boolean checkedLastSegment = false;
        if (!this.isAtLeastOnSegmentReal(segments) && !this.isLastSegmentEmpty(segments)) {
            segments = new ArrayList<String>(segments);
            segments.add("");
        }
        for (String s : segments) {
            if (".".equals(s)) continue;
            if ("..".equals(s) && !this.segments.isEmpty()) {
                this.segments.remove(this.segments.size() - 1);
                continue;
            }
            if (!checkedLastSegment) {
                if (this.isLastSegmentReal() || this.isLastSegmentEmpty()) {
                    this.segments.remove(this.segments.size() - 1);
                }
                checkedLastSegment = true;
            }
            this.segments.add(s);
        }
        if (this.segments.size() == 1 && this.segments.get(0).length() == 0) {
            this.segments.clear();
        }
    }

    public static final class QueryParameter
    implements Serializable {
        private final String name;
        private final String value;

        public QueryParameter(String name, String value) {
            Args.notNull((Object)name, (String)"name");
            Args.notNull((Object)value, (String)"value");
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof QueryParameter)) {
                return false;
            }
            QueryParameter rhs = (QueryParameter)obj;
            return Objects.equal((Object)this.getName(), (Object)rhs.getName()) && Objects.equal((Object)this.getValue(), (Object)rhs.getValue());
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.getName(), this.getValue()});
        }

        public String toString() {
            return this.toString(Charset.forName(Url.DEFAULT_CHARSET_NAME));
        }

        public String toString(Charset charset) {
            StringBuilder result = new StringBuilder();
            result.append(Url.encodeParameter(this.getName(), charset));
            if (!Strings.isEmpty((CharSequence)this.getValue())) {
                result.append('=');
                result.append(Url.encodeParameter(this.getValue(), charset));
            }
            return result.toString();
        }
    }
}

