/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.http;

import javax.servlet.http.Cookie;
import org.apache.wicket.request.Response;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.time.Duration;
import org.apache.wicket.util.value.LongValue;

public abstract class WebResponse
extends Response {
    public static final Duration MAX_CACHE_DURATION = Duration.days((int)365);

    public abstract void addCookie(Cookie var1);

    public abstract void clearCookie(Cookie var1);

    public abstract void setHeader(String var1, String var2);

    public abstract void setDateHeader(String var1, long var2);

    public abstract void setContentLength(long var1);

    public abstract void setContentType(String var1);

    public void setLastModifiedTime(long time) {
        this.setDateHeader("Last-Modified", time);
    }

    public void setAttachmentHeader(String filename) {
        this.setHeader("Content-Disposition", "attachment" + (!Strings.isEmpty((CharSequence)filename) ? "; filename=\"" + filename + "\"" : ""));
    }

    public void setInlineHeader(String filename) {
        this.setHeader("Content-Disposition", "inline" + (!Strings.isEmpty((CharSequence)filename) ? "; filename=\"" + filename + "\"" : ""));
    }

    public abstract void setStatus(int var1);

    public abstract void sendError(int var1, String var2);

    public abstract void sendRedirect(String var1);

    public abstract boolean isRedirect();

    public abstract void flush();

    public void disableCaching() {
        this.setDateHeader("Date", System.currentTimeMillis());
        this.setDateHeader("Expires", 0L);
        this.setHeader("Pragma", "no-cache");
        this.setHeader("Cache-Control", "no-cache, no-store");
    }

    public void enableCaching(Duration duration, CacheScope scope) {
        Args.notNull((Object)duration, (String)"duration");
        Args.notNull((Object)((Object)scope), (String)"scope");
        if (duration.compareTo((LongValue)MAX_CACHE_DURATION) > 0) {
            duration = MAX_CACHE_DURATION;
        }
        long now = System.currentTimeMillis();
        this.setDateHeader("Date", now);
        this.setDateHeader("Expires", now + duration.getMilliseconds());
        this.setHeader("Cache-Control", scope.cacheControl + ", max-age=" + duration.getMilliseconds());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CacheScope {
        PUBLIC("public"),
        PRIVATE("private");

        private final String cacheControl;

        private CacheScope(String cacheControl) {
            this.cacheControl = cacheControl;
        }
    }
}

