/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.tester;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.AbstractSingleSelectChoice;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.markup.html.form.Check;
import org.apache.wicket.markup.html.form.CheckGroup;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.FormComponentUpdatingBehavior;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.ListMultipleChoice;
import org.apache.wicket.markup.html.form.Radio;
import org.apache.wicket.markup.html.form.RadioGroup;
import org.apache.wicket.markup.html.form.upload.FileUploadField;
import org.apache.wicket.markup.html.form.upload.MultiFileUploadField;
import org.apache.wicket.protocol.http.mock.MockHttpServletRequest;
import org.apache.wicket.util.file.File;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.StringValue;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.tester.BaseWicketTester;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;
import org.junit.jupiter.api.Assertions;

public class FormTester {
    private static final String NO_FORM_FOR_PATH = "No Form componet found for path '%s'. Check if path value is correct and if form component is visible and active.";
    private int multiFileUploadIndex = 0;
    private final ChoiceSelectorFactory choiceSelectorFactory = new ChoiceSelectorFactory();
    private boolean closed = false;
    private final String path;
    private final BaseWicketTester tester;
    private final Form<?> workingForm;
    private boolean clearFeedbackMessagesBeforeSubmit = true;

    protected FormTester(String path, Form<?> workingForm, BaseWicketTester wicketTester, final boolean fillBlankString) {
        this.workingForm = Objects.requireNonNull(workingForm, String.format(NO_FORM_FOR_PATH, path));
        this.tester = wicketTester;
        this.path = path;
        workingForm.visitFormComponents(new IVisitor<FormComponent<?>, Void>(){

            public void component(FormComponent<?> formComponent, IVisit<Void> visit) {
                if (!formComponent.isVisibleInHierarchy() || !formComponent.isEnabledInHierarchy()) {
                    return;
                }
                String[] values = FormTester.getInputValue(formComponent);
                if (formComponent instanceof AbstractTextComponent && values.length == 0 && fillBlankString) {
                    FormTester.this.setFormComponentValue(formComponent, "");
                }
                for (String value : values) {
                    FormTester.this.addFormComponentValue(formComponent, value);
                }
            }
        });
        workingForm.detach();
    }

    public static String[] getInputValue(FormComponent<?> formComponent) {
        if (formComponent.isVisibleInHierarchy() && formComponent.isEnabledInHierarchy() && !(formComponent instanceof IFormSubmittingComponent)) {
            if (formComponent instanceof AbstractTextComponent) {
                return new String[]{FormTester.getFormComponentValue(formComponent)};
            }
            String value = FormTester.getFormComponentValue(formComponent);
            if (!Strings.isEmpty((String)value)) {
                return value.split(";");
            }
        }
        return new String[0];
    }

    private static String getFormComponentValue(FormComponent<?> formComponent) {
        boolean oldEscape = formComponent.getEscapeModelStrings();
        formComponent.setEscapeModelStrings(false);
        String val = formComponent.getValue();
        formComponent.setEscapeModelStrings(oldEscape);
        return val;
    }

    public Form<?> getForm() {
        return this.workingForm;
    }

    public String getTextComponentValue(String id) {
        Component c = this.getForm().get(id);
        if (c instanceof AbstractTextComponent) {
            return ((AbstractTextComponent)c).getValue();
        }
        return null;
    }

    public FormTester select(String formComponentId, int index) {
        this.checkClosed();
        FormComponent component = (FormComponent)this.workingForm.get(formComponentId);
        ChoiceSelector choiceSelector = this.choiceSelectorFactory.create(component);
        choiceSelector.doSelect(index);
        for (FormComponentUpdatingBehavior updater : component.getBehaviors(FormComponentUpdatingBehavior.class)) {
            this.tester.invokeListener((Component)component, (Behavior)updater);
        }
        return this;
    }

    public FormTester selectMultiple(String formComponentId, int[] indexes) {
        return this.selectMultiple(formComponentId, indexes, false);
    }

    public FormTester selectMultiple(String formComponentId, int[] indexes, boolean replace) {
        this.checkClosed();
        if (replace) {
            this.setValue(formComponentId, "");
        }
        ChoiceSelector choiceSelector = this.choiceSelectorFactory.createForMultiple((FormComponent)this.workingForm.get(formComponentId));
        for (int index : indexes) {
            choiceSelector.doSelect(index);
        }
        return this;
    }

    public FormTester setValue(String formComponentId, String value) {
        Component component = this.workingForm.get(formComponentId);
        Assertions.assertNotNull((Object)component, (String)("Unable to set value. Couldn't find component with name: " + formComponentId));
        return this.setValue(component, value);
    }

    public FormTester setValue(Component formComponent, String value) {
        Args.notNull((Object)formComponent, (String)"formComponent");
        this.checkClosed();
        if (formComponent instanceof IFormSubmittingComponent) {
            this.setFormSubmittingComponentValue((IFormSubmittingComponent)formComponent, value);
        } else if (formComponent instanceof FormComponent) {
            this.setFormComponentValue((FormComponent)formComponent, value);
        } else {
            this.fail("Component with id: " + formComponent.getId() + " is not a FormComponent");
        }
        return this;
    }

    public FormTester setValue(String checkBoxId, boolean value) {
        return this.setValue(checkBoxId, Boolean.toString(value));
    }

    public FormTester setFile(String formComponentId, File file, String contentType) {
        this.checkClosed();
        FormComponent formComponent = (FormComponent)this.workingForm.get(formComponentId);
        MockHttpServletRequest servletRequest = this.tester.getRequest();
        if (formComponent instanceof FileUploadField) {
            servletRequest.addFile(formComponent.getInputName(), file, contentType);
        } else if (formComponent instanceof MultiFileUploadField) {
            String inputName = formComponent.getInputName() + "_mf_" + this.multiFileUploadIndex++;
            servletRequest.addFile(inputName, file, contentType);
        } else {
            this.fail("'" + formComponentId + "' is not a FileUploadField. You can only attach a file to form component of this type.");
        }
        return this;
    }

    public FormTester submit() {
        this.checkClosed();
        try {
            if (this.clearFeedbackMessagesBeforeSubmit) {
                this.tester.clearFeedbackMessages();
            }
            this.tester.getRequest().setUseMultiPartContentType(this.workingForm.isMultiPart());
            this.tester.submitForm(this.path);
        }
        finally {
            this.closed = true;
        }
        return this;
    }

    public boolean isClearFeedbackMessagesBeforeSubmit() {
        return this.clearFeedbackMessagesBeforeSubmit;
    }

    public FormTester setClearFeedbackMessagesBeforeSubmit(boolean clearFeedbackMessagesBeforeSubmit) {
        this.clearFeedbackMessagesBeforeSubmit = clearFeedbackMessagesBeforeSubmit;
        return this;
    }

    public FormTester submit(String buttonComponentId) {
        Component submitter = this.getForm().get(buttonComponentId);
        if (submitter == null) {
            this.fail("Cannot submit the form because there is no submitting component with id: " + buttonComponentId);
        }
        return this.submit(submitter);
    }

    public FormTester submit(Component buttonComponent) {
        Args.notNull((Object)buttonComponent, (String)"buttonComponent");
        this.setValue(buttonComponent, "marked");
        if (buttonComponent instanceof AjaxButton || buttonComponent instanceof AjaxSubmitLink) {
            if (this.clearFeedbackMessagesBeforeSubmit) {
                this.tester.clearFeedbackMessages();
            }
            this.tester.getRequest().setUseMultiPartContentType(this.workingForm.isMultiPart());
            this.tester.executeAjaxEvent(buttonComponent, "click");
            return this;
        }
        return this.submit();
    }

    public FormTester submitLink(String path, boolean pageRelative) {
        if (pageRelative) {
            this.tester.clickLink((String)path, false);
        } else {
            path = this.path + ":" + (String)path;
            this.tester.clickLink((String)path, false);
        }
        return this;
    }

    private FormTester addFormComponentValue(FormComponent<?> formComponent, String value) {
        if (this.parameterExist(formComponent)) {
            ArrayList<StringValue> values = this.tester.getRequest().getPostParameters().getParameterValues(formComponent.getInputName());
            HashSet<String> all = new HashSet<String>();
            for (StringValue stringValue : values) {
                all.add(stringValue.toString());
            }
            all.add(value);
            values = new ArrayList<StringValue>();
            for (String string : all) {
                values.add(StringValue.valueOf((String)string));
            }
            this.tester.getRequest().getPostParameters().setParameterValues(formComponent.getInputName(), values);
        } else {
            this.setFormComponentValue(formComponent, value);
        }
        return this;
    }

    private void checkClosed() {
        if (this.closed) {
            this.fail("'" + this.path + "' already submitted. Note that FormTester is allowed to submit only once");
        }
    }

    private boolean parameterExist(FormComponent<?> formComponent) {
        String parameter = this.tester.getRequest().getPostParameters().getParameterValue(formComponent.getInputName()).toString();
        return parameter != null && parameter.trim().length() > 0;
    }

    private void setFormComponentValue(FormComponent<?> formComponent, String value) {
        this.tester.getRequest().getPostParameters().setParameterValue(formComponent.getInputName(), value);
    }

    private void setFormSubmittingComponentValue(IFormSubmittingComponent component, String value) {
        this.tester.getRequest().getPostParameters().setParameterValue(component.getInputName(), value);
    }

    private void fail(String message) {
        throw new WicketRuntimeException(message);
    }

    private class ChoiceSelectorFactory {
        private ChoiceSelectorFactory() {
        }

        protected ChoiceSelector create(FormComponent<?> formComponent) {
            if (formComponent == null) {
                FormTester.this.fail("Trying to select on null component.");
                return null;
            }
            if (formComponent instanceof RadioGroup || formComponent instanceof AbstractSingleSelectChoice) {
                return new SingleChoiceSelector(formComponent);
            }
            if (this.allowMultipleChoice(formComponent)) {
                return new MultipleChoiceSelector(formComponent);
            }
            FormTester.this.fail("Selecting on the component:'" + formComponent.getPath() + "' is not supported.");
            return null;
        }

        protected ChoiceSelector createForMultiple(FormComponent<?> formComponent) {
            return new MultipleChoiceSelector(formComponent);
        }

        private boolean allowMultipleChoice(FormComponent<?> formComponent) {
            return formComponent instanceof CheckGroup || formComponent instanceof ListMultipleChoice;
        }

        private final class SingleChoiceSelector
        extends ChoiceSelector {
            protected SingleChoiceSelector(FormComponent<?> formComponent) {
                super(formComponent);
            }

            @Override
            protected void assignValueToFormComponent(FormComponent<?> formComponent, String value) {
                FormTester.this.setFormComponentValue(formComponent, value);
            }
        }

        private final class MultipleChoiceSelector
        extends ChoiceSelector {
            protected MultipleChoiceSelector(FormComponent<?> formComponent) {
                super(formComponent);
                if (!ChoiceSelectorFactory.this.allowMultipleChoice(formComponent)) {
                    FormTester.this.fail("Component:'" + formComponent.getPath() + "' Does not support multiple selection.");
                }
            }

            @Override
            protected void assignValueToFormComponent(FormComponent<?> formComponent, String value) {
                FormTester.this.addFormComponentValue(formComponent, value);
            }
        }
    }

    protected abstract class ChoiceSelector {
        private final FormComponent<?> formComponent;

        protected ChoiceSelector(FormComponent<?> formComponent) {
            this.formComponent = formComponent;
        }

        protected abstract void assignValueToFormComponent(FormComponent<?> var1, String var2);

        public String getChoiceValueForIndex(int index) {
            if (this.formComponent instanceof RadioGroup) {
                Radio foundRadio = (Radio)this.formComponent.visitChildren(Radio.class, (IVisitor)new SearchOptionByIndexVisitor(index));
                if (foundRadio == null) {
                    FormTester.this.fail("RadioGroup " + this.formComponent.getPath() + " does not have index:" + index);
                    return null;
                }
                return foundRadio.getValue();
            }
            if (this.formComponent instanceof CheckGroup) {
                Check foundCheck = (Check)this.formComponent.visitChildren(Check.class, (IVisitor)new SearchOptionByIndexVisitor(index));
                if (foundCheck == null) {
                    FormTester.this.fail("CheckGroup " + this.formComponent.getPath() + " does not have index:" + index);
                    return null;
                }
                return foundCheck.getValue();
            }
            String idValue = this.selectAbstractChoice(this.formComponent, index);
            if (idValue == null) {
                FormTester.this.fail(this.formComponent.getPath() + " is not a selectable Component.");
                return null;
            }
            return idValue;
        }

        protected final void doSelect(int index) {
            String value = this.getChoiceValueForIndex(index);
            this.assignValueToFormComponent(this.formComponent, value);
        }

        private String selectAbstractChoice(FormComponent<?> formComponent, int index) {
            try {
                Method getChoicesMethod = formComponent.getClass().getMethod("getChoices", null);
                getChoicesMethod.setAccessible(true);
                List choices = (List)getChoicesMethod.invoke(formComponent, (Object[])null);
                Method getChoiceRendererMethod = formComponent.getClass().getMethod("getChoiceRenderer", null);
                getChoiceRendererMethod.setAccessible(true);
                IChoiceRenderer choiceRenderer = (IChoiceRenderer)getChoiceRendererMethod.invoke(formComponent, (Object[])null);
                return choiceRenderer.getIdValue(choices.get(index), index);
            }
            catch (SecurityException e) {
                throw new WicketRuntimeException("unexpect select failure", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
            catch (IllegalAccessException e) {
                throw new WicketRuntimeException("unexpect select failure", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new WicketRuntimeException("unexpect select failure", (Throwable)e);
            }
        }

        private final class SearchOptionByIndexVisitor
        implements IVisitor<Component, Component> {
            int count = 0;
            private final int index;

            private SearchOptionByIndexVisitor(int index) {
                this.index = index;
            }

            public void component(Component component, IVisit<Component> visit) {
                if (this.count == this.index) {
                    visit.stop((Object)component);
                } else {
                    ++this.count;
                }
            }
        }
    }
}

