/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.upload;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.wicket.util.lang.Generics;
import org.apache.wicket.util.upload.FileItemHeaders;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileItemHeadersImpl
implements FileItemHeaders,
Serializable {
    private static final long serialVersionUID = -4455695752627032559L;
    private final Map<String, List<String>> headerNameToValueListMap = Generics.newHashMap();
    private final List<String> headerNameList = Generics.newArrayList();

    @Override
    public String getHeader(String name) {
        String nameLower = name.toLowerCase();
        List<String> headerValueList = this.headerNameToValueListMap.get(nameLower);
        if (null == headerValueList) {
            return null;
        }
        return headerValueList.get(0);
    }

    @Override
    public Iterator<String> getHeaderNames() {
        return this.headerNameList.iterator();
    }

    @Override
    public Iterator<String> getHeaders(String name) {
        String nameLower = name.toLowerCase();
        List<String> headerValueList = this.headerNameToValueListMap.get(nameLower);
        if (null == headerValueList) {
            headerValueList = Collections.emptyList();
        }
        return headerValueList.iterator();
    }

    public synchronized void addHeader(String name, String value) {
        String nameLower = name.toLowerCase();
        List<String> headerValueList = this.headerNameToValueListMap.get(nameLower);
        if (null == headerValueList) {
            headerValueList = Generics.newArrayList();
            this.headerNameToValueListMap.put(nameLower, headerValueList);
            this.headerNameList.add(nameLower);
        }
        headerValueList.add(value);
    }
}

