/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.wicket.util.encoding.UrlDecoder;
import org.apache.wicket.util.file.FolderDeleteStrategy;
import org.apache.wicket.util.file.IFileCleaner;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.io.Streams;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Files {
    private static final Logger logger = LoggerFactory.getLogger(Files.class);
    private static final String URL_FILE_PREFIX = "file:";
    private static final String URL_LOCAL_JAR_FILE_PREFIX = "jar:file:";
    private static final String FILENAME_FORBIDDEN_CHARACTERS = "\"*/:<>?\\|,";

    private Files() {
    }

    public static String basePath(String path, String extension) {
        if (extension != null) {
            return path.substring(0, path.length() - extension.length() - 1);
        }
        return path;
    }

    public static String extension(String path) {
        if (path.indexOf(46) != -1) {
            return Strings.lastPathComponent(path, '.');
        }
        return null;
    }

    public static String filename(String path) {
        return Strings.lastPathComponent(path.replace('/', File.separatorChar), File.separatorChar);
    }

    public static boolean remove(File file) {
        if (file != null && file.isFile()) {
            for (int j = 0; j < 5; ++j) {
                for (int i = 0; i < 10; ++i) {
                    if (!file.delete()) continue;
                    return true;
                }
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException ix) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        return false;
    }

    public static boolean removeFolder(File folder) {
        File[] files;
        if (folder == null) {
            return false;
        }
        if (folder.isDirectory() && (files = folder.listFiles()) != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    Files.removeFolder(file);
                    continue;
                }
                Files.remove(file);
            }
        }
        return folder.delete();
    }

    public static boolean removeAsync(File file, IFileCleaner fileCleaner) {
        if (file == null || file.isDirectory()) {
            return false;
        }
        Args.notNull(fileCleaner, "fileCleaner");
        fileCleaner.track(file, new Object());
        return true;
    }

    public static boolean removeFolderAsync(File folder, IFileCleaner fileCleaner) {
        if (folder == null || folder.isFile()) {
            return false;
        }
        Args.notNull(fileCleaner, "fileCleaner");
        fileCleaner.track(folder, new Object(), new FolderDeleteStrategy());
        return true;
    }

    public static int writeTo(File file, InputStream input) throws IOException {
        return Files.writeTo(file, input, 4096);
    }

    public static byte[] readBytes(File file) throws IOException {
        try (FileInputStream stream = new FileInputStream(file);){
            byte[] byArray = IOUtils.toByteArray(stream);
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int writeTo(File file, InputStream input, int bufSize) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            int n = Streams.copy(input, out, bufSize);
            return n;
        }
    }

    public static String cleanupFilename(String filename) {
        String name = filename;
        for (int i = 0; i < FILENAME_FORBIDDEN_CHARACTERS.length(); ++i) {
            name = name.replace(FILENAME_FORBIDDEN_CHARACTERS.charAt(i), '_');
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File sourceFile, File targetFile) throws IOException {
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            in = new BufferedInputStream(new FileInputStream(sourceFile));
            out = new BufferedOutputStream(new FileOutputStream(targetFile));
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        catch (Throwable throwable) {
            try {
                IOUtils.close(in);
            }
            finally {
                IOUtils.close(out);
            }
            throw throwable;
        }
        try {
            IOUtils.close(in);
        }
        finally {
            IOUtils.close(out);
        }
    }

    public static File getLocalFileFromUrl(URL url) {
        URL location = Args.notNull(url, "url");
        return Files.getLocalFileFromUrl(UrlDecoder.PATH_INSTANCE.decode(location.toExternalForm(), "UTF-8"));
    }

    public static File getLocalFileFromUrl(String url) {
        String location = Args.notNull(url, "url");
        if (location.startsWith(URL_FILE_PREFIX)) {
            return new File(location.substring(URL_FILE_PREFIX.length()));
        }
        if (location.startsWith(URL_LOCAL_JAR_FILE_PREFIX)) {
            String path = location.substring(URL_LOCAL_JAR_FILE_PREFIX.length());
            int resourceAt = path.indexOf(33);
            if (resourceAt == -1) {
                return null;
            }
            return new File(path.substring(0, resourceAt));
        }
        return null;
    }

    public static Time getLastModified(File file) {
        long millis = file.lastModified();
        if (millis == 0L) {
            return null;
        }
        return Time.millis(millis);
    }

    public static boolean mkdirs(File folder) {
        for (int j = 0; j < 5; ++j) {
            for (int i = 0; i < 10; ++i) {
                if (!folder.mkdirs()) continue;
                return true;
            }
            try {
                Thread.sleep(100L);
                if (!folder.exists()) continue;
                return true;
            }
            catch (InterruptedException ix) {
                Thread.currentThread().interrupt();
            }
        }
        logger.error("Failed to create directory: " + folder);
        return false;
    }

    public static File[] list(File file) {
        File[] files = file.listFiles();
        if (files == null) {
            files = new File[]{};
        }
        return files;
    }
}

